/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.session.OutOfSharedMemoryException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawLock {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Locker_OFFSET = 0;
    private static final int LAST_OFFSET = Raw.align64(8);
    private static final int DEFAULT_MIN_SLEEP_NANOS = 128;
    private static final long MIN_SLEEP_NANOS = Configuration.getLockNanoSleepMin(128);
    private static final int DEFAULT_MAX_SLEEP_NANOS = 0x8000000;
    private static final long MAX_SLEEP_NANOS = Configuration.getLockNanoSleepMax(0x8000000);
    private static final int DEFAULT_MAX_YIELD = 64;
    private static final int MAX_YIELD = Configuration.getLockYieldMax(64);
    private static final int DEFAULT_MAX_SPIN = 64;
    private static final int MAX_SPIN = Configuration.getLockSpinMax(64);
    private static final RawLock rawLockKlass = new RawLock();
    private static final boolean debugRawLockWaits = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            if (System.getProperty("debugRawLockWaits", "false").equals("true")) {
                System.err.println("debugRawLockWaits = true");
                return true;
            }
            return false;
        }
    });

    @CallerSensitive
    public static RawLock klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawLockKlass;
    }

    private RawLock() {
    }

    public long create() throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        this.init(addr);
        return addr;
    }

    void init(long addr) {
        unsafe.putLong(addr, 0L);
    }

    void destroyContent(long addr) {
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align64(LAST_OFFSET);
    }

    public void lock(long addr) {
        int i;
        long gtid = rawKlass.getGlobalThreadId(Thread.currentThread().getId());
        if (unsafe.compareAndSetLong(null, addr + 0L, 0L, gtid)) {
            return;
        }
        if (unsafe.getLongVolatile(null, addr + 0L) == gtid) {
            throw new IllegalStateException("recursive lock attempt");
        }
        for (i = 0; i < MAX_SPIN; ++i) {
            if (!this.tryLock(addr, gtid)) continue;
            return;
        }
        for (i = 0; i < MAX_YIELD; ++i) {
            Thread.yield();
            if (!this.tryLock(addr, gtid)) continue;
            return;
        }
        long nanos = MIN_SLEEP_NANOS;
        int counter = 0;
        boolean debugDidWaitForLongTime = false;
        while (true) {
            unsafe.park(false, nanos);
            if (this.tryLock(addr, gtid)) {
                if (debugRawLockWaits && debugDidWaitForLongTime) {
                    System.err.println("(" + Thread.currentThread().getName() + ") : finally obtained lock");
                }
                return;
            }
            if (nanos < MAX_SLEEP_NANOS) {
                nanos <<= 1;
                continue;
            }
            if (debugRawLockWaits && ++counter % 40 == 0) {
                long locker = unsafe.getLongVolatile(null, addr + 0L);
                System.err.println("(" + Thread.currentThread().getName() + ") : VM ID " + rawKlass.extractVmId(gtid) + ", VM unique ID " + rawKlass.extractVmUid(gtid) + ", thread ID " + rawKlass.extractThreadId(gtid) + " already waiting for " + counter / 8 + " seconds for lock held by VM ID " + rawKlass.extractVmId(locker) + ", VM unique ID " + rawKlass.extractVmUid(locker) + ", thread ID " + rawKlass.extractThreadId(locker) + ", (addr " + Long.toHexString(addr + 0L) + " locker " + Long.toHexString(locker) + ") ");
                debugDidWaitForLongTime = true;
            }
            if (this.checkLifeness(addr)) continue;
            nanos = MIN_SLEEP_NANOS;
        }
    }

    public void unlock(long addr) {
        long gtid = rawKlass.getGlobalThreadId(Thread.currentThread().getId());
        if (!unsafe.compareAndSetLong(null, addr + 0L, gtid, 0L)) {
            long locker = unsafe.getLongVolatile(null, addr + 0L);
            if (locker == 0L) {
                throw new IllegalStateException("illegal unlock (already unlocked)");
            }
            throw new IllegalStateException("illegal unlock (locked by VM ID " + rawKlass.extractVmId(locker) + ", VM unique ID " + rawKlass.extractVmUid(locker) + ", thread ID " + rawKlass.extractThreadId(locker));
        }
    }

    private boolean tryLock(long addr, long myself) {
        if (unsafe.getLongVolatile(null, addr + 0L) != 0L) {
            return false;
        }
        return unsafe.compareAndSetLong(null, addr + 0L, 0L, myself);
    }

    private boolean checkLifeness(long addr) {
        long locker = unsafe.getLongVolatile(null, addr + 0L);
        if (!rawKlass.isValidGlobalThreadId(locker)) {
            unsafe.compareAndSetLong(null, addr + 0L, locker, 0L);
            return false;
        }
        return true;
    }

    public static class Array {
        private static final int Length_OFFSET = 0;
        private static final int Elems_OFFSET = Raw.align64(4);
        private static final Array rawLockArrayKlass = new Array();

        @CallerSensitive
        public static Array klass() throws SecurityException {
            Class<?> cc = Reflection.getCallerClass();
            if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
                throw new SecurityException("illegal call to raw class");
            }
            return rawLockArrayKlass;
        }

        private Array() {
        }

        public long create(int numElems) throws OutOfSharedMemoryException {
            long addr = rawKlass.allocateSharedMemory(this.memSize(numElems));
            this.init(addr, numElems);
            return addr;
        }

        void init(long addr, int numElems) {
            unsafe.setMemory(addr, this.memSize(numElems), (byte)0);
            this.setLength(addr, numElems);
        }

        public void destroy(long addr) {
            if (addr == 0L) {
                return;
            }
            rawKlass.freeSharedMemory(addr);
        }

        int memSize(int numElems) {
            return Raw.align64(Elems_OFFSET + numElems * rawLockKlass.memSize());
        }

        public int length(long addr) {
            return unsafe.getInt(addr + 0L);
        }

        private void setLength(long addr, int length) {
            unsafe.putInt(addr + 0L, length);
        }

        public void lock(long addr, int offset) {
            try {
                rawLockKlass.lock(this.getAddr(addr, offset));
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("[" + offset + "]: " + e.getMessage());
            }
        }

        public void unlock(long addr, int offset) {
            try {
                rawLockKlass.unlock(this.getAddr(addr, offset));
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("[" + offset + "]: " + e.getMessage());
            }
        }

        private long getAddr(long addr, int offset) {
            if (offset < 0 || offset >= this.length(addr)) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            return addr + (long)Elems_OFFSET + (long)(offset * rawLockKlass.memSize());
        }
    }
}

