/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawHashEntry;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawSession {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final RawHashEntry rawHashEntryKlass = RawHashEntry.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final int CreationTime_OFFSET = Raw.align64(rawHashEntryKlass.memSize());
    private static final int ExpirationTime_OFFSET = Raw.align64(CreationTime_OFFSET + 8);
    private static final int TimeoutPeriod_OFFSET = Raw.align64(ExpirationTime_OFFSET + 8);
    private static final int TotalSize_OFFSET = Raw.align64(TimeoutPeriod_OFFSET + 8);
    private static final int Deleted_OFFSET = TotalSize_OFFSET + 8;
    private static final int ChunkArray_OFFSET = Raw.align(Deleted_OFFSET + 4);
    private static final int LAST_OFFSET = ChunkArray_OFFSET + Raw.SIZEOF_ADDRESS;
    public static final int TYPE = 3;
    private static final int DEFAULT_INITIAL_NUM_CHUNKS = 2;
    private static final int INITIAL_NUM_CHUNKS = Configuration.getInitialChunksPerSession(2);
    private static final RawSession rawSessionKlass = new RawSession();

    @CallerSensitive
    public static RawSession klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawSessionKlass;
    }

    private RawSession() {
    }

    public long create(String name) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr, name);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr, String name) throws OutOfSharedMemoryException {
        rawHashEntryKlass.init(addr, 3, name);
        this.setChunkArray(addr, rawAddressArrayKlass.create(INITIAL_NUM_CHUNKS));
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawHashEntryKlass.destroyContent(addr);
        rawAddressArrayKlass.destroy(this.getChunkArray(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public long getCreationTime(long addr) {
        return unsafe.getLong(addr + (long)CreationTime_OFFSET);
    }

    public void setCreationTime(long addr, long value) {
        unsafe.putLong(addr + (long)CreationTime_OFFSET, value);
    }

    public long getExpirationTime(long addr) {
        return unsafe.getLong(addr + (long)ExpirationTime_OFFSET);
    }

    public void setExpirationTime(long addr, long value) {
        unsafe.putLong(addr + (long)ExpirationTime_OFFSET, value);
    }

    public long getTimeoutPeriod(long addr) {
        return unsafe.getLong(addr + (long)TimeoutPeriod_OFFSET);
    }

    public void setTimeoutPeriod(long addr, long value) {
        unsafe.putLong(addr + (long)TimeoutPeriod_OFFSET, value);
    }

    public long getTotalSize(long addr) {
        return unsafe.getLong(addr + (long)TotalSize_OFFSET);
    }

    public void setTotalSize(long addr, long value) {
        unsafe.putLong(addr + (long)TotalSize_OFFSET, value);
    }

    public boolean isDeleted(long addr) {
        return unsafe.getInt(addr + (long)Deleted_OFFSET) != 0;
    }

    public void setDeleted(long addr, boolean value) {
        unsafe.putInt(addr + (long)Deleted_OFFSET, value ? 1 : 0);
    }

    public long getChunkArray(long addr) {
        return unsafe.getAddress(addr + (long)ChunkArray_OFFSET);
    }

    public void setChunkArray(long addr, long value) {
        unsafe.putAddress(addr + (long)ChunkArray_OFFSET, value);
    }

    public long getName(long addr) {
        return rawHashEntryKlass.getName(addr);
    }

    public long getNext(long addr) {
        return rawHashEntryKlass.getNext(addr);
    }

    public void setNext(long addr, long value) {
        rawHashEntryKlass.setNext(addr, value);
    }

    public int getHandle(long addr) {
        return rawHashEntryKlass.getHandle(addr);
    }

    public void setHandle(long addr, int value) {
        rawHashEntryKlass.setHandle(addr, value);
    }

    public int getType(long addr) {
        return rawHashEntryKlass.getType(addr);
    }
}

