/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.Configuration;
import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawHashMap;
import com.sap.jvm.impl.session.raw.RawItem;
import com.sap.jvm.impl.session.raw.RawString;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawSessionStore {
    private static final RawString rawStringKlass = RawString.klass();
    private static final RawItem rawItemKlass = RawItem.klass();
    private static final RawHashMap rawHashMapKlass = RawHashMap.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int NumChunkNames_OFFSET = Raw.align(rawItemKlass.memSize());
    private static final int ChunkNames_OFFSET = Raw.align(NumChunkNames_OFFSET + 4);
    private static final int DomainMap_OFFSET = Raw.align(ChunkNames_OFFSET + Raw.SIZEOF_ADDRESS);
    private static final int LAST_OFFSET = DomainMap_OFFSET + rawHashMapKlass.memSize();
    public static final int TYPE = 1;
    private static final int DEFAULT_INITIAL_CHUNK_NAMES_LENGTH = 2;
    private static final int INITIAL_CHUNK_NAMES_LENGTH = Configuration.getInitialChunksPerSession(2);
    private static final int DEFAULT_INITIAL_DOMAIN_MAP_SIZE = 1024;
    private static final int INITIAL_DOMAIN_MAP_SIZE = Configuration.getInitialDomains(1024);
    private static final RawSessionStore rawSessionStoreKlass = new RawSessionStore();

    @CallerSensitive
    public static RawSessionStore klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawSessionStoreKlass;
    }

    private RawSessionStore() {
    }

    public long create() throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr) throws OutOfSharedMemoryException {
        rawItemKlass.init(addr, 1);
        this.setChunkNames(addr, rawAddressArrayKlass.create(INITIAL_CHUNK_NAMES_LENGTH));
        rawHashMapKlass.init(this.getDomainMap(addr), INITIAL_DOMAIN_MAP_SIZE);
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawItemKlass.destroyContent(addr);
        long chunkNames = this.getChunkNames(addr);
        if (chunkNames != 0L) {
            for (int i = 0; i < rawAddressArrayKlass.length(chunkNames); ++i) {
                rawStringKlass.destroy(rawAddressArrayKlass.get(chunkNames, i));
            }
            rawAddressArrayKlass.destroy(chunkNames);
        }
        rawHashMapKlass.destroyContent(this.getDomainMap(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public int getNumChunkNames(long addr) {
        return unsafe.getInt(addr + (long)NumChunkNames_OFFSET);
    }

    private void setNumChunkNames(long addr, int value) {
        unsafe.putInt(addr + (long)NumChunkNames_OFFSET, value);
    }

    public long getChunkNames(long addr) {
        return unsafe.getAddress(addr + (long)ChunkNames_OFFSET);
    }

    private void setChunkNames(long addr, long value) {
        unsafe.putAddress(addr + (long)ChunkNames_OFFSET, value);
    }

    public Integer addChunkName(long addr, String chunkName) throws OutOfSharedMemoryException {
        long rawChunkNames = this.getChunkNames(addr);
        int length = rawAddressArrayKlass.length(rawChunkNames);
        int numChunkNames = this.getNumChunkNames(addr);
        if (numChunkNames + 1 >= length) {
            long newRawChunkNames = rawAddressArrayKlass.create(length * 2);
            for (int i = 0; i < length; ++i) {
                rawAddressArrayKlass.set(newRawChunkNames, i, rawAddressArrayKlass.get(rawChunkNames, i));
            }
            this.setChunkNames(addr, newRawChunkNames);
            rawAddressArrayKlass.destroy(rawChunkNames);
            rawChunkNames = newRawChunkNames;
        }
        long rawChunkName = rawStringKlass.create(chunkName);
        rawAddressArrayKlass.set(rawChunkNames, numChunkNames, rawChunkName);
        this.setNumChunkNames(addr, numChunkNames + 1);
        return numChunkNames;
    }

    public long getDomainMap(long addr) {
        return addr + (long)DomainMap_OFFSET;
    }

    public int getHandle(long addr) {
        return rawItemKlass.getHandle(addr);
    }

    public void setHandle(long addr, int value) {
        rawItemKlass.setHandle(addr, value);
    }

    public int getType(long addr) {
        return rawItemKlass.getType(addr);
    }
}

