/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.impl.session.raw.RawAddressArray;
import com.sap.jvm.impl.session.raw.RawLock;
import com.sap.jvm.impl.session.raw.RawSessionStore;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawSharedPool {
    private static final RawSessionStore rawSessionStoreKlass = RawSessionStore.klass();
    private static final RawLock.Array rawLockArrayKlass = RawLock.Array.klass();
    private static final RawAddressArray rawAddressArrayKlass = RawAddressArray.klass();
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int FreeHandles_OFFSET = 0;
    private static final int NextHandle_OFFSET = 4;
    private static final int Handles_OFFSET = Raw.align(8);
    private static final int Locks_OFFSET = Raw.align(Handles_OFFSET + Raw.SIZEOF_ADDRESS);
    private static final int LAST_OFFSET = Raw.align(Locks_OFFSET + Raw.SIZEOF_ADDRESS);
    public static int INITIAL_NEXT_HANDLE = 0;
    public static int SESSION_STORE_HANDLE = 0;
    public static int NUM_PREDEFINED_HANDLES = 1;
    private static final RawSharedPool rawSharedPoolKlass = new RawSharedPool();

    @CallerSensitive
    public static RawSharedPool klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawSharedPoolKlass;
    }

    private RawSharedPool() {
    }

    public long create(int numHandles, int numLocks) throws OutOfSharedMemoryException {
        long addr = rawKlass.allocateSharedMemory(this.memSize());
        unsafe.setMemory(addr, this.memSize(), (byte)0);
        try {
            this.init(addr, numHandles, numLocks);
        }
        catch (OutOfSharedMemoryException e) {
            this.destroy(addr);
            throw e;
        }
        return addr;
    }

    void init(long addr, int numHandles, int numLocks) throws OutOfSharedMemoryException {
        this.setFreeHandlesVolatile(addr, numHandles - NUM_PREDEFINED_HANDLES);
        this.setNextHandleVolatile(addr, INITIAL_NEXT_HANDLE + NUM_PREDEFINED_HANDLES);
        long handles = rawAddressArrayKlass.create(numHandles);
        this.setHandles(addr, handles);
        this.setLocks(addr, rawLockArrayKlass.create(numLocks));
        long sessionStore = rawSessionStoreKlass.create();
        rawSessionStoreKlass.setHandle(sessionStore, SESSION_STORE_HANDLE);
        rawAddressArrayKlass.set(handles, SESSION_STORE_HANDLE, sessionStore);
    }

    void destroyContent(long addr) {
        if (addr == 0L) {
            return;
        }
        rawSessionStoreKlass.destroy(this.getSessionStore(addr));
        rawAddressArrayKlass.destroy(this.getHandles(addr));
        rawLockArrayKlass.destroy(this.getLocks(addr));
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize() {
        return Raw.align(LAST_OFFSET);
    }

    public int getFreeHandlesVolatile(long addr) {
        return unsafe.getIntVolatile(null, addr + 0L);
    }

    public void atomicAddFreeHandles(long addr, int value) {
        int freeHandles;
        while (!unsafe.compareAndSetInt(null, addr + 0L, freeHandles = unsafe.getIntVolatile(null, addr + 0L), freeHandles + value)) {
        }
    }

    private void setFreeHandlesVolatile(long addr, int value) {
        unsafe.putIntVolatile(null, addr + 0L, value);
    }

    public int getNextHandleVolatile(long addr) {
        return unsafe.getIntVolatile(null, addr + 4L);
    }

    private void setNextHandleVolatile(long addr, int value) {
        unsafe.putIntVolatile(null, addr + 4L, value);
    }

    public boolean atomicSwapNextHandle(long addr, int expected, int value) {
        return unsafe.compareAndSetInt(null, addr + 4L, expected, value);
    }

    public long getHandles(long addr) {
        return unsafe.getAddress(addr + (long)Handles_OFFSET);
    }

    private void setHandles(long addr, long value) {
        unsafe.putAddress(addr + (long)Handles_OFFSET, value);
    }

    public long getLocks(long addr) {
        return unsafe.getAddress(addr + (long)Locks_OFFSET);
    }

    private void setLocks(long addr, long value) {
        unsafe.putAddress(addr + (long)Locks_OFFSET, value);
    }

    private long getSessionStore(long addr) {
        long handles = this.getHandles(addr);
        if (handles == 0L) {
            return 0L;
        }
        return rawAddressArrayKlass.get(handles, SESSION_STORE_HANDLE);
    }
}

