/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.session.raw;

import com.sap.jvm.impl.session.raw.Raw;
import com.sap.jvm.session.OutOfSharedMemoryException;
import jdk.internal.misc.Unsafe;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class RawString {
    private static final Raw rawKlass = Raw.klass();
    private static final Unsafe unsafe = rawKlass.getUnsafe();
    private static final int Length_OFFSET = 0;
    private static final int Hash_OFFSET = 4;
    private static final int Value_OFFSET = 8;
    private static final int LAST_OFFSET = 8;
    private static final RawString rawStringKlass = new RawString();

    @CallerSensitive
    public static RawString klass() throws SecurityException {
        Class<?> cc = Reflection.getCallerClass();
        if (cc.getClassLoader() != null && cc.getClassLoader() != Raw.platformClassLoader) {
            throw new SecurityException("illegal call to raw class");
        }
        return rawStringKlass;
    }

    private RawString() {
    }

    public long create(String str) throws OutOfSharedMemoryException {
        int len = str.length();
        long addr = rawKlass.allocateSharedMemory(this.memSize(len));
        this.init(addr, str);
        return addr;
    }

    void init(long addr, String str) {
        int len = str.length();
        this.setLength(addr, len);
        this.setHashCode(addr, str.hashCode());
        for (int i = 0; i < len; ++i) {
            this.setCharAt(addr, i, str.charAt(i));
        }
    }

    void destroyContent(long addr) {
    }

    public void destroy(long addr) {
        if (addr == 0L) {
            return;
        }
        this.destroyContent(addr);
        rawKlass.freeSharedMemory(addr);
    }

    int memSize(int numChars) {
        return Raw.align(8 + numChars * 2);
    }

    public boolean equals(long addr, String str) {
        int len = this.length(addr);
        if (len != str.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.charAt(addr, i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String asJavaString(long addr) {
        int len = this.length(addr);
        char[] value = new char[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.charAt(addr, i);
        }
        return new String(value);
    }

    public int length(long addr) {
        return unsafe.getInt(addr + 0L);
    }

    private void setLength(long addr, int length) {
        unsafe.putInt(addr + 0L, length);
    }

    public char charAt(long addr, int offset) {
        if (offset < 0 || offset >= this.length(addr)) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + offset + " < 0 || " + offset + " >= " + this.length(addr));
        }
        return unsafe.getChar(addr + 8L + (long)(offset * 2));
    }

    private void setCharAt(long addr, int offset, char c) {
        unsafe.putChar(addr + 8L + (long)(offset * 2), c);
    }

    public int hashCode(long addr) {
        return unsafe.getInt(addr + 4L);
    }

    private void setHashCode(long addr, int hash) {
        unsafe.putInt(addr + 4L, hash);
    }
}

