/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.tracing;

import com.sap.jvm.impl.tracing.TracingService;
import com.sap.jvm.tracing.Tracer;
import java.util.function.Supplier;

final class TracerImpl
implements Tracer {
    private final String component;
    private final Object context;
    private Tracer.TraceLevel traceLevel = TracingService.DEFAULT_TRACE_LEVEL;
    private Tracer.LocationType debugLocationType = Tracer.LocationType.NONE;
    private Tracer.LocationType infoLocationType = Tracer.LocationType.NONE;
    private Tracer.LocationType warnLocationType = Tracer.LocationType.NONE;
    private Tracer.LocationType errorLocationType = Tracer.LocationType.NONE;

    public TracerImpl(String component) {
        this(component, null);
    }

    public TracerImpl(String component, Object context) {
        this.component = component;
        this.context = context;
        this.traceLevel = TracingService.getTraceLevelFromProperty(component + ".TraceLevel", TracingService.DEFAULT_TRACE_LEVEL);
        Tracer.LocationType defaultLocationType = TracingService.getLocationTypeFromProperty(component + ".LocationType", TracingService.DEFAULT_LOCATION_TYPE);
        this.errorLocationType = TracingService.getLocationTypeFromProperty(component + ".LocationType.error", defaultLocationType);
        this.warnLocationType = TracingService.getLocationTypeFromProperty(component + ".LocationType.warn", defaultLocationType);
        this.infoLocationType = TracingService.getLocationTypeFromProperty(component + ".LocationType.info", defaultLocationType);
        this.debugLocationType = TracingService.getLocationTypeFromProperty(component + ".LocationType.debug", defaultLocationType);
    }

    @Override
    public Tracer.TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public void setTraceLevel(Tracer.TraceLevel value) {
        this.traceLevel = value;
    }

    @Override
    public Tracer.LocationType getDebugLocationType() {
        return this.debugLocationType;
    }

    @Override
    public void setDebugLocationType(Tracer.LocationType locationType) {
        this.debugLocationType = locationType;
    }

    @Override
    public Tracer.LocationType getInfoLocationType() {
        return this.infoLocationType;
    }

    @Override
    public void setInfoLocationType(Tracer.LocationType locationType) {
        this.infoLocationType = locationType;
    }

    @Override
    public Tracer.LocationType getWarnLocationType() {
        return this.warnLocationType;
    }

    @Override
    public void setWarnLocationType(Tracer.LocationType locationType) {
        this.warnLocationType = locationType;
    }

    @Override
    public Tracer.LocationType getErrorLocationType() {
        return this.errorLocationType;
    }

    @Override
    public void setErrorLocationType(Tracer.LocationType type) {
        this.errorLocationType = type;
    }

    @Override
    public void setLocationType(Tracer.LocationType locationType) {
        this.debugLocationType = locationType;
        this.infoLocationType = locationType;
        this.warnLocationType = locationType;
        this.errorLocationType = locationType;
    }

    @Override
    public Object context() {
        return this.context;
    }

    @Override
    public void debug(String message) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, message);
        }
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, supplier.get());
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, String.format(format, args));
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, throwable, throwable.getMessage());
        }
    }

    @Override
    public void debug(Throwable throwable, String message) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, throwable, message);
        }
    }

    @Override
    public void debug(Throwable throwable, Supplier<String> supplier) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, supplier.get());
        }
    }

    @Override
    public void debug(Throwable throwable, String format, Object ... args) {
        if (this.traceLevel.debug() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.DEBUG, this.debugLocationType, throwable, String.format(format, args));
        }
    }

    @Override
    public void info(String message) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, message);
        }
    }

    @Override
    public void info(Supplier<String> supplier) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, supplier.get());
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, String.format(format, args));
        }
    }

    @Override
    public void info(Throwable throwable) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, throwable, throwable.getMessage());
        }
    }

    @Override
    public void info(Throwable throwable, String message) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, throwable, message);
        }
    }

    @Override
    public void info(Throwable throwable, Supplier<String> supplier) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, supplier.get());
        }
    }

    @Override
    public void info(Throwable throwable, String format, Object ... args) {
        if (this.traceLevel.info() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.INFO, this.infoLocationType, throwable, String.format(format, args));
        }
    }

    @Override
    public void warn(String message) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, message);
        }
    }

    @Override
    public void warn(Supplier<String> supplier) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, supplier.get());
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, String.format(format, args));
        }
    }

    @Override
    public void warn(Throwable throwable) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, throwable.getMessage());
        }
    }

    @Override
    public void warn(Throwable throwable, String message) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, throwable, message);
        }
    }

    @Override
    public void warn(Throwable throwable, Supplier<String> supplier) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, throwable, supplier.get());
        }
    }

    @Override
    public void warn(Throwable throwable, String format, Object ... args) {
        if (this.traceLevel.warn() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.WARN, this.warnLocationType, throwable, String.format(format, args));
        }
    }

    @Override
    public void error(String message) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, message);
        }
    }

    @Override
    public void error(Supplier<String> supplier) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, supplier.get());
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, String.format(format, args));
        }
    }

    @Override
    public void error(Throwable throwable) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, throwable, throwable.getMessage());
        }
    }

    @Override
    public void error(Throwable throwable, String message) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, throwable, message);
        }
    }

    @Override
    public void error(Throwable throwable, Supplier<String> supplier) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, throwable, supplier.get());
        }
    }

    @Override
    public void error(Throwable throwable, String format, Object ... args) {
        if (this.traceLevel.error() && TracingService.hasListeners()) {
            this.traceImpl(Tracer.TraceLevel.ERROR, this.errorLocationType, throwable, String.format(format, args));
        }
    }

    private String getMethodAndLineString() {
        StackTraceElement el = new Exception().getStackTrace()[3];
        return el.getClassName() + "." + el.getMethodName() + "(" + el.getFileName() + ":" + el.getLineNumber() + "): ";
    }

    private String getStackTraceString() {
        StringBuilder stackTraceBuilder = new StringBuilder();
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 3; i < stackTrace.length; ++i) {
            StackTraceElement el = stackTrace[i];
            stackTraceBuilder.append("\n        at " + el.getClassName() + "." + el.getMethodName() + "(" + el.getFileName() + ":" + el.getLineNumber() + ")");
        }
        return stackTraceBuilder.toString();
    }

    private void traceImpl(Tracer.TraceLevel level, Tracer.LocationType type, Throwable throwable, String message) {
        if (type == Tracer.LocationType.STACK) {
            TracingService.doTrace(level, this.component, this.context, throwable, message + this.getStackTraceString());
        } else if (type == Tracer.LocationType.METHOD) {
            TracingService.doTrace(level, this.component, this.context, throwable, this.getMethodAndLineString() + message);
        } else {
            TracingService.doTrace(level, this.component, this.context, throwable, message);
        }
    }

    private void traceImpl(Tracer.TraceLevel level, Tracer.LocationType type, String message) {
        if (type == Tracer.LocationType.STACK) {
            TracingService.doTrace(level, this.component, this.context, null, message + this.getStackTraceString());
        } else if (type == Tracer.LocationType.METHOD) {
            TracingService.doTrace(level, this.component, this.context, null, this.getMethodAndLineString() + message);
        } else {
            TracingService.doTrace(level, this.component, this.context, null, message);
        }
    }
}

