/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.tracing;

import com.sap.jvm.impl.tracing.TracerImpl;
import com.sap.jvm.tracing.TraceListener;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.tracing.TracingServiceInterface;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class TracingService
implements TracingServiceInterface {
    private static Map<ComponentWithContext, WeakReference<TracerImpl>> tracers = new HashMap<ComponentWithContext, WeakReference<TracerImpl>>();
    private static final Object tracersLock = new Object();
    private static List<TraceListener> listeners = new ArrayList<TraceListener>();
    private static final Object listenersLock = new Object();
    static Tracer.TraceLevel DEFAULT_TRACE_LEVEL = TracingService.getTraceLevelFromProperty("com.sap.jvm.tracing.DefaultTraceLevel", Tracer.TraceLevel.NONE);
    static Tracer.LocationType DEFAULT_LOCATION_TYPE = TracingService.getLocationTypeFromProperty("com.sap.jvm.tracing.DefaultLocationType", Tracer.LocationType.NONE);
    static StderrTraceListener stderrTraceListener;
    static FileTraceListener fileTraceListener;

    static Tracer.TraceLevel getTraceLevelFromProperty(String prop, Tracer.TraceLevel defaultLevel) {
        String propVal = AccessController.doPrivileged(() -> System.getProperty(prop));
        if ("DEBUG".equalsIgnoreCase(propVal)) {
            return Tracer.TraceLevel.DEBUG;
        }
        if ("WARN".equalsIgnoreCase(propVal)) {
            return Tracer.TraceLevel.WARN;
        }
        if ("ERROR".equalsIgnoreCase(propVal)) {
            return Tracer.TraceLevel.ERROR;
        }
        if ("NONE".equalsIgnoreCase(propVal)) {
            return Tracer.TraceLevel.NONE;
        }
        return defaultLevel;
    }

    static Tracer.LocationType getLocationTypeFromProperty(String prop, Tracer.LocationType defaultType) {
        String propVal = AccessController.doPrivileged(() -> System.getProperty(prop));
        if ("STACK".equalsIgnoreCase(propVal)) {
            return Tracer.LocationType.STACK;
        }
        if ("METHOD".equalsIgnoreCase(propVal)) {
            return Tracer.LocationType.METHOD;
        }
        if ("NONE".equalsIgnoreCase(propVal)) {
            return Tracer.LocationType.NONE;
        }
        return defaultType;
    }

    static boolean hasListeners() {
        return !listeners.isEmpty();
    }

    static void doTrace(Tracer.TraceLevel level, String component, Object context, Throwable throwable, String message) {
        for (TraceListener listener : listeners) {
            if (throwable == null) {
                listener.toTrace(level, component, context, message);
                continue;
            }
            listener.toTrace(level, component, context, throwable, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tracer get(String name, Object context) {
        TracerImpl result;
        ComponentWithContext key = new ComponentWithContext(name, context);
        WeakReference<TracerImpl> reference = tracers.get(key);
        TracerImpl tracerImpl = result = reference != null ? (TracerImpl)reference.get() : null;
        if (result != null) {
            return result;
        }
        Object object = tracersLock;
        synchronized (object) {
            reference = tracers.get(key);
            TracerImpl tracerImpl2 = result = reference != null ? (TracerImpl)reference.get() : null;
            if (result == null) {
                HashMap<ComponentWithContext, WeakReference<TracerImpl>> newTracers = new HashMap<ComponentWithContext, WeakReference<TracerImpl>>(tracers.size() + 1);
                for (ComponentWithContext currKey : tracers.keySet()) {
                    reference = tracers.get(currKey);
                    if (reference.get() == null) continue;
                    newTracers.put(currKey, reference);
                }
                result = new TracerImpl(name, context);
                newTracers.put(key, new WeakReference<TracerImpl>(result));
                tracers = newTracers;
            }
        }
        return result;
    }

    @Override
    public void setDefaultTraceLevel(Tracer.TraceLevel level) {
        DEFAULT_TRACE_LEVEL = level;
    }

    @Override
    public void setTraceLevel(Pattern pattern, Tracer.TraceLevel level) {
        for (ComponentWithContext key : tracers.keySet()) {
            Tracer t = (Tracer)tracers.get(key).get();
            if (t == null || !pattern.matcher(key.component).matches()) continue;
            t.setTraceLevel(level);
        }
    }

    @Override
    public void setDefaultLocationType(Tracer.LocationType locationType) {
        DEFAULT_LOCATION_TYPE = locationType;
    }

    @Override
    public void setLocationType(Pattern pattern, Tracer.LocationType locationType) {
        for (ComponentWithContext key : tracers.keySet()) {
            Tracer t = (Tracer)tracers.get(key).get();
            if (t == null || !pattern.matcher(key.component).matches()) continue;
            t.setLocationType(locationType);
        }
    }

    @Override
    public void enableStdErrOutput(boolean detailed) {
        StderrTraceListener.enable(detailed);
    }

    @Override
    public void disableStdErrOutput() {
        StderrTraceListener.disable();
    }

    @Override
    public boolean enableFileOutput(String fileName, boolean detailed) {
        return FileTraceListener.enable(fileName, detailed);
    }

    @Override
    public void disableFileOutput() {
        FileTraceListener.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addListener(TraceListener listener) {
        if (listeners.contains(listener)) {
            return;
        }
        Object object = listenersLock;
        synchronized (object) {
            ArrayList<TraceListener> newListeners = new ArrayList<TraceListener>(listeners);
            newListeners.add(listener);
            listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeListener(TraceListener listener) {
        boolean rc;
        if (!listeners.contains(listener)) {
            return false;
        }
        Object object = listenersLock;
        synchronized (object) {
            ArrayList<TraceListener> newListeners = new ArrayList<TraceListener>(listeners);
            rc = newListeners.remove(listener);
            listeners = newListeners;
        }
        return rc;
    }

    static {
        String stderrlevel = AccessController.doPrivileged(() -> System.getProperty("com.sap.jvm.tracing.TraceToStdErr"));
        String fileLevel = AccessController.doPrivileged(() -> System.getProperty("com.sap.jvm.tracing.TraceToFile"));
        String fileName = AccessController.doPrivileged(() -> System.getProperty("com.sap.jvm.tracing.FileName", "sapjvmtrc.txt"));
        if ("TRUE".equalsIgnoreCase(stderrlevel)) {
            stderrTraceListener = new StderrTraceListener(false);
            listeners.add(stderrTraceListener);
        } else if ("DETAILED".equalsIgnoreCase(stderrlevel)) {
            stderrTraceListener = new StderrTraceListener(true);
            listeners.add(stderrTraceListener);
        }
        if ("TRUE".equalsIgnoreCase(fileLevel)) {
            fileTraceListener = new FileTraceListener(fileName, false);
            listeners.add(fileTraceListener);
        } else if ("DETAILED".equalsIgnoreCase(fileLevel)) {
            fileTraceListener = new FileTraceListener(fileName, true);
            listeners.add(fileTraceListener);
        }
    }

    private static class ComponentWithContext {
        private final String component;
        private final Object context;

        private ComponentWithContext(String component, Object context) {
            if (component == null) {
                throw new NullPointerException("Parameter name must not be null.");
            }
            this.component = component;
            this.context = context;
        }

        public int hashCode() {
            return this.component.hashCode() ^ (this.context == null ? 0 : this.context.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentWithContext other = (ComponentWithContext)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return this.component.equals(other.component);
        }
    }

    private static class FileTraceListener
    extends DefaultTraceListener
    implements Closeable {
        private String fileName = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean enable(String fileName, boolean detailed) {
            if (fileName == null) {
                return false;
            }
            Object object = listenersLock;
            synchronized (object) {
                if (fileTraceListener != null) {
                    if (fileName != TracingService.fileTraceListener.fileName && !fileTraceListener.startTracing(fileName)) {
                        return false;
                    }
                    fileTraceListener.setDetailed(detailed);
                } else {
                    fileTraceListener = new FileTraceListener(fileName, detailed);
                    if (TracingService.fileTraceListener.stream == null) {
                        fileTraceListener = null;
                        return false;
                    }
                    ArrayList<FileTraceListener> newListeners = new ArrayList<FileTraceListener>(listeners);
                    newListeners.add(fileTraceListener);
                    listeners = newListeners;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void disable() {
            Object object = listenersLock;
            synchronized (object) {
                if (fileTraceListener != null) {
                    ArrayList newListeners = new ArrayList(listeners);
                    newListeners.remove(fileTraceListener);
                    listeners = newListeners;
                    fileTraceListener.close();
                    fileTraceListener = null;
                }
            }
        }

        private boolean startTracing(String fileName) {
            this.close();
            try {
                this.fileName = fileName;
                this.stream = new PrintStream(new File(fileName));
            }
            catch (FileNotFoundException e) {
                fileName = null;
                return false;
            }
            this.stream.println("Started logging (" + new Date() + ")...");
            return true;
        }

        public FileTraceListener(String fileName, boolean detailed) {
            super(detailed);
            this.startTracing(fileName);
        }

        @Override
        public synchronized void close() {
            if (this.stream != null) {
                this.stream.println("Stopped logging (" + new Date() + ")...");
                this.stream.close();
            }
            this.stream = null;
            this.fileName = null;
        }
    }

    private static class StderrTraceListener
    extends DefaultTraceListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void enable(boolean detailed) {
            Object object = listenersLock;
            synchronized (object) {
                if (stderrTraceListener != null) {
                    stderrTraceListener.setDetailed(detailed);
                } else {
                    stderrTraceListener = new StderrTraceListener(detailed);
                    ArrayList<StderrTraceListener> newListeners = new ArrayList<StderrTraceListener>(listeners);
                    newListeners.add(stderrTraceListener);
                    listeners = newListeners;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void disable() {
            Object object = listenersLock;
            synchronized (object) {
                if (stderrTraceListener != null) {
                    ArrayList newListeners = new ArrayList(listeners);
                    newListeners.remove(stderrTraceListener);
                    listeners = newListeners;
                    stderrTraceListener = null;
                }
            }
        }

        private StderrTraceListener(boolean detailed) {
            super(detailed);
            this.stream = System.err;
        }
    }

    private static abstract class DefaultTraceListener
    implements TraceListener {
        protected PrintStream stream = null;
        private boolean detailed;

        private DefaultTraceListener(boolean detailed) {
            this.detailed = detailed;
        }

        public void setDetailed(boolean detailed) {
            this.detailed = detailed;
        }

        @Override
        public void toTrace(Tracer.TraceLevel level, String component, Object context, String message) {
            this.toTrace(level, component, context, null, message);
        }

        @Override
        public synchronized void toTrace(Tracer.TraceLevel level, String component, Object context, Throwable throwable, String message) {
            if (this.detailed) {
                StringBuilder sb = new StringBuilder();
                sb.append(new Date());
                sb.append(" - ");
                switch (level) {
                    case DEBUG: {
                        sb.append("DEBUG");
                        break;
                    }
                    case WARN: {
                        sb.append("WARNING");
                        break;
                    }
                    case ERROR: {
                        sb.append("ERROR");
                        break;
                    }
                    default: {
                        sb.append("UNKNOWN");
                    }
                }
                sb.append(" - ").append(component);
                if (context != null) {
                    sb.append(" - ").append(context);
                }
                sb.append(": ").append(message);
                if (this.stream != null) {
                    this.stream.println(sb.toString());
                    if (throwable != null) {
                        throwable.printStackTrace(this.stream);
                    }
                }
            } else if (this.stream != null) {
                this.stream.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(this.stream);
                }
            }
        }
    }
}

