/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.impl.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ObjectDumper {
    public static final int BASIC = 0;
    public static final int NORMAL = 1;
    public static final int DETAILED = 2;

    public static String dump(Object obj, int detailLevel) {
        try {
            if (obj == null) {
                return "<null>";
            }
            if (detailLevel == 0) {
                return ObjectDumper.getBasicInformation(obj);
            }
            if (obj instanceof ClassLoader) {
                if (detailLevel == 2) {
                    return ObjectDumper.getDetailedLoaderInformation((ClassLoader)obj, true);
                }
                return ObjectDumper.getDetailedLoaderInformation((ClassLoader)obj, false);
            }
            if (obj instanceof Class) {
                if (detailLevel == 2) {
                    return ObjectDumper.getDetailedClassInformation((Class)obj);
                }
                return ObjectDumper.getClassInformation((Class)obj);
            }
            return ObjectDumper.getBasicInformation(obj);
        }
        catch (Throwable t) {
            try {
                return obj.getClass() + ObjectDumper.hashString(obj);
            }
            catch (Throwable t2) {
                return "<unknown object>";
            }
        }
    }

    private static String getBasicInformation(Object obj) {
        if (obj instanceof Class) {
            return ObjectDumper.getBasicClassInformation((Class)obj);
        }
        if (obj instanceof ClassLoader) {
            return ObjectDumper.getBasicLoaderInformation((ClassLoader)obj);
        }
        if (obj instanceof String) {
            return "string \"" + obj.toString() + "\"" + ObjectDumper.hashString(obj);
        }
        if (obj instanceof StringBuffer) {
            return "string buffer \"" + obj.toString() + "\"" + ObjectDumper.hashString(obj);
        }
        return obj.getClass() + ObjectDumper.hashString(obj);
    }

    private static String getBasicClassInformation(Class<?> clazz) {
        return "class " + clazz.getName() + ObjectDumper.hashString(clazz) + " (" + ObjectDumper.getBasicLoaderInformation(clazz.getClassLoader()) + ")";
    }

    private static String getClassInformation(Class<?> clazz) {
        return "class " + clazz.getName() + ObjectDumper.hashString(clazz) + " (" + ObjectDumper.getDetailedLoaderInformation(clazz.getClassLoader(), false) + ")";
    }

    private static String getDetailedClassInformation(Class<?> clazz) {
        return "class " + clazz.getName() + ObjectDumper.hashString(clazz) + " (" + ObjectDumper.getDetailedLoaderInformation(clazz.getClassLoader(), true) + ")";
    }

    private static String getBasicLoaderInformation(ClassLoader loader) {
        if (loader == null) {
            return "<boostrap classloader>";
        }
        String loaderName = ObjectDumper.getLoaderName(loader);
        return "loader " + (ObjectDumper.getLoaderName(loader) == null ? "" : loaderName + " ") + loader.getClass().getName() + ObjectDumper.hashString(loader);
    }

    private static String getLoaderIdentifier(ClassLoader loader) {
        if (loader == null) {
            return "<boostrap classloader>";
        }
        String loaderName = ObjectDumper.getLoaderName(loader);
        if (loaderName != null) {
            if (loaderName.startsWith("<")) {
                return loaderName;
            }
            return "<" + loaderName + ">";
        }
        return loader.getClass().getName() + ObjectDumper.hashString(loader);
    }

    private static String getDetailedLoaderInformation(ClassLoader loader, boolean allowToString) {
        int i;
        if (loader == null) {
            return "<boostrap classloader>";
        }
        ClassLoader[] parents = ObjectDumper.getParents(loader);
        String[] urls = ObjectDumper.getUrls(loader);
        String loaderName = ObjectDumper.getLoaderName(loader);
        if (parents.length == 1 && urls.length == 0 && loaderName == null && allowToString) {
            return loader.toString();
        }
        StringBuffer b = new StringBuffer(ObjectDumper.getBasicLoaderInformation(loader));
        b.append(" (resources: [");
        for (i = 0; i < urls.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(urls[i]);
        }
        b.append("], parents: [");
        for (i = 0; i < parents.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(ObjectDumper.getLoaderIdentifier(parents[i]));
        }
        b.append("])");
        return b.toString();
    }

    private static String getLoaderName(ClassLoader loader) {
        String name = ObjectDumper.utf8ToString((byte[])ObjectDumper.getField(loader, byte[].class, "name"));
        if (name == null) {
            name = (String)ObjectDumper.getField(loader, String.class, "name");
        }
        if (name == null) {
            return null;
        }
        return "<" + name + ">";
    }

    private static ClassLoader[] getParents(ClassLoader loader) {
        ClassLoader parent = (ClassLoader)ObjectDumper.getField(loader, ClassLoader.class, "parent");
        ClassLoader[] otherParents = (ClassLoader[])ObjectDumper.getField(loader, ClassLoader[].class, "otherParents");
        if (otherParents == null) {
            return new ClassLoader[]{parent};
        }
        ClassLoader[] result = new ClassLoader[otherParents.length + 1];
        System.arraycopy(otherParents, 0, result, 1, otherParents.length);
        result[0] = parent;
        return result;
    }

    private static String[] getUrls(ClassLoader loader) {
        String[] resources;
        byte[][] rawUrls = (byte[][])ObjectDumper.getField(loader, byte[][].class, "urls");
        if (rawUrls != null) {
            String[] result = new String[rawUrls.length];
            for (int i = 0; i < rawUrls.length; ++i) {
                result[i] = ObjectDumper.utf8ToString(rawUrls[i]);
            }
            return result;
        }
        Object resource = ObjectDumper.getField(loader, null, "resource");
        if (resource != null && (resources = ObjectDumper.extractResourceStrings(resource)).length > 0) {
            return resources;
        }
        return new String[0];
    }

    private static String[] extractResourceStrings(Object resource) {
        String field;
        String jar2;
        String clazz = resource.getClass().getName();
        boolean isMultiResource = clazz.endsWith(".MultipleResource");
        boolean isJarsResource = clazz.endsWith(".JarsResource");
        boolean isDirsResource = clazz.endsWith(".DirsResource");
        boolean isJarResource = clazz.endsWith(".JarResource");
        boolean isDirResource = clazz.endsWith(".DirResource");
        if (isMultiResource || isJarsResource || isDirsResource) {
            String field2 = isMultiResource ? "res" : (isJarsResource ? "jars" : "dirs");
            Object[] resources = (Object[])ObjectDumper.getField(resource, null, field2);
            String[] result = new String[]{};
            for (int i = 0; i < resources.length; ++i) {
                String[] toAdd = ObjectDumper.extractResourceStrings(resources[i]);
                String[] newResult = new String[result.length + toAdd.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(toAdd, 0, newResult, result.length, toAdd.length);
                result = newResult;
            }
            return result;
        }
        if ((isJarResource || isDirResource) && (jar2 = (String)ObjectDumper.getField(resource, String.class, field = isJarResource ? "jarName" : "dirName")) != null) {
            return new String[]{jar2};
        }
        return new String[0];
    }

    private static String hashString(Object obj) {
        return "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static Object getField(final Object obj, final Class<?> type, final String name) {
        if (obj == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        Field field = clazz.getDeclaredField(name);
                        field.setAccessible(true);
                        if (type != null && !type.isAssignableFrom(field.getType())) continue;
                        return field.get(obj);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    private static String utf8ToString(byte[] utf8) {
        if (utf8 == null) {
            return null;
        }
        try {
            return new String(utf8, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

