/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector;

import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jvm.inspector.WithInspectorNativeLib;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InspectorInfo
extends WithInspectorNativeLib {
    private static final boolean onWindows = System.getProperty("os.name").startsWith("Windows");
    private static final String PROFILING_SERVER_PREFIX = "sap_jvm_profiling_server_";

    public static String getProfilingServerIdentifier(int pid) {
        if (onWindows) {
            return FileSocketAddress.FSA_BASE_LOCATION + File.separator + PROFILING_SERVER_PREFIX + pid;
        }
        Path found_path = null;
        try (DirectoryStream<Path> entries = Files.newDirectoryStream(Paths.get(FileSocketAddress.FSA_BASE_LOCATION, new String[0]), "sap_jvm_profiling_server*");){
            Pattern p = Pattern.compile("sap_jvm_profiling_server_(\\d+)_(\\d+)");
            for (Path file : entries) {
                long file_pid;
                Matcher m = p.matcher(file.getFileName().toString());
                if (!m.matches() || (file_pid = Long.parseLong(m.group(2))) != (long)pid || Files.isSymbolicLink(file) || Files.isDirectory(file, new LinkOption[0])) continue;
                if (found_path == null) {
                    found_path = file;
                    continue;
                }
                try {
                    if (Files.getLastModifiedTime(file, new LinkOption[0]).compareTo(Files.getLastModifiedTime(found_path, new LinkOption[0])) <= 0) continue;
                    found_path = file;
                }
                catch (IOException e) {
                    Path file2 = found_path;
                    Trace.error((Throwable)e, () -> "Could not compare timestamps of " + file + " and " + file2);
                }
            }
        }
        catch (IOException e) {
            Trace.error((Throwable)e, () -> "Caught IOException traversing /tmp, looking for SAP JVM profiling server files for pid " + pid);
        }
        return found_path == null ? null : found_path.toString();
    }

    public static native boolean couldElevate();

    public static native int getCpuCount();

    public static native long getCreationTimeOfProcess(int var0);

    public static native int getOwnProcessId();

    public static native short isFileSocketServerAttachable(String var0);

    public static native int isProcessAlive(int var0);
}

