/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;

public class WithInspectorNativeLib {
    public static final String LIB_BASE_NAME = "sapjvm_inspector";
    private static final boolean doTrace = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sap.jvm.inspector.natives.traceLoading"));

    private static void trace(String msg) {
        if (doTrace) {
            System.err.println(msg);
        }
    }

    private static void trace(Throwable t) {
        if (doTrace) {
            t.printStackTrace(System.err);
        }
    }

    private static String getLibraryName() {
        String libraryName = System.getProperty("com.sap.jvm.inspector.natives.libraryname");
        if (libraryName != null && !libraryName.isEmpty()) {
            WithInspectorNativeLib.trace("Native library name given by property: " + libraryName);
            return libraryName;
        }
        String prefix = "lib";
        String suffix = ".so";
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.indexOf("windows") != -1) {
            suffix = ".dll";
            prefix = "";
        } else if (os.indexOf("hp-ux") != -1 && arch.indexOf("pa_risc") != -1) {
            suffix = ".sl";
        } else if (os.indexOf("mac os") != -1) {
            if ("amd64".equals(arch) || "x86_64".equals(arch)) {
                suffix = ".dylib";
            } else if ("x86".equals(arch) || "i386".equals(arch)) {
                suffix = ".dylib";
            }
        }
        return prefix + LIB_BASE_NAME + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getPlatformDirName() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String platform = null;
        if (os.indexOf("windows") != -1) {
            if ("i386".equals(arch)) return "ntintel";
            if ("x86".equals(arch)) {
                return "ntintel";
            }
            if ("amd64".equals(arch)) return "ntamd64";
            if ("x86_64".equals(arch)) {
                return "ntamd64";
            }
            if (!"ia64".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Windows");
            return "ntia64";
        }
        if (os.indexOf("linux") != -1 || os.indexOf("powerpc") != -1) {
            if ("i386".equals(arch)) return "linuxintel";
            if ("x86".equals(arch)) {
                return "linuxintel";
            }
            if ("amd64".equals(arch)) return "linuxx86_64";
            if ("x86_64".equals(arch)) {
                return "linuxx86_64";
            }
            if ("ia64".equals(arch)) {
                return "linuxia64";
            }
            if ("ppc64".equals(arch)) return "linuxppc64";
            if ("powerpc".equals(arch)) {
                return "linuxppc64";
            }
            if ("ppc64le".equals(arch)) {
                return "linuxppc64le";
            }
            if ("zarch_64".equals(arch)) return "linuxs390x";
            if (!"s390x".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Linux");
            return "linuxs390x";
        }
        if (os.indexOf("sunos") != -1) {
            if ("sparcv9".equals(arch)) return "sun_64";
            if ("sparc".equals(arch)) {
                return "sun_64";
            }
            if ("amd64".equals(arch)) return "sunx86_64";
            if (!"x86".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Solaris");
            return "sunx86_64";
        }
        if (os.indexOf("hp-ux") != -1) {
            if (arch.indexOf("ia64") != -1) {
                return "hpia64";
            }
            if (arch.indexOf("pa_risc") == -1) throw new IOException("Unknown architecture '" + arch + "' on HP-UX");
            return "hp_64";
        }
        if (os.indexOf("aix") != -1) {
            if (!"ppc64".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on AIX");
            return "rs6000_64";
        }
        if (os.indexOf("os400") != -1 || os.indexOf("os/400") != -1) {
            if ("ppc64".equals(arch)) return "as400_pase_64";
            if (!"powerpc".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on OS/400");
            return "as400_pase_64";
        }
        if (os.indexOf("mac os") == -1) throw new IOException("Unknown os '" + os + "'.");
        if ("amd64".equals(arch)) return "bsdx86_64";
        if ("x86_64".equals(arch)) {
            return "bsdx86_64";
        }
        if ("x86".equals(arch)) return "bsdintel";
        if (!"i386".equals(arch)) throw new IOException("Unknown architecture '" + arch + "' on Mac OS X");
        return "bsdintel";
    }

    private static void loadWithAppropriateMechanism() throws IOException {
        String platformRootDirectory = System.getProperty("com.sap.jvm.inspector.natives.platformRoot");
        if (platformRootDirectory != null && !platformRootDirectory.isEmpty()) {
            WithInspectorNativeLib.loadFromPlatformRoot(platformRootDirectory);
            return;
        }
        String libDirectory = System.getProperty("com.sap.jvm.inspector.natives.directory");
        if (libDirectory != null && !libDirectory.isEmpty()) {
            WithInspectorNativeLib.loadFromDirectory(libDirectory);
            return;
        }
        System.loadLibrary(LIB_BASE_NAME);
    }

    private static void loadFromPlatformRoot(String platformRoot) throws IOException {
        WithInspectorNativeLib.trace("Loading library sapjvm_inspector from platform root directory " + platformRoot + ".");
        String platform = WithInspectorNativeLib.getPlatformDirName();
        WithInspectorNativeLib.loadFromDirectory(platformRoot + File.separator + platform);
    }

    private static void loadFromDirectory(String libDirectory) throws IOException {
        WithInspectorNativeLib.trace("Loading library sapjvm_inspector from directory " + libDirectory + ".");
        String libraryName = WithInspectorNativeLib.getLibraryName();
        String libpath = new File(libDirectory + File.separator + libraryName).getAbsolutePath();
        WithInspectorNativeLib.trace("Loading " + libpath + "...");
        System.load(libpath);
    }

    static {
        try {
            AccessController.doPrivileged(() -> {
                WithInspectorNativeLib.loadWithAppropriateMechanism();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WithInspectorNativeLib.trace(e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

