/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.AbstractAttributeSpecificationImpl;
import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeImpl;
import com.sap.jvm.inspector.board.AttributeUnitType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.board.Value;
import com.sap.jvm.inspector.board.ValueHelperImpl;
import com.sap.jvm.tracing.Trace;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class AttributeByteArrayBasedImpl
extends AbstractAttributeSpecificationImpl
implements Attribute {
    public static final short byteBufferVersion = 0;
    private final String name;
    private byte[] rawData4AllValues;
    private final int arrayLength;
    private long updateTimeStamp;
    private final AttributeGroupType groupType;
    private final AttributeDataType dataType;
    private final AttributeVariabilityType variabbilityType;
    private final AttributeUnitType unitType;

    public AttributeByteArrayBasedImpl(String name, byte[] rawData4AllValues, int arrayLength, long updateTimeStamp, AttributeGroupType groupType, AttributeDataType dataType, AttributeVariabilityType variabbilityType, AttributeUnitType unitType) {
        this.name = name;
        this.rawData4AllValues = (byte[])rawData4AllValues.clone();
        this.arrayLength = arrayLength;
        this.updateTimeStamp = updateTimeStamp;
        this.groupType = groupType;
        this.dataType = dataType;
        this.variabbilityType = variabbilityType;
        this.unitType = unitType;
    }

    public AttributeByteArrayBasedImpl(ByteBuffer buffer) throws MonitorBoardFormatException {
        buffer.position(0);
        short bufferVersion = buffer.getShort();
        if (bufferVersion > 0) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Version " + bufferVersion + " is not accepted by AttributeControlAreaBasedImpl(" + 0 + ")");
            Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        int nameLength = buffer.getInt();
        byte[] temp = new byte[nameLength];
        buffer.get(temp);
        this.name = new String(temp);
        short rawDataLength = buffer.getShort();
        this.rawData4AllValues = new byte[rawDataLength];
        buffer.get(this.rawData4AllValues);
        this.arrayLength = buffer.getInt();
        this.updateTimeStamp = buffer.getLong();
        this.groupType = AttributeGroupType.getGroupType(buffer.getInt());
        this.dataType = AttributeDataType.getDataType(buffer.getInt());
        this.variabbilityType = AttributeVariabilityType.getVariabilityType(buffer.getInt());
        this.unitType = AttributeUnitType.getUnitType(buffer.getInt());
    }

    @Override
    public boolean isArray() {
        return this.getArraySize() > 1 && this.dataType != AttributeDataType.TYPE_CHAR;
    }

    @Override
    public AttributeVariabilityType getVariabilityType() {
        return this.variabbilityType;
    }

    @Override
    public AttributeDataType getDataType() {
        return this.dataType;
    }

    @Override
    public AttributeGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public AttributeUnitType getUnitType() {
        return this.unitType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value getValue() throws MonitorBoardFormatException {
        return new ValueHelperImpl(this.rawData4AllValues, this.dataType, this.updateTimeStamp);
    }

    @Override
    public int getArraySize() {
        return this.arrayLength;
    }

    @Override
    public Iterator<Value> getValueIterator() throws MonitorBoardFormatException {
        ArrayList<Value> valueList = new ArrayList<Value>(this.getArraySize());
        valueList.add(this.getValue());
        return valueList.listIterator();
    }

    @Override
    public byte[] getCopyOfRawData() {
        return (byte[])this.rawData4AllValues.clone();
    }

    protected void update(byte[] newContent) {
        this.rawData4AllValues = (byte[])newContent.clone();
    }

    public int getByteBufferArraySize() {
        return 6 + this.name.length() + 2 + this.rawData4AllValues.length + 4 + 8 + 4 + 4 + 4 + 4;
    }

    public ByteBuffer getAsByteBuffer() {
        ByteBuffer b = ByteBuffer.allocate(this.getByteBufferArraySize());
        b.position(0);
        b.putShort((short)0);
        b.putInt(this.name.length());
        b.put(this.name.getBytes());
        b.putShort((short)this.rawData4AllValues.length);
        b.put(this.rawData4AllValues);
        b.putInt(this.getArraySize());
        b.putLong(this.updateTimeStamp);
        b.putInt(AttributeGroupType.getIndexFor(this.groupType));
        b.putInt(AttributeDataType.getIndexFor(this.dataType));
        b.putInt(AttributeVariabilityType.getIndexFor(this.variabbilityType));
        b.putInt(AttributeUnitType.getIndexFor(this.unitType));
        return b;
    }

    @Override
    public Value[] getValues() throws MonitorBoardFormatException {
        Value[] ret = new Value[]{this.getValue()};
        return null;
    }

    @Override
    public boolean getBoolValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getBoolValue(this.rawData4AllValues, 0);
    }

    @Override
    public boolean[] getBoolValues() throws MonitorBoardFormatException {
        boolean[] ret = new boolean[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getBoolValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public boolean getBoolValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getBoolValue(byte[]) buf is not supported");
    }

    @Override
    public boolean[] getBoolValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getBoolValues(byte[]) buf is not supported");
    }

    @Override
    public double getDoubleValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getDoubleValue(this.rawData4AllValues, 0);
    }

    @Override
    public double[] getDoubleValues() throws MonitorBoardFormatException {
        double[] ret = new double[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getDoubleValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public double getDoubleValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getDoubleValue(byte[]) buf is not supported");
    }

    @Override
    public double[] getDoubleValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getDoubleValues(byte[]) buf is not supported");
    }

    @Override
    public float getFloatValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getFloatValue(this.rawData4AllValues, 0);
    }

    @Override
    public float[] getFloatValues() throws MonitorBoardFormatException {
        float[] ret = new float[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getFloatValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public float getFloatValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getFloatValue(byte[]) buf is not supported");
    }

    @Override
    public float[] getFloatValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getFloatValues(byte[]) buf is not supported");
    }

    @Override
    public long getLongValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getLongValue(this.rawData4AllValues, 0);
    }

    @Override
    public long[] getLongValues() throws MonitorBoardFormatException {
        long[] ret = new long[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getLongValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public long getLongValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getLongValue(byte[]) buf is not supported");
    }

    @Override
    public long[] getLongValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getLongValues(byte[]) buf is not supported");
    }

    @Override
    public short getShortValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getShortValue(this.rawData4AllValues, 0);
    }

    @Override
    public short[] getShortValues() throws MonitorBoardFormatException {
        short[] ret = new short[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getShortValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public short getShortValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getShortValue(byte[]) buf is not supported");
    }

    @Override
    public short[] getShortValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getShortValues(byte[]) buf is not supported");
    }

    @Override
    public int getIntValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getIntValue(this.rawData4AllValues, 0);
    }

    @Override
    public int[] getIntValues() throws MonitorBoardFormatException {
        int[] ret = new int[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getIntValue(this.rawData4AllValues, 0);
        }
        return ret;
    }

    @Override
    public int getIntValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getIntValue(byte[]) buf is not supported");
    }

    @Override
    public int[] getIntValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getIntValues(byte[]) buf is not supported");
    }

    @Override
    public byte getByteValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getRawByteValue(this.rawData4AllValues, 0);
    }

    @Override
    public byte[] getByteValues() throws MonitorBoardFormatException {
        return this.rawData4AllValues;
    }

    @Override
    public byte getByteValue(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getByteValue(byte[]) buf is not supported");
    }

    @Override
    public byte[] getByteValues(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("getByteValues(byte[]) buf is not supported");
    }

    @Override
    public boolean checkRawData(byte[] buf) throws MonitorBoardFormatException {
        throw new MonitorBoardFormatException("checkRawData(byte[] buf) is not supported");
    }
}

