/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeByteArrayBasedImpl;
import com.sap.jvm.inspector.board.AttributeImpl;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AttributeByteBufferBasedContainerImpl {
    protected static final int magicNumberOfFullContent = -1144136518;
    protected static final int magicNumberOfDynamicContent = 734911665;
    protected static final short version = 1;
    private boolean isfixed = false;
    private List<AttributeByteArrayBasedImpl> attributes = null;

    public AttributeByteBufferBasedContainerImpl() {
        this.attributes = new ArrayList<AttributeByteArrayBasedImpl>(0);
    }

    public AttributeByteBufferBasedContainerImpl(int initialSize) {
        this.attributes = new ArrayList<AttributeByteArrayBasedImpl>(initialSize);
    }

    public AttributeByteBufferBasedContainerImpl(byte[] content) throws MonitorBoardFormatException {
        ByteBuffer buffer = ByteBuffer.wrap(content);
        buffer.position(0);
        int magicNumberOfByteBuffer = buffer.getInt();
        if (magicNumberOfByteBuffer != magicNumberOfFullContent) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Magic number " + magicNumberOfByteBuffer + " is not accepted by AttributeByteBufferBasedContainerImpl( " + magicNumberOfFullContent + ")");
            Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        short versionOfByteBuffer = buffer.getShort();
        if (versionOfByteBuffer > 1) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Version " + versionOfByteBuffer + " is not accepted by AttributeByteBufferBasedContainerImpl( " + 1 + ")");
            Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        int countOfAttributes = buffer.getInt();
        this.attributes = new ArrayList<AttributeByteArrayBasedImpl>(countOfAttributes);
        for (int i = 0; i < countOfAttributes; ++i) {
            int sizeOfAttributeDefinition = buffer.getInt();
            byte[] temp = new byte[sizeOfAttributeDefinition];
            buffer.get(temp);
            this.attributes.add(new AttributeByteArrayBasedImpl(ByteBuffer.wrap(temp)));
        }
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public ListIterator<AttributeByteArrayBasedImpl> getIterator() {
        return this.attributes.listIterator();
    }

    public Attribute get(String parameterName) {
        ListIterator<AttributeByteArrayBasedImpl> iter = this.getIterator();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            if (!attr.getName().equals(parameterName)) continue;
            return attr;
        }
        return null;
    }

    public boolean add(AttributeByteArrayBasedImpl attr) throws MonitorBoardFormatException {
        if (this.isfixed) {
            throw new MonitorBoardFormatException("AttributeByteBufferBasedContainerImpl is already locked.");
        }
        return this.attributes.add(attr);
    }

    public ByteBuffer getDynamicAttributesAsByteArray() {
        int size = 6;
        ListIterator<AttributeByteArrayBasedImpl> attrs = this.getIterator();
        while (attrs.hasNext()) {
            Attribute attribute = (Attribute)attrs.next();
            if (attribute.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            size += attribute.getCopyOfRawData().length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.position(0);
        buffer.putInt(magicNumberOfDynamicContent);
        buffer.putShort((short)1);
        attrs = this.getIterator();
        while (attrs.hasNext()) {
            Attribute attribute = (Attribute)attrs.next();
            if (attribute.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            buffer.put(attribute.getCopyOfRawData());
        }
        return buffer;
    }

    public ByteBuffer getAsByteBuffer() {
        ListIterator<AttributeByteArrayBasedImpl> iter = this.getIterator();
        int size = 10;
        while (iter.hasNext()) {
            size += iter.next().getByteBufferArraySize() + 4;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.position(0);
        buffer.putInt(magicNumberOfFullContent);
        buffer.putShort((short)1);
        buffer.putInt(this.attributes.size());
        iter = this.getIterator();
        while (iter.hasNext()) {
            AttributeByteArrayBasedImpl attr = iter.next();
            buffer.putInt(attr.getByteBufferArraySize());
            buffer.put(attr.getAsByteBuffer().array());
            size += attr.getByteBufferArraySize() + 4;
        }
        this.isfixed = true;
        return buffer;
    }
}

