/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

public enum AttributeDataType {
    TYPE_UNSPECIFIED("UNSPECIFIED", 0, Object.class),
    TYPE_BOOL("BOOL", 1, Boolean.class),
    TYPE_CHAR("CHAR", 1, Character.class),
    TYPE_INT8("INT8", 1, Byte.class),
    TYPE_INT16("INT16", 2, Short.class),
    TYPE_INT32("INT32", 4, Integer.class),
    TYPE_INT64("INT64", 8, Long.class),
    TYPE_FLOAT("FLOAT", 4, Float.class),
    TYPE_DOUBLE("DOUBLE", 8, Double.class);

    private final String id;
    private final int sizeInBytes;
    private final Class<?> javaType;

    private AttributeDataType(String id, int sizeInBytes, Class<?> javaType) {
        this.id = id;
        this.sizeInBytes = sizeInBytes;
        this.javaType = javaType;
    }

    public String getId() {
        return this.id;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public static AttributeDataType getDataType(int index) {
        AttributeDataType[] values = AttributeDataType.values();
        if (index >= 0 && index < values.length - 1) {
            return values[index + 1];
        }
        return TYPE_UNSPECIFIED;
    }

    public static int getIndexFor(AttributeDataType type) {
        AttributeDataType[] values = AttributeDataType.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].id.equals(type.id)) continue;
            return i - 1;
        }
        return 0;
    }
}

