/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

public enum AttributeGroupType {
    TYPE_MISC("MISC", "No special group type assignable"),
    TYPE_PROCESSINFO("PROCESSINFO", "General information about the VM process"),
    TYPE_VMINFO("VMINFO", "General information about the VM"),
    TYPE_RUNTIME("RUNTIME", "Information about the VM runtime"),
    TYPE_MEMORY("MEMORY", "Information about the VM's native memory consumption"),
    TYPE_PERFORMANCE("PERFORMANCE", "Information about the VM's performance"),
    TYPE_GC("GC", "Information about the VM's GC behaviour"),
    TYPE_COMPILER("COMPILER", "Information about the VM's JIT compiler behaviour");

    private final String groupName;
    private final String description;

    private AttributeGroupType(String groupName, String description) {
        this.groupName = groupName;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static AttributeGroupType getGroupType(int index) {
        AttributeGroupType[] values = AttributeGroupType.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return TYPE_MISC;
    }

    public static int getIndexFor(AttributeGroupType type) {
        AttributeGroupType[] values = AttributeGroupType.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].groupName.equals(type.groupName)) continue;
            return i;
        }
        return 0;
    }
}

