/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.AbstractAttributeSpecificationImpl;
import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeUnitType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.board.Value;
import com.sap.jvm.inspector.board.ValueHelperImpl;
import com.sap.jvm.inspector.board.ValueImpl;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ListIterator;

public class AttributeImpl
extends AbstractAttributeSpecificationImpl
implements Attribute {
    private final Board board;
    private final int length;
    private final AttributeGroupType groupType;
    private final AttributeDataType dataType;
    private final AttributeVariabilityType variabbilityType;
    private final AttributeUnitType unitType;
    private final int offsetToValue;
    private final int offsetToName;
    private final String name;
    private final int parameter_start_position;
    private final int nameLength;
    private int arrayLength;
    private byte[] rawData4AllValues;
    private final int rawDataBufferSize;
    private int readPositionOfEyecatcher;
    private int readPositionOfLength;
    private int readPositionOfGroupType;
    private int readPositionOfDataType;
    private int readPositionOfVariabilityType;
    private int readPositionOfUnitType;
    private int readPositionOfOffsetToValue;
    private int readPositionOfOffsetToName;
    private int readPositionOfFirstValuePos;

    private void calculateOffsets(int startOffset) {
        this.readPositionOfEyecatcher = startOffset;
        this.readPositionOfLength = startOffset + 4;
        this.readPositionOfGroupType = startOffset + 8;
        this.readPositionOfDataType = startOffset + 9;
        this.readPositionOfVariabilityType = startOffset + 10;
        this.readPositionOfUnitType = startOffset + 11;
        this.readPositionOfOffsetToName = startOffset + 12;
        this.readPositionOfOffsetToValue = startOffset + 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void update(ByteBuffer boardContentBuffer) throws MonitorBoardFormatException, IOException {
        Board board = this.board;
        synchronized (board) {
            int eyecatcher = boardContentBuffer.getInt(this.parameter_start_position);
            if (BoardImpl.MAGIC_NUMBER != eyecatcher) {
                MonitorBoardFormatException ex = new MonitorBoardFormatException("Found wrong eye catcher (" + eyecatcher + ") during update of attribute " + this.name);
                Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
                throw ex;
            }
            int name_length = boardContentBuffer.getInt(this.parameter_start_position + this.offsetToName);
            ValueImpl name1 = new ValueImpl(this.board.getTimeStamp(), this, boardContentBuffer, this.parameter_start_position + this.offsetToName + 4, name_length, AttributeDataType.TYPE_CHAR);
            if (!this.name.equals(name1.getAsString())) {
                MonitorBoardFormatException ex = new MonitorBoardFormatException("Update board: Expected attribute " + this.name + " but got " + name1.getAsString() + ".");
                Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
                throw ex;
            }
            this.arrayLength = boardContentBuffer.getInt(this.getArraySizePositionWithinBuffer());
            byte[] byArray = this.rawData4AllValues;
            synchronized (this.rawData4AllValues) {
                if (this.variabbilityType == AttributeVariabilityType.TYPE_DYNAMIC && this.dataType == AttributeDataType.TYPE_CHAR && this.arrayLength != this.rawData4AllValues.length) {
                    this.rawData4AllValues = new byte[this.arrayLength];
                }
                boardContentBuffer.position(this.parameter_start_position + this.offsetToValue + 4);
                boardContentBuffer.get(this.rawData4AllValues);
                // ** MonitorExit[var6_8] (shouldn't be in output)
            }
        }
    }

    public int getArraySizePositionWithinBuffer() {
        return this.parameter_start_position + this.offsetToValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getCopyOfRawData() {
        byte[] byArray = this.rawData4AllValues;
        synchronized (this.rawData4AllValues) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (byte[])this.rawData4AllValues.clone();
        }
    }

    public int getRawValuePosition() {
        return this.parameter_start_position + this.offsetToValue + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRawValueSize() {
        byte[] byArray = this.rawData4AllValues;
        synchronized (this.rawData4AllValues) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rawData4AllValues.length;
        }
    }

    public AttributeImpl(Board boardAttributeBelongsTo, ByteBuffer boardContentBuffer, int offset_, short id) throws MonitorBoardFormatException {
        this.board = boardAttributeBelongsTo;
        this.parameter_start_position = offset_;
        this.calculateOffsets(this.parameter_start_position);
        int eyecatcher = boardContentBuffer.getInt(this.readPositionOfEyecatcher);
        if (BoardImpl.MAGIC_NUMBER != eyecatcher) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Found wrong eye catcher (" + eyecatcher + ") in a attribute definition");
            Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        this.length = boardContentBuffer.getInt(this.readPositionOfLength);
        this.groupType = AttributeGroupType.getGroupType(boardContentBuffer.get(this.readPositionOfGroupType));
        this.dataType = AttributeDataType.getDataType(boardContentBuffer.get(this.readPositionOfDataType));
        this.variabbilityType = AttributeVariabilityType.getVariabilityType(boardContentBuffer.get(this.readPositionOfVariabilityType));
        this.unitType = AttributeUnitType.getUnitType(boardContentBuffer.get(this.readPositionOfUnitType));
        this.offsetToName = boardContentBuffer.getShort(this.readPositionOfOffsetToName);
        this.offsetToValue = boardContentBuffer.getShort(this.readPositionOfOffsetToValue);
        this.nameLength = boardContentBuffer.getInt(this.parameter_start_position + this.offsetToName);
        if (this.parameter_start_position + this.offsetToName > boardContentBuffer.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(offset +  this.offsetToName) > boardContentBuffer.capacity()");
            Trace.get(AttributeImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        if (this.parameter_start_position + this.offsetToValue > boardContentBuffer.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(offset +  offsetToValue) > boardContentBuffer.capacity()");
            throw ex;
        }
        this.name = new ValueImpl(this.board.getTimeStamp(), this, boardContentBuffer, this.parameter_start_position + this.offsetToName + 4, this.nameLength, AttributeDataType.TYPE_CHAR).getAsString();
        this.arrayLength = boardContentBuffer.getInt(this.parameter_start_position + this.offsetToValue);
        this.readPositionOfFirstValuePos = this.parameter_start_position + this.offsetToValue + 4;
        int bufferSize = ValueImpl.getRawDataBuffersize(this.dataType, this.arrayLength);
        if (this.dataType != AttributeDataType.TYPE_CHAR & this.arrayLength > 0) {
            bufferSize *= this.arrayLength;
        }
        this.rawDataBufferSize = bufferSize;
        this.rawData4AllValues = new byte[this.rawDataBufferSize];
        boardContentBuffer.position(this.readPositionOfFirstValuePos);
        boardContentBuffer.get(this.rawData4AllValues);
    }

    public int getLengthInBytes() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributeUnitType getUnitType() {
        return this.unitType;
    }

    @Override
    public AttributeDataType getDataType() {
        return this.dataType;
    }

    @Override
    public AttributeVariabilityType getVariabilityType() {
        return this.variabbilityType;
    }

    @Override
    public AttributeGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public int getArraySize() {
        return this.arrayLength;
    }

    @Override
    public boolean isArray() {
        return this.getArraySize() > 1 && this.dataType != AttributeDataType.TYPE_CHAR;
    }

    public ListIterator<Value> getValueIterator() throws MonitorBoardFormatException {
        Value[] valueArray = this.getValues();
        ArrayList<Value> valueList = new ArrayList<Value>(valueArray.length);
        for (int counter = 0; counter < valueArray.length; ++counter) {
            valueList.add(valueArray[counter]);
        }
        return valueList.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value[] getValues() throws MonitorBoardFormatException {
        int valuesWeHaveDataFor = this.arrayLength;
        if (valuesWeHaveDataFor == 0) {
            valuesWeHaveDataFor = 1;
        }
        Value[] ret = new Value[this.getArraySize()];
        if (this.dataType == AttributeDataType.TYPE_CHAR) {
            ret[0] = this.getValue();
            return ret;
        }
        byte[] byArray = this.rawData4AllValues;
        synchronized (this.rawData4AllValues) {
            long boardTimeStamp = this.board.getTimeStamp();
            ByteBuffer tempBuffer = ByteBuffer.wrap(this.rawData4AllValues);
            byte[] rawData = new byte[this.getDataType().getSizeInBytes()];
            int readPosition = 0;
            int counter = 0;
            while (counter < valuesWeHaveDataFor) {
                tempBuffer.position(readPosition);
                tempBuffer.get(rawData, 0, this.getDataType().getSizeInBytes());
                ret[counter] = new ValueHelperImpl(rawData, this.getDataType(), boardTimeStamp);
                ++counter;
                readPosition += this.getDataType().getSizeInBytes();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Value getValue() throws MonitorBoardFormatException {
        ByteBuffer tempBuffer = ByteBuffer.wrap(this.rawData4AllValues);
        tempBuffer.position(0);
        byte[] rawData = new byte[this.getDataType().getSizeInBytes()];
        byte[] byArray = this.rawData4AllValues;
        synchronized (this.rawData4AllValues) {
            if (this.dataType == AttributeDataType.TYPE_CHAR) {
                rawData = new byte[this.rawData4AllValues.length];
                tempBuffer.get(rawData, 0, this.rawData4AllValues.length);
            } else {
                tempBuffer.get(rawData, 0, this.getDataType().getSizeInBytes());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new ValueHelperImpl(rawData, this.getDataType(), this.board.getTimeStamp());
        }
    }

    @Override
    public boolean checkRawData(byte[] buf) throws MonitorBoardFormatException {
        ByteBuffer bb = ByteBuffer.wrap(buf);
        if (this.readPositionOfEyecatcher > bb.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(this.readPositionOfEyecatcher) > bb.capacity() ");
            throw ex;
        }
        int eyecatcher = bb.getInt(this.readPositionOfEyecatcher);
        if (BoardImpl.MAGIC_NUMBER != eyecatcher) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("BoardImpl.magicNumber != eyecatcher");
            throw ex;
        }
        if (this.parameter_start_position + this.offsetToName > bb.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(offset +  this.offsetToName) > boardContentBuffer.capacity()");
            throw ex;
        }
        if (this.parameter_start_position + this.offsetToValue > bb.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(offset +  offsetToValue) > boardContentBuffer.capacity()");
            throw ex;
        }
        String newName = new ValueImpl(this.board.getTimeStamp(), this, bb, this.parameter_start_position + this.offsetToName + 4, this.nameLength, AttributeDataType.TYPE_CHAR).getAsString();
        if (!this.name.equals(newName)) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Original name: " + this.name + " doesn't match name: " + newName);
            throw ex;
        }
        if (this.readPositionOfFirstValuePos + this.rawDataBufferSize > bb.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("(readPositionOfFirstValuePos + rawDataBufferSize) > bb.capacity()");
            throw ex;
        }
        return true;
    }

    @Override
    public boolean getBoolValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getBoolValue(this.rawData4AllValues, 0);
    }

    @Override
    public boolean getBoolValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getBoolValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public boolean[] getBoolValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getBoolValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public boolean[] getBoolValues() throws MonitorBoardFormatException {
        return this.getBoolValues(this.rawData4AllValues, 0);
    }

    private boolean[] getBoolValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        boolean[] ret = new boolean[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getBoolValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public double getDoubleValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getDoubleValue(this.rawData4AllValues, 0);
    }

    @Override
    public double getDoubleValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getDoubleValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public double[] getDoubleValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getDoubleValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public double[] getDoubleValues() throws MonitorBoardFormatException {
        return this.getDoubleValues(this.rawData4AllValues, 0);
    }

    private double[] getDoubleValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        double[] ret = new double[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getDoubleValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public float getFloatValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getFloatValue(this.rawData4AllValues, 0);
    }

    @Override
    public float getFloatValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getFloatValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public float[] getFloatValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getFloatValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public float[] getFloatValues() throws MonitorBoardFormatException {
        return this.getFloatValues(this.rawData4AllValues, 0);
    }

    private float[] getFloatValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        float[] ret = new float[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getFloatValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public long getLongValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getLongValue(this.rawData4AllValues, 0);
    }

    @Override
    public long getLongValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getLongValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public long[] getLongValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getLongValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public long[] getLongValues() throws MonitorBoardFormatException {
        return this.getLongValues(this.rawData4AllValues, 0);
    }

    private long[] getLongValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        long[] ret = new long[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getLongValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public short getShortValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getShortValue(this.rawData4AllValues, 0);
    }

    @Override
    public short getShortValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getShortValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public short[] getShortValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getShortValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public short[] getShortValues() throws MonitorBoardFormatException {
        return this.getShortValues(this.rawData4AllValues, 0);
    }

    private short[] getShortValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        short[] ret = new short[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getShortValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public int getIntValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getIntValue(this.rawData4AllValues, 0);
    }

    @Override
    public int getIntValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getIntValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public int[] getIntValues(byte[] buf) throws MonitorBoardFormatException {
        return this.getIntValues(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public int[] getIntValues() throws MonitorBoardFormatException {
        return this.getIntValues(this.rawData4AllValues, 0);
    }

    private int[] getIntValues(byte[] buf, int startPos) throws MonitorBoardFormatException {
        int[] ret = new int[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getIntValue(buf, startPos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }

    @Override
    public byte getByteValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getRawByteValue(this.rawData4AllValues, 0);
    }

    @Override
    public byte[] getByteValues() throws MonitorBoardFormatException {
        return this.rawData4AllValues;
    }

    @Override
    public byte getByteValue(byte[] buf) throws MonitorBoardFormatException {
        return ValueHelperImpl.getRawByteValue(buf, this.readPositionOfFirstValuePos);
    }

    @Override
    public byte[] getByteValues(byte[] buf) throws MonitorBoardFormatException {
        byte[] ret = new byte[this.getArraySize()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ValueHelperImpl.getRawByteValue(buf, this.readPositionOfFirstValuePos + i * this.dataType.getSizeInBytes());
        }
        return ret;
    }
}

