/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeByteArrayBasedImpl;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardInternal;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public abstract class BoardControlAreaBasedCommonImpl
implements BoardInternal {
    public static final int magicNumberOfFullContent = -1412571974;
    public static final int magicNumberOfDynamicContent = 466476209;
    protected static final short version = 0;
    protected List<Attribute> attributes = new ArrayList<Attribute>(0);
    protected Set<BoardUpdateListener> myUpdateListener = new HashSet<BoardUpdateListener>();
    protected long timeStampLastUpdate = 0L;
    protected BoardState boardState;

    protected void callUpdateListener() {
        for (BoardUpdateListener l : this.myUpdateListener) {
            l.updateHasBeenProcessed(this);
        }
    }

    @Override
    public void addBoardUpdateListener(BoardUpdateListener listener) {
        this.myUpdateListener.add(listener);
    }

    @Override
    public void removeBoardUpdateListener(BoardUpdateListener listener) {
        this.myUpdateListener.remove(listener);
    }

    @Override
    public long getStartingTimeStamp() {
        return 0L;
    }

    @Override
    public boolean isBoardBased() {
        return false;
    }

    @Override
    public boolean isAlive() {
        return this.getState() == BoardState.TYPE_ALIVE || this.getState() == BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
    }

    @Override
    public BoardState getState() {
        return this.boardState;
    }

    @Override
    public synchronized void lostConnection() {
        this.setBoardState(BoardState.TYPE_CONNECTION_LOST);
    }

    public void setBoardState(BoardState bs) {
        this.boardState = bs;
        this.callUpdateListener();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStampLastUpdate;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 9;
    }

    @Override
    public int getNumAttributes() {
        return this.attributes.size();
    }

    @Override
    public int getUpdateTime() {
        return 500;
    }

    public ListIterator<Attribute> getAttributeIterator() {
        return this.attributes.listIterator();
    }

    @Override
    public Attribute get(String name) {
        for (Attribute attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public void processOfBoardIsGone() {
        this.setBoardState(BoardState.TYPE_DEAD);
    }

    @Override
    public Iterator<BoardUpdateListener> getBoardListener() {
        return this.myUpdateListener.iterator();
    }

    @Override
    public ByteBuffer getCurrentByteBuffer() {
        int size = 26;
        Iterator iter = this.getAttributeIterator();
        while (iter.hasNext()) {
            size += ((AttributeByteArrayBasedImpl)iter.next()).getByteBufferArraySize() + 4;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.position(0);
        buffer.putInt(magicNumberOfFullContent);
        buffer.putShort((short)0);
        buffer.putInt(this.getPid());
        buffer.putLong(this.timeStampLastUpdate);
        buffer.putInt(BoardState.getIndexFor(this.boardState));
        buffer.putInt(this.attributes.size());
        iter = this.getAttributeIterator();
        while (iter.hasNext()) {
            AttributeByteArrayBasedImpl attr = (AttributeByteArrayBasedImpl)iter.next();
            buffer.putInt(attr.getByteBufferArraySize());
            buffer.put(attr.getAsByteBuffer().array());
            size += attr.getByteBufferArraySize() + 4;
        }
        return buffer;
    }

    @Override
    public ByteBuffer getDynamicPartsOfBoardAsByteArray(boolean addSize4DynamicCharAttributes) {
        int size = 0;
        Iterator attrs = this.getAttributeIterator();
        while (attrs.hasNext()) {
            size += ((Attribute)attrs.next()).getCopyOfRawData().length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.position(0);
        buffer.putInt(magicNumberOfDynamicContent);
        buffer.putInt(this.getPid());
        buffer.putLong(this.timeStampLastUpdate);
        buffer.putInt(BoardState.getIndexFor(this.boardState));
        attrs = this.getAttributeIterator();
        while (attrs.hasNext()) {
            Attribute attribute = (Attribute)attrs.next();
            if (attribute.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            if (attribute.getDataType() == AttributeDataType.TYPE_CHAR && addSize4DynamicCharAttributes) {
                buffer.putInt(attribute.getCopyOfRawData().length);
            }
            buffer.put(attribute.getCopyOfRawData());
        }
        return buffer;
    }
}

