/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.AttributeByteArrayBasedImpl;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeUnitType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardControlAreaBasedCommonImpl;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.tracing.Trace;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BoardControlAreaBasedImpl
extends BoardControlAreaBasedCommonImpl {
    private static final String NOT_AVAILABLE = "NOT AVAILABLE";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final Vm myVm;
    private int myPid;
    private AttributeByteArrayBasedImpl processInfo_Pid;
    private AttributeByteArrayBasedImpl processInfo_Hostname;
    private AttributeByteArrayBasedImpl processInfo_UserName;
    private AttributeByteArrayBasedImpl processInfo_ParentPid;
    private AttributeByteArrayBasedImpl processInfo_CpuNumCore;
    private AttributeByteArrayBasedImpl processInfo_WorkingDir;
    private AttributeByteArrayBasedImpl processInfo_Executable;
    private AttributeByteArrayBasedImpl processInfo_SysCpuTime;
    private AttributeByteArrayBasedImpl processInfo_UserCpuTime;
    private AttributeByteArrayBasedImpl processInfo_ElapsedTime;
    private AttributeByteArrayBasedImpl vminfo_JvmTag;
    private AttributeByteArrayBasedImpl vminfo_JavaArguments;
    private AttributeByteArrayBasedImpl vminfo_JavaJarMainClass;
    private AttributeByteArrayBasedImpl vmInfo_SapSystem;
    private AttributeByteArrayBasedImpl vmInfo_DebuggingPort;
    private AttributeByteArrayBasedImpl vmInfo_DebuggingClient;
    private AttributeByteArrayBasedImpl vmInfo_DebuggingMode;
    private AttributeByteArrayBasedImpl gc_HeapCurrentUsed;
    private AttributeByteArrayBasedImpl gc_HeapCapacity;
    private AttributeByteArrayBasedImpl gc_Nr;
    private AttributeByteArrayBasedImpl gc_FullNr;
    private AttributeByteArrayBasedImpl gc_MaxOldGenerationSize;

    BoardControlAreaBasedImpl(Vm vm, String hostname, int pid, int instanceId) throws InvalidVmException {
        int i;
        String[] vmArgs;
        String[] javaArgs;
        String vmVersion;
        String mainClass;
        String javaArguments;
        String vmTag;
        String workingDir;
        this.myVm = vm;
        this.myPid = pid;
        this.boardState = BoardState.TYPE_ALIVE;
        this.timeStampLastUpdate = System.currentTimeMillis();
        byte[] emptyBuffer = new byte[]{};
        byte[] shortBuffer = new byte[2];
        byte[] intBuffer = new byte[4];
        byte[] longBuffer = new byte[8];
        ByteBuffer shortByteBuffer = ByteBuffer.wrap(shortBuffer);
        ByteBuffer intByteBuffer = ByteBuffer.wrap(intBuffer);
        ByteBuffer longByteBuffer = ByteBuffer.wrap(longBuffer);
        intByteBuffer.putInt(pid);
        this.processInfo_Pid = new AttributeByteArrayBasedImpl("PID", intBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT32, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NONE);
        this.processInfo_Hostname = new AttributeByteArrayBasedImpl("HOSTNAME", hostname.getBytes(), hostname.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NONE);
        this.processInfo_UserName = new AttributeByteArrayBasedImpl("USER_NAME", NOT_AVAILABLE.getBytes(), NOT_AVAILABLE.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NONE);
        intByteBuffer.clear();
        intByteBuffer.putInt(0);
        this.processInfo_ParentPid = new AttributeByteArrayBasedImpl("PARENT_PID", intBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT32, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NONE);
        shortByteBuffer.putShort((short)InspectorInfo.getCpuCount());
        this.processInfo_CpuNumCore = new AttributeByteArrayBasedImpl("CPU_NUM_CORES", shortBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT16, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NUMBER);
        try {
            VmStartInfo vmStartInfo = vm.getStartInfo();
            workingDir = this.replaceNullWithEmptyString(vmStartInfo.getWorkingDirectory());
            vmTag = this.replaceNullWithEmptyString(vmStartInfo.getVmTag());
            javaArguments = this.replaceNullWithEmptyString(vmStartInfo.getJavaArguments());
            mainClass = this.replaceNullWithEmptyString(vmStartInfo.getMainClass());
            vmVersion = this.replaceNullWithEmptyString(vmStartInfo.getVmVersion());
            javaArgs = this.replaceNullWithEmptyArray(vmStartInfo.getJavaArgumentsAsArray());
            vmArgs = this.replaceNullWithEmptyArray(vmStartInfo.getVmArguments());
        }
        catch (InvalidVmException ex) {
            this.boardState = BoardState.TYPE_DEAD;
            Trace.get(BoardImpl.class).debug((Throwable)ex, " myVm.getStartInfo() within BoardControlAreaBasedImpl for process " + pid + " fails, assume board area is dead ...");
            vmVersion = UNKNOWN;
            mainClass = UNKNOWN;
            javaArguments = UNKNOWN;
            vmTag = UNKNOWN;
            workingDir = UNKNOWN;
            vmArgs = EMPTY_ARRAY;
            javaArgs = EMPTY_ARRAY;
        }
        this.processInfo_WorkingDir = new AttributeByteArrayBasedImpl("WORKINGDIR", workingDir.getBytes(), workingDir.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING);
        this.processInfo_Executable = new AttributeByteArrayBasedImpl("EXECUTABLE", NOT_AVAILABLE.getBytes(), NOT_AVAILABLE.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING);
        this.vminfo_JvmTag = new AttributeByteArrayBasedImpl("JVM_TAG", vmTag.getBytes(), vmTag.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING);
        this.vminfo_JavaArguments = new AttributeByteArrayBasedImpl("JAVA_ARGUMENTS", javaArguments.getBytes(), javaArguments.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING);
        this.vminfo_JavaJarMainClass = new AttributeByteArrayBasedImpl("JAVA_MAINCLASS", mainClass.getBytes(), mainClass.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING);
        this.attributes.add(new AttributeByteArrayBasedImpl("VM_VERSION_STRING", vmVersion.getBytes(), vmVersion.getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING));
        for (i = 0; i < javaArgs.length; ++i) {
            this.attributes.add(new AttributeByteArrayBasedImpl("JAVA_ARGUMENT" + i, javaArgs[i].getBytes(), javaArgs[i].getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING));
        }
        for (i = 0; i < vmArgs.length; ++i) {
            this.attributes.add(new AttributeByteArrayBasedImpl("JVM_ARGUMENT" + i, vmArgs[i].getBytes(), vmArgs[i].getBytes().length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_UTF8STRING));
        }
        intByteBuffer.clear();
        intByteBuffer.putInt(instanceId >= 0 ? instanceId : -1);
        this.vmInfo_SapSystem = new AttributeByteArrayBasedImpl("SAP_SYSTEM", intBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_INT32, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_NONE);
        intByteBuffer.clear();
        intByteBuffer.putInt(-1);
        this.vmInfo_DebuggingPort = new AttributeByteArrayBasedImpl("DEBUGGING_PORT", intBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_INT32, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_NONE);
        this.vmInfo_DebuggingClient = new AttributeByteArrayBasedImpl("DEBUGGING_CLIENT", emptyBuffer, emptyBuffer.length, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_CHAR, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_UTF8STRING);
        shortByteBuffer.clear();
        shortByteBuffer.putShort(0, (short)0);
        this.vmInfo_DebuggingMode = new AttributeByteArrayBasedImpl("DEBUGGING_MODE", shortBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_VMINFO, AttributeDataType.TYPE_INT16, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_DEBUGGINGMODE);
        longByteBuffer.putLong(-1L);
        this.processInfo_SysCpuTime = new AttributeByteArrayBasedImpl("SYS_CPU_TIME", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND);
        this.processInfo_UserCpuTime = new AttributeByteArrayBasedImpl("USER_CPU_TIME", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND);
        this.processInfo_ElapsedTime = new AttributeByteArrayBasedImpl("ELAPSED_TIME", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_PROCESSINFO, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND);
        this.gc_HeapCurrentUsed = new AttributeByteArrayBasedImpl("HEAP_CURRENT_USED", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_GC, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_BYTE);
        this.gc_HeapCapacity = new AttributeByteArrayBasedImpl("HEAP_CAPACITY", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_GC, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_BYTE);
        this.gc_Nr = new AttributeByteArrayBasedImpl("NUM_GCS", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_GC, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_COUNTER);
        this.gc_FullNr = new AttributeByteArrayBasedImpl("NUM_FULL_GCS", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_GC, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_DYNAMIC, AttributeUnitType.TYPE_COUNTER);
        this.gc_MaxOldGenerationSize = new AttributeByteArrayBasedImpl("JAVA_HEAP_RESERVED", longBuffer, 1, this.timeStampLastUpdate, AttributeGroupType.TYPE_GC, AttributeDataType.TYPE_INT64, AttributeVariabilityType.TYPE_STATIC, AttributeUnitType.TYPE_BYTE);
        this.attributes.add(this.processInfo_Pid);
        this.attributes.add(this.processInfo_Hostname);
        this.attributes.add(this.processInfo_UserName);
        this.attributes.add(this.processInfo_ParentPid);
        this.attributes.add(this.processInfo_CpuNumCore);
        this.attributes.add(this.processInfo_WorkingDir);
        this.attributes.add(this.processInfo_Executable);
        this.attributes.add(this.processInfo_SysCpuTime);
        this.attributes.add(this.processInfo_UserCpuTime);
        this.attributes.add(this.processInfo_ElapsedTime);
        this.attributes.add(this.vminfo_JvmTag);
        this.attributes.add(this.vminfo_JavaArguments);
        this.attributes.add(this.vminfo_JavaJarMainClass);
        this.attributes.add(this.vmInfo_SapSystem);
        this.attributes.add(this.gc_HeapCurrentUsed);
        this.attributes.add(this.gc_HeapCapacity);
        this.attributes.add(this.gc_Nr);
        this.attributes.add(this.gc_FullNr);
        this.attributes.add(this.gc_MaxOldGenerationSize);
        this.attributes.add(this.vmInfo_DebuggingPort);
        this.attributes.add(this.vmInfo_DebuggingClient);
        this.attributes.add(this.vmInfo_DebuggingMode);
        if (this.isAlive()) {
            this.updateDynamicAttribute(vm);
        }
    }

    private String replaceNullWithEmptyString(String toBeChecked) {
        return toBeChecked == null ? EMPTY_STRING : toBeChecked;
    }

    private String[] replaceNullWithEmptyArray(String[] toBeChecked) {
        return toBeChecked == null ? EMPTY_ARRAY : toBeChecked;
    }

    private void updateDynamicAttribute(Vm vm) {
        byte[] shortBuffer = new byte[2];
        byte[] intBuffer = new byte[4];
        byte[] longBuffer = new byte[8];
        ByteBuffer.wrap(longBuffer).putLong(-1L);
        try {
            VmTimeInfo timeInfo = vm.getTimeInfo();
            ByteBuffer.wrap(longBuffer).putLong(timeInfo != null ? timeInfo.getSystemTime() : -1L);
            this.processInfo_SysCpuTime.update(longBuffer);
            ByteBuffer.wrap(longBuffer).putLong(timeInfo != null ? timeInfo.getUserTime() : -1L);
            this.processInfo_UserCpuTime.update(longBuffer);
            ByteBuffer.wrap(longBuffer).putLong(timeInfo != null ? timeInfo.getProcessingTime() : -1L);
            this.processInfo_ElapsedTime.update(longBuffer);
            VmMemoryInfo memoryInfo = vm.getMemoryInfo();
            ByteBuffer.wrap(longBuffer).putLong(memoryInfo != null ? memoryInfo.getGcNr() : -1L);
            this.gc_Nr.update(longBuffer);
            ByteBuffer.wrap(longBuffer).putLong(memoryInfo != null ? memoryInfo.getFullGcNr() : -1L);
            this.gc_FullNr.update(longBuffer);
            if (memoryInfo != null && memoryInfo.getMaxOldGenMemorySize() > 0L) {
                ByteBuffer.wrap(longBuffer).putLong(memoryInfo.getMaxOldGenMemorySize());
                this.gc_MaxOldGenerationSize.update(longBuffer);
            }
            VmDebugInfo debugInfo = vm.getDebugInfo();
            ByteBuffer.wrap(intBuffer).putInt(debugInfo != null ? debugInfo.getDebugPort() : -1);
            this.vmInfo_DebuggingPort.update(intBuffer);
            this.vmInfo_DebuggingClient.update(vm.getDebugInfo().getDebugClient().getBytes());
            ByteBuffer.wrap(shortBuffer).putShort((short)0);
            if ((debugInfo != null ? debugInfo.getDebugPort() : -1) > 0) {
                ByteBuffer.wrap(shortBuffer).putShort(0, (short)1);
            }
            this.vmInfo_DebuggingMode.update(shortBuffer);
        }
        catch (InvalidVmException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "myVm.getTimeInfo() or myVm.getMemoryInfo() fails, assume that the process is gone...");
            this.setBoardState(BoardState.TYPE_DEAD);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public boolean belongsToOwnProcess() {
        return InspectorInfo.getOwnProcessId() == this.getPid();
    }

    @Override
    public int getPid() {
        return this.myPid;
    }

    @Override
    public boolean update() throws MonitorBoardFormatException {
        this.timeStampLastUpdate = System.currentTimeMillis();
        this.updateDynamicAttribute(this.myVm);
        this.callUpdateListener();
        return true;
    }

    @Override
    public int getSize() {
        return this.getCurrentByteBuffer().limit();
    }

    public void setSomeTestData(long timestamp, int pid, BoardState boardstate, short valueForDynamicData) {
        this.timeStampLastUpdate = timestamp;
        this.myPid = pid;
        this.boardState = boardstate;
        Iterator attrs = this.getAttributeIterator();
        while (attrs.hasNext()) {
            AttributeByteArrayBasedImpl attribute = (AttributeByteArrayBasedImpl)attrs.next();
            if (attribute.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC || attribute.getDataType() == AttributeDataType.TYPE_CHAR) continue;
            byte[] temp = attribute.getCopyOfRawData();
            ByteBuffer.wrap(temp).putShort(valueForDynamicData);
            attribute.update(temp);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoardControlAreaBasedImpl) {
            BoardControlAreaBasedImpl other = (BoardControlAreaBasedImpl)obj;
            return this.myPid == other.getPid() && this.getStartingTimeStamp() == other.getStartingTimeStamp();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * this.myPid + (int)(this.getStartingTimeStamp() ^ this.getStartingTimeStamp() >>> 32);
    }
}

