/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.AttributeByteArrayBasedImpl;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardControlAreaBasedCommonImpl;
import com.sap.jvm.inspector.board.BoardEx;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfo;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfoEx;
import com.sap.jvm.tracing.Trace;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class BoardControlAreaBasedOnByteBufferImpl
extends BoardControlAreaBasedCommonImpl
implements BoardEx {
    private int pid;
    private int sizeOfByteBuffer;
    private final Connectability canBeAttached;

    public BoardControlAreaBasedOnByteBufferImpl(RemoteBoardInfo boardInfoRar) throws MonitorBoardFormatException {
        this.canBeAttached = boardInfoRar instanceof RemoteBoardInfoEx ? ((RemoteBoardInfoEx)boardInfoRar).connectabilityState : Connectability.TYPE_UNKNOWN;
        this.init(boardInfoRar);
    }

    public synchronized void init(RemoteBoardInfo boardInfoRar) throws MonitorBoardFormatException {
        this.attributes.clear();
        ByteBuffer buffer = ByteBuffer.wrap(boardInfoRar.boardContentBuffer);
        buffer.position(0);
        int magicNumberOfByteBuffer = buffer.getInt();
        if (magicNumberOfByteBuffer != BoardControlAreaBasedCommonImpl.magicNumberOfFullContent) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Magic number " + magicNumberOfByteBuffer + " is not accepted by BoardControlAreaBasedOnByteBufferImpl( " + BoardControlAreaBasedCommonImpl.magicNumberOfFullContent + ")");
            Trace.get(BoardImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        short versionOfByteBuffer = buffer.getShort();
        if (versionOfByteBuffer > 0) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Version " + versionOfByteBuffer + " is not accepted by BoardControlAreaBasedOnByteBufferImpl( " + 0 + ")");
            Trace.get(BoardImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        this.pid = buffer.getInt();
        this.timeStampLastUpdate = buffer.getLong();
        this.boardState = BoardState.getGroupType(buffer.getInt());
        int countOfAttributes = buffer.getInt();
        this.attributes = new ArrayList(countOfAttributes);
        for (int i = 0; i < countOfAttributes; ++i) {
            int sizeOfAttributeDefinition = buffer.getInt();
            byte[] temp = new byte[sizeOfAttributeDefinition];
            buffer.get(temp);
            this.attributes.add(new AttributeByteArrayBasedImpl(ByteBuffer.wrap(temp)));
        }
        this.sizeOfByteBuffer = buffer.position();
        this.callUpdateListener();
    }

    @Override
    public int getSize() {
        return this.sizeOfByteBuffer;
    }

    @Override
    public Connectability getAttachStatus() {
        return this.canBeAttached;
    }

    public synchronized boolean update(byte[] dynamicContent, boolean writeSize4dynamicCharAttributes) throws MonitorBoardFormatException {
        ByteBuffer buffer = ByteBuffer.wrap(dynamicContent);
        int magicNumberOfContent = buffer.getInt();
        if (magicNumberOfContent != BoardControlAreaBasedCommonImpl.magicNumberOfDynamicContent) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Magic number " + magicNumberOfContent + " is not accepted by BoardControlAreaBasedOnByteBufferImpl (update)( " + BoardControlAreaBasedCommonImpl.magicNumberOfDynamicContent + ")");
            Trace.get(BoardImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        int pid1 = buffer.getInt();
        if (pid1 != this.pid) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Pid " + pid1 + " doesn't match to the boards pid " + this.pid + "(BoardControlAreaBasedCommonImpl)");
            Trace.get(BoardImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        this.timeStampLastUpdate = buffer.getLong();
        this.boardState = BoardState.getGroupType(buffer.getInt());
        Iterator attrs = this.getAttributeIterator();
        attrs = this.getAttributeIterator();
        while (attrs.hasNext()) {
            AttributeByteArrayBasedImpl attribute = (AttributeByteArrayBasedImpl)attrs.next();
            if (attribute.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            byte[] temp = attribute.getCopyOfRawData();
            if (writeSize4dynamicCharAttributes && attribute.getDataType() == AttributeDataType.TYPE_CHAR) {
                int sizeOfDatas = temp.length;
                sizeOfDatas = buffer.getInt();
                temp = new byte[sizeOfDatas];
            }
            buffer.get(temp);
            attribute.update(temp);
        }
        this.callUpdateListener();
        return true;
    }

    @Override
    public boolean update() throws MonitorBoardFormatException {
        return false;
    }

    @Override
    public boolean belongsToOwnProcess() {
        return false;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoardControlAreaBasedOnByteBufferImpl) {
            BoardControlAreaBasedOnByteBufferImpl other = (BoardControlAreaBasedOnByteBufferImpl)obj;
            return this.getPid() == other.getPid() && this.getStartingTimeStamp() == other.getStartingTimeStamp();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 * this.getPid() + (int)(this.getStartingTimeStamp() ^ this.getStartingTimeStamp() >>> 32);
    }
}

