/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.BoardDirectBufferImpl;
import com.sap.jvm.inspector.board.BoardFileBasedImpl;
import com.sap.jvm.inspector.board.BoardInternal;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BoardDelegateImpl
implements BoardInternal {
    private BoardInternal the_delegate = null;

    public BoardDelegateImpl(ByteBuffer boardContentBuffer, int pid) {
        this.the_delegate = new BoardDirectBufferImpl(boardContentBuffer, pid);
    }

    public BoardDelegateImpl(String fileName, int pid) {
        this.the_delegate = new BoardFileBasedImpl(fileName, pid);
    }

    public BoardDelegateImpl(BoardInternal delegate) {
        this.the_delegate = delegate;
    }

    public BoardInternal setDelegate(BoardInternal newBoard) {
        BoardInternal old = this.the_delegate;
        this.the_delegate = newBoard;
        Iterator<BoardUpdateListener> iter = old.getBoardListener();
        while (iter.hasNext()) {
            this.the_delegate.addBoardUpdateListener(iter.next());
        }
        return old;
    }

    public BoardInternal getDelegate() {
        return this.the_delegate;
    }

    @Override
    public int getSize() {
        return this.the_delegate.getSize();
    }

    @Override
    public long getTimeStamp() {
        return this.the_delegate.getTimeStamp();
    }

    @Override
    public int getMajorVersion() {
        return this.the_delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.the_delegate.getMinorVersion();
    }

    @Override
    public int getNumAttributes() {
        return this.the_delegate.getNumAttributes();
    }

    @Override
    public int getUpdateTime() {
        return this.the_delegate.getUpdateTime();
    }

    @Override
    public Iterator<Attribute> getAttributeIterator() {
        return this.the_delegate.getAttributeIterator();
    }

    @Override
    public boolean update() throws MonitorBoardFormatException {
        return this.the_delegate.update();
    }

    @Override
    public Attribute get(String name) {
        return this.the_delegate.get(name);
    }

    @Override
    public boolean isAlive() {
        return this.the_delegate.isAlive();
    }

    @Override
    public BoardState getState() {
        return this.the_delegate.getState();
    }

    @Override
    public boolean belongsToOwnProcess() {
        return this.the_delegate.belongsToOwnProcess();
    }

    @Override
    public int getPid() {
        return this.the_delegate.getPid();
    }

    @Override
    public void addBoardUpdateListener(BoardUpdateListener listener) {
        this.the_delegate.addBoardUpdateListener(listener);
    }

    @Override
    public void removeBoardUpdateListener(BoardUpdateListener listener) {
        this.the_delegate.removeBoardUpdateListener(listener);
    }

    @Override
    public long getStartingTimeStamp() {
        return this.the_delegate.getStartingTimeStamp();
    }

    @Override
    public boolean isBoardBased() {
        return this.the_delegate.isBoardBased();
    }

    @Override
    public void processOfBoardIsGone() {
        this.the_delegate.processOfBoardIsGone();
    }

    @Override
    public Iterator<BoardUpdateListener> getBoardListener() {
        return this.the_delegate.getBoardListener();
    }

    @Override
    public ByteBuffer getCurrentByteBuffer() {
        return this.the_delegate.getCurrentByteBuffer();
    }

    @Override
    public ByteBuffer getDynamicPartsOfBoardAsByteArray(boolean addSize4DynamicCharAttributes) {
        return this.the_delegate.getDynamicPartsOfBoardAsByteArray(addSize4DynamicCharAttributes);
    }

    @Override
    public void lostConnection() {
        this.the_delegate.lostConnection();
    }
}

