/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.ByteConverter;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BoardDirectBufferImpl
extends BoardImpl {
    private final ByteBuffer directBufferContent;

    public BoardDirectBufferImpl(ByteBuffer boardContentBuffer, int pid) {
        super(pid);
        this.directBufferContent = boardContentBuffer;
        this.init(this.getCurrentByteBuffer(), pid);
    }

    public BoardDirectBufferImpl(byte[] buffer) {
        this(ByteBuffer.wrap(buffer), ByteConverter.readInt32(buffer, 8));
    }

    @Override
    public synchronized ByteBuffer getCurrentByteBuffer() {
        if (!this.isAlive()) {
            return null;
        }
        byte[] content = new byte[this.directBufferContent.capacity()];
        this.directBufferContent.position(0);
        try {
            this.directBufferContent.get(content);
        }
        catch (BufferUnderflowException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "BufferUnderflowException while reading direct buffer values...");
            return null;
        }
        if (!this.directBufferContent.isDirect()) {
            ByteBuffer candidate = ByteBuffer.wrap(content);
            if (BoardImpl.verifyByteBuffer(candidate)) {
                return candidate;
            }
            return null;
        }
        int tries = 0;
        do {
            ByteBuffer candidate;
            if (BoardImpl.verifyByteBuffer(candidate = ByteBuffer.wrap(content))) {
                return candidate;
            }
            ++tries;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.directBufferContent.position(0);
            this.directBufferContent.get(content);
        } while (tries < 100);
        return null;
    }

    @Override
    public synchronized boolean update() throws MonitorBoardFormatException {
        ByteBuffer buffer = this.getCurrentByteBuffer();
        if (buffer == null) {
            return false;
        }
        try {
            if (this.updateBoard(buffer, true)) {
                Iterator iter = this.updateListener.iterator();
                while (iter.hasNext()) {
                    ((BoardUpdateListener)iter.next()).updateHasBeenProcessed(this);
                }
                return true;
            }
        }
        catch (MonitorBoardFormatException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "MonitorBoardFormatException during update");
            throw ex;
        }
        catch (IOException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "IOException during update ");
            throw new MonitorBoardFormatException("Got IOException " + ex.getMessage());
        }
        return false;
    }

    @Override
    public boolean belongsToOwnProcess() {
        return InspectorInfo.getOwnProcessId() == this.getPid();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoardDirectBufferImpl) {
            BoardDirectBufferImpl other = (BoardDirectBufferImpl)obj;
            return this.getPid() == other.getPid() && this.getStartingTimeStamp() == other.getStartingTimeStamp();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * this.getPid() + (int)(this.getStartingTimeStamp() ^ this.getStartingTimeStamp() >>> 32);
        return result;
    }
}

