/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardDirectBufferImpl;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BoardFileBasedImpl
extends BoardImpl {
    private final File theFile;
    private RandomAccessFile theRaFile;

    public BoardFileBasedImpl(String boardFile, int pid) {
        super(pid);
        this.theFile = new File(boardFile);
        this.theRaFile = null;
        this.init(this.getCurrentByteBuffer(), pid);
    }

    public String getFileName() {
        return this.theFile.getAbsolutePath();
    }

    private byte[] readBoardFileContent() {
        byte[] result = new byte[(int)this.theFile.length()];
        try {
            if (this.theRaFile == null) {
                this.theRaFile = new RandomAccessFile(this.theFile, "r");
            }
            this.theRaFile.seek(0L);
            this.theRaFile.read(result);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            if (this.theRaFile != null) {
                try {
                    this.theRaFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.theRaFile = null;
            return null;
        }
        return result;
    }

    @Override
    public synchronized ByteBuffer getCurrentByteBuffer() {
        if (!this.isAlive()) {
            return null;
        }
        byte[] content = this.readBoardFileContent();
        int tries = 0;
        do {
            ByteBuffer candidate;
            if (content != null && BoardImpl.verifyByteBuffer(candidate = ByteBuffer.wrap(content))) {
                return candidate;
            }
            ++tries;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            content = this.readBoardFileContent();
        } while (tries < 100);
        return null;
    }

    @Override
    public synchronized boolean update() throws MonitorBoardFormatException {
        ByteBuffer buffer = this.getCurrentByteBuffer();
        if (buffer == null) {
            return false;
        }
        try {
            if (this.updateBoard(buffer, true)) {
                Iterator iter = this.updateListener.iterator();
                while (iter.hasNext()) {
                    ((BoardUpdateListener)iter.next()).updateHasBeenProcessed(this);
                }
                return true;
            }
        }
        catch (MonitorBoardFormatException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "MonitorBoardFormatException during update");
            throw ex;
        }
        catch (IOException ex) {
            Trace.get(BoardImpl.class).debug((Throwable)ex, "IOException during update");
            throw new MonitorBoardFormatException("Got IOException " + ex.getMessage());
        }
        return false;
    }

    @Override
    public boolean belongsToOwnProcess() {
        return InspectorInfo.getOwnProcessId() == this.getPid();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoardDirectBufferImpl) {
            BoardDirectBufferImpl other = (BoardDirectBufferImpl)obj;
            return this.getPid() == other.getPid() && this.getStartingTimeStamp() == other.getStartingTimeStamp();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * this.getPid() + (int)(this.getStartingTimeStamp() ^ this.getStartingTimeStamp() >>> 32);
        return result;
    }
}

