/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.KnownAttribute;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;

public class BoardHelpers {
    public static String getBoardAttributeAsString(Board board, KnownAttribute attrKey) {
        try {
            Attribute attr = board.get(attrKey.name());
            if (attr != null) {
                return attr.getValue().getAsString();
            }
        }
        catch (MonitorBoardFormatException monitorBoardFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Long getBoardAttributeAsLong(Board board, KnownAttribute attrKey) {
        try {
            Attribute attr = board.get(attrKey.name());
            if (attr != null) {
                return attr.getValue().getLongValue();
            }
        }
        catch (MonitorBoardFormatException | NumberFormatException exception) {
            // empty catch block
        }
        return null;
    }
}

