/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeImpl;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardInternal;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class BoardImpl
implements BoardInternal {
    public static final int MAGIC_NUMBER = -1412584499;
    public static final int MAGIC_NR_OFFSET = 0;
    public static final int BOARD_SIZE_OFFSET = 4;
    public static final int PID_OFFSET = 8;
    public static final int TIME_STAMP_OFFSET = 12;
    public static final int MAJOR_VERSION_OFFSET = 20;
    public static final int MINOR_VERSION_OFFSET = 24;
    public static final int ATTRIBUTE_COUNT_OFFSET = 28;
    public static final int UPDATE_TIME_OFFSET = 32;
    public static final int ATTRIBUTE_START_OFFSET = 36;
    public static final int START_TIME_STAMP_OFFSET = 40;
    public static final int CRC_SIZE = 8;
    public static final int MAGIC_NUMBER_SIZE = 4;
    private static final Tracer trc = Trace.get(BoardImpl.class);
    private int boardSize = 0;
    private int ownPid;
    private long timeStamp = 0L;
    private int majorVersion;
    private int minorVersion;
    private int numAttributes;
    private int updateTime;
    private int attributeOffset;
    private long startingTimeStamp;
    private BoardState boardState;
    private Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
    protected Set<BoardUpdateListener> updateListener = new LinkedHashSet<BoardUpdateListener>();
    static boolean checkProcessCreationTime = System.getProperty("com.sap.jvm.inspector.impl.board.BoardImpl.OmitProcessCreationTimeCheck") == null;

    @Override
    public synchronized int getSize() {
        return this.boardSize;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getNumAttributes() {
        return this.numAttributes;
    }

    @Override
    public synchronized int getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public int getPid() {
        return this.ownPid;
    }

    @Override
    public long getStartingTimeStamp() {
        return this.startingTimeStamp;
    }

    @Override
    public boolean isAlive() {
        return this.boardState == BoardState.TYPE_ALIVE || this.boardState == BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
    }

    @Override
    public synchronized Iterator<Attribute> getAttributeIterator() {
        return this.attributes.values().iterator();
    }

    @Override
    public synchronized Attribute get(String name) {
        return this.attributes.get(name);
    }

    @Override
    public BoardState getState() {
        return this.boardState;
    }

    private static int getOffsetToCrc(ByteBuffer boardContentBuffer) {
        return BoardImpl.getBoardSize(boardContentBuffer) - 8 - 4;
    }

    public static byte[] getCrc(ByteBuffer boardContentBuffer) {
        try {
            byte[] crc = new byte[8];
            boardContentBuffer.position(BoardImpl.getOffsetToCrc(boardContentBuffer));
            boardContentBuffer.get(crc, 0, 8);
            return crc;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setCrc(ByteBuffer dest, byte[] crc) {
        dest.position(BoardImpl.getOffsetToCrc(dest));
        dest.put(crc, 0, 8);
    }

    public static boolean checkCrc(ByteBuffer boardContentBuffer) {
        try {
            byte[] calculatedCrc = new byte[8];
            int lengthToBecheck = BoardImpl.getOffsetToCrc(boardContentBuffer);
            int crcPosition = 0;
            for (int i = 0; i < lengthToBecheck; ++i) {
                int n = crcPosition++;
                calculatedCrc[n] = (byte)(calculatedCrc[n] ^ boardContentBuffer.get(i));
                if (crcPosition != 8) continue;
                crcPosition = 0;
            }
            byte[] currentCrc = BoardImpl.getCrc(boardContentBuffer);
            if (currentCrc == null) {
                return false;
            }
            for (int i = 0; i < 8; ++i) {
                if (calculatedCrc[i] == currentCrc[i]) continue;
                trc.debug("Crc doesn't match to the board content ....");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean verifyByteBuffer(ByteBuffer boardContentBuffer) {
        try {
            int majorVersion = boardContentBuffer.getInt(20);
            int minorVersion = boardContentBuffer.getInt(24);
            int boardSize = BoardImpl.getBoardSize(boardContentBuffer);
            if (majorVersion == 1 && minorVersion > 0) {
                return BoardImpl.checkCrc(boardContentBuffer);
            }
            if (majorVersion == 1 && boardContentBuffer.getLong(12) == boardContentBuffer.getLong(boardSize - 4 - 8)) {
                return true;
            }
            trc.debug("Version major:%s minor:%s is not supported.", majorVersion, minorVersion);
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    private boolean isProtocolVersionSupported(int major, int minor) {
        return major <= 1;
    }

    protected BoardImpl(int pid) {
        this.ownPid = pid;
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.numAttributes = 0;
        this.attributeOffset = 0;
        this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
        this.startingTimeStamp = 0L;
    }

    public synchronized void update(ByteBuffer boardContentBuffer, int pid) {
        this.init(boardContentBuffer, pid);
        Iterator<BoardUpdateListener> iter = this.updateListener.iterator();
        while (iter.hasNext()) {
            iter.next().updateHasBeenProcessed(this);
        }
    }

    protected void init(ByteBuffer boardContentBuffer, int pid) {
        if (boardContentBuffer == null) {
            this.boardSize = 0;
            this.timeStamp = 0L;
            this.ownPid = pid;
            this.majorVersion = 0;
            this.minorVersion = 0;
            this.numAttributes = 0;
            this.attributeOffset = 0;
            this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
            this.startingTimeStamp = 0L;
        } else {
            this.boardState = BoardState.TYPE_ALIVE;
            boardContentBuffer.order(ByteOrder.BIG_ENDIAN);
            int magicNumberFromBuffer = boardContentBuffer.getInt(0);
            if (MAGIC_NUMBER != magicNumberFromBuffer) {
                trc.warn(String.format("Found wrong eye catcher (%s) in the board header pid: %s", magicNumberFromBuffer, pid));
                this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                BoardImpl.writeByteBufferToFile(boardContentBuffer, pid, (long)magicNumberFromBuffer, (Throwable)new MonitorBoardFormatException("Found wrong eye catcher"));
                return;
            }
            this.boardSize = boardContentBuffer.getInt(4);
            if (this.boardSize > boardContentBuffer.capacity()) {
                trc.warn(String.format("Invalid board size  board size(%s) > buffer size(%s), (%s)", this.boardSize, boardContentBuffer.capacity(), pid));
                this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                BoardImpl.writeByteBufferToFile(boardContentBuffer, pid, (long)magicNumberFromBuffer, (Throwable)new MonitorBoardFormatException("Invalid board size " + this.boardSize));
                return;
            }
            if (!BoardImpl.verifyByteBuffer(boardContentBuffer)) {
                this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                return;
            }
            this.ownPid = boardContentBuffer.getInt(8);
            this.updateTime = boardContentBuffer.getInt(32);
            if (pid != 0 & this.ownPid != pid) {
                trc.warn(String.format("Pid in ByteBuffer(%s) doesn't match to the requested %s", this.ownPid, pid));
                this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                BoardImpl.writeByteBufferToFile(boardContentBuffer, this.ownPid, (long)this.updateTime, (Throwable)new MonitorBoardFormatException("Invalid pid: found " + pid + " instead of " + this.ownPid));
                return;
            }
            this.majorVersion = boardContentBuffer.getInt(20);
            this.minorVersion = boardContentBuffer.getInt(24);
            if (!this.isProtocolVersionSupported(this.majorVersion, this.minorVersion)) {
                this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                this.boardSize = 0;
                this.numAttributes = 0;
                this.updateTime = 0;
                this.attributeOffset = 0;
                return;
            }
            this.startingTimeStamp = BoardImpl.getStartingTimeStamp(boardContentBuffer);
            this.boardSize = boardContentBuffer.getInt(4);
            this.timeStamp = boardContentBuffer.getLong(12);
            this.numAttributes = boardContentBuffer.getInt(28);
            this.attributeOffset = boardContentBuffer.getInt(36);
            trc.debug("Board pid %s (attr count: %s) isControlAreaBased: %s", this.ownPid, this.numAttributes, !this.isBoardBased());
            int startOfTheNextParameterDefinition = this.attributeOffset;
            for (int i = 0; i < this.numAttributes; ++i) {
                String name;
                AttributeImpl attr;
                try {
                    attr = new AttributeImpl(this, boardContentBuffer, startOfTheNextParameterDefinition, -1);
                    name = attr.getName();
                }
                catch (MonitorBoardFormatException ex) {
                    trc.warn(String.format("Got a MonitorBoardFormatException during reading attributes for pid (%s)", this.ownPid));
                    this.boardState = BoardState.TYPE_ALIVE_UNREADABLE_BOARD;
                    this.attributes.clear();
                    this.numAttributes = 0;
                    BoardImpl.writeByteBufferToFile(boardContentBuffer, this.ownPid, (long)this.updateTime, (Throwable)ex);
                    return;
                }
                startOfTheNextParameterDefinition += attr.getLengthInBytes();
                this.attributes.put(name, attr);
            }
        }
    }

    @Override
    public abstract boolean update() throws MonitorBoardFormatException;

    protected static void writeByteBufferToFile(ByteBuffer boardContentBuffer, int pid, long timestamp, Throwable throwable) {
        String filename = pid + "_MonitorBoardFormatException_" + timestamp + ".board";
        BoardImpl.writeByteBufferToFile(boardContentBuffer, filename, pid, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeByteBufferToFile(ByteBuffer boardContentBuffer, String filename, int pid, Throwable throwable) {
        FileOutputStream outputFile;
        String rootDir = System.getProperty("java.io.tmpdir");
        String dumpDirectory = rootDir + File.separator + pid;
        new File(dumpDirectory).mkdir();
        try {
            outputFile = new FileOutputStream(dumpDirectory + File.separator + filename, false);
        }
        catch (FileNotFoundException ex) {
            trc.error((Throwable)ex, "New FileOutputStream ");
            return;
        }
        FileChannel outChannel = outputFile.getChannel();
        try {
            boardContentBuffer.position(0);
            outChannel.write(boardContentBuffer);
            if (throwable != null) {
                outChannel.write(ByteBuffer.wrap(throwable.getMessage().getBytes()));
                outChannel.write(ByteBuffer.wrap(new String(" ownpid:" + pid).getBytes()));
                FileOutputStream markerFile = new FileOutputStream(rootDir + File.separator + filename, false);
                markerFile.close();
            } else {
                outChannel.write(ByteBuffer.wrap(new String("Everything was fine, just record the board  ").getBytes()));
            }
        }
        catch (IOException ex) {
            trc.error((Throwable)ex, "New FileOutputStream ");
            return;
        }
        finally {
            try {
                outChannel.close();
                outputFile.close();
            }
            catch (IOException ex) {
                trc.error((Throwable)ex, "New FileOutputStream ");
            }
        }
    }

    public synchronized boolean updateBoard(ByteBuffer boardContentBuffer, boolean dataIsOnline) throws MonitorBoardFormatException, IOException {
        long processCreationTime;
        if (boardContentBuffer == null || !this.isAlive()) {
            return false;
        }
        long currentTimeStamp = boardContentBuffer.getLong(12);
        if (this.timeStamp == currentTimeStamp) {
            return true;
        }
        int pid = boardContentBuffer.getInt(8);
        if (this.ownPid != pid) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("PID in ByteBuffer(" + pid + ") doesn't match to the requested " + this.ownPid);
            trc.error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        if (this.startingTimeStamp != 0L && this.startingTimeStamp != BoardImpl.getStartingTimeStamp(boardContentBuffer)) {
            trc.debug(() -> "(starting timestamp of board) != (starting timestamp of byte buffer) for pid " + this.ownPid + " set board state to 'dead'");
            this.boardState = BoardState.TYPE_DEAD;
            return true;
        }
        if (checkProcessCreationTime && dataIsOnline && (processCreationTime = InspectorInfo.getCreationTimeOfProcess(this.getPid())) > 0L && currentTimeStamp < processCreationTime * 1000L) {
            trc.debug("timestamp %s of board for pid %s is older than process creation time %s. set board state to 'dead'", this.getTimeStamp(), this.ownPid, processCreationTime * 1000L);
            this.boardState = BoardState.TYPE_DEAD;
            return true;
        }
        this.timeStamp = currentTimeStamp;
        int i = 0;
        Iterator<Attribute> attributeIter = this.getAttributeIterator();
        while (attributeIter.hasNext()) {
            ++i;
            AttributeImpl attr = (AttributeImpl)attributeIter.next();
            if (attr.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            try {
                attr.update(boardContentBuffer);
            }
            catch (MonitorBoardFormatException ex) {
                BoardImpl.writeByteBufferToFile(boardContentBuffer, this.ownPid, this.timeStamp, (Throwable)ex);
                trc.error((Throwable)ex, "List Contains " + this.attributes.size() + " cur. Pos " + i);
                throw ex;
            }
            catch (OutOfMemoryError ex) {
                BoardImpl.writeByteBufferToFile(boardContentBuffer, this.ownPid, this.timeStamp, (Throwable)ex);
                trc.error((Throwable)ex, "List Contains " + this.attributes.size() + " cur. Pos " + i);
                throw ex;
            }
        }
        return true;
    }

    @Override
    public synchronized void processOfBoardIsGone() {
        if (this.boardState == BoardState.TYPE_ALIVE_UNREADABLE_BOARD) {
            this.boardState = BoardState.TYPE_DEAD_UNREADABLE_BOARD;
        }
        this.boardState = BoardState.TYPE_DEAD;
    }

    @Override
    public synchronized void lostConnection() {
        this.boardState = BoardState.TYPE_CONNECTION_LOST;
    }

    public static int getBoardSize(ByteBuffer contentBuffer) {
        contentBuffer.order(ByteOrder.BIG_ENDIAN);
        return contentBuffer.getInt(4);
    }

    public static int getPid(ByteBuffer contentBuffer) {
        contentBuffer.order(ByteOrder.BIG_ENDIAN);
        return contentBuffer.getInt(8);
    }

    public static long getStartingTimeStamp(ByteBuffer contentBuffer) {
        contentBuffer.order(ByteOrder.BIG_ENDIAN);
        int minorVersion = contentBuffer.getInt(24);
        if (minorVersion > 1) {
            return contentBuffer.getLong(40);
        }
        return 0L;
    }

    public static int getHeaderSize(ByteBuffer contentBuffer) {
        contentBuffer.order(ByteOrder.BIG_ENDIAN);
        return contentBuffer.getInt(36);
    }

    @Override
    public void addBoardUpdateListener(BoardUpdateListener listener) {
        this.updateListener.add(listener);
    }

    @Override
    public void removeBoardUpdateListener(BoardUpdateListener listener) {
        this.updateListener.remove(listener);
    }

    @Override
    public boolean isBoardBased() {
        return true;
    }

    @Override
    public int hashCode() {
        return (int)(((long)this.ownPid ^ this.startingTimeStamp) & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoardImpl) {
            BoardImpl other = (BoardImpl)obj;
            return this.ownPid == other.ownPid && this.startingTimeStamp == other.startingTimeStamp;
        }
        return false;
    }

    @Override
    public Iterator<BoardUpdateListener> getBoardListener() {
        return this.updateListener.iterator();
    }

    @Override
    public ByteBuffer getDynamicPartsOfBoardAsByteArray(boolean addSize4DynamicCharAttributes) {
        ByteBuffer contentBuffer = this.getCurrentByteBuffer();
        if (contentBuffer == null) {
            return null;
        }
        return this.getDynamicPartsOfBoardAsByteArray(contentBuffer, addSize4DynamicCharAttributes);
    }

    public synchronized ByteBuffer getDynamicPartsOfBoardAsByteArray(ByteBuffer contentBuffer, boolean addSize4DynamicCharAttributes) {
        if (contentBuffer == null) {
            return null;
        }
        assert (contentBuffer != null);
        this.update(contentBuffer, BoardImpl.getPid(contentBuffer));
        ByteArrayOutputStream tmpByteArray = new ByteArrayOutputStream();
        int headerSize = BoardImpl.getHeaderSize(contentBuffer);
        byte[] header = new byte[headerSize];
        contentBuffer.position(0);
        contentBuffer.get(header, 0, headerSize);
        tmpByteArray.write(header, 0, headerSize);
        Iterator<Attribute> attrs = this.getAttributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (attr.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            byte[] attrValueRaw = attr.getCopyOfRawData();
            if (attr.getDataType() == AttributeDataType.TYPE_CHAR && addSize4DynamicCharAttributes) {
                ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                sizeBuffer.putInt(attrValueRaw.length);
                tmpByteArray.write(sizeBuffer.array(), 0, sizeBuffer.array().length);
            }
            tmpByteArray.write(attrValueRaw, 0, attrValueRaw.length);
        }
        byte[] crc = BoardImpl.getCrc(contentBuffer);
        if (crc == null) {
            return null;
        }
        tmpByteArray.write(BoardImpl.getCrc(contentBuffer), 0, 8);
        return ByteBuffer.wrap(tmpByteArray.toByteArray());
    }
}

