/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardDelegateImpl;
import com.sap.jvm.inspector.board.BoardInternal;
import com.sap.jvm.inspector.board.BoardListListener;
import com.sap.jvm.inspector.board.BoardProvider;
import com.sap.jvm.inspector.board.BoardProviderLocal;
import com.sap.jvm.inspector.board.BoardProviderRemote;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BoardManager
implements Iterable<Board> {
    private final Map<Integer, Board> localBoards = new LinkedHashMap<Integer, Board>();
    private final BoardProvider boardProvider;
    private final Set<BoardListListener> listListeners = new LinkedHashSet<BoardListListener>();

    BoardManager(BoardProvider boardProvider) {
        if (boardProvider == null) {
            throw new NullPointerException();
        }
        this.boardProvider = boardProvider;
    }

    public static BoardManager createForLocal(boolean includeControlAreaSearch) {
        return new BoardManager(new BoardProviderLocal(includeControlAreaSearch));
    }

    public static BoardManager createForRemote(String hostname, int port, boolean includeControlAreaSearch) {
        try {
            return new BoardManager(new BoardProviderRemote(hostname, port, includeControlAreaSearch, null));
        }
        catch (Throwable e) {
            Trace.get(BoardManager.class).debug(() -> "Unable to create BoardManager: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws MonitorBoardFormatException {
        Board[] currentBoards = this.boardProvider.get();
        ArrayList<Board> deadBoards = new ArrayList<Board>();
        HashSet<Integer> currentPids = new HashSet<Integer>();
        Map<Integer, Board> map = this.localBoards;
        synchronized (map) {
            for (Board currentBoard : currentBoards) {
                Integer pidKey = currentBoard.getPid();
                currentPids.add(pidKey);
                Board localBoard = this.localBoards.get(pidKey);
                if (localBoard != null && localBoard.isBoardBased() == currentBoard.isBoardBased()) continue;
                if (localBoard != null) {
                    if (!localBoard.isAlive()) {
                        deadBoards.add(localBoard);
                    } else {
                        if (!localBoard.isBoardBased() && currentBoard.isBoardBased()) {
                            ((BoardDelegateImpl)localBoard).setDelegate((BoardInternal)currentBoard);
                            continue;
                        }
                        deadBoards.add(localBoard);
                    }
                }
                this.localBoards.put(pidKey, currentBoard);
                for (BoardListListener listener : this.listListeners) {
                    listener.boardAdded(currentBoard);
                }
            }
            for (Board localBoard : this.localBoards.values()) {
                Integer pidKey = localBoard.getPid();
                if (!currentPids.contains(pidKey)) {
                    deadBoards.add(localBoard);
                    continue;
                }
                if (!localBoard.isBoardBased() || localBoard.isAlive()) continue;
                deadBoards.add(localBoard);
            }
            for (Board board : deadBoards) {
                ((BoardInternal)board).processOfBoardIsGone();
                this.localBoards.remove(board.getPid());
                for (BoardListListener listener : this.listListeners) {
                    listener.boardRemoved(board);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoards() throws MonitorBoardFormatException {
        Map<Integer, Board> map = this.localBoards;
        synchronized (map) {
            for (Board board : this.localBoards.values()) {
                board.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<Integer, Board> map = this.localBoards;
        synchronized (map) {
            return this.localBoards.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Board board) {
        Map<Integer, Board> map = this.localBoards;
        synchronized (map) {
            return this.localBoards.values().contains(board);
        }
    }

    public boolean canUpdateBoards() {
        return this.boardProvider.canUpdateBoards();
    }

    public boolean canSearchBoards() {
        return this.boardProvider.canSearchBoards();
    }

    public synchronized void addListener(BoardListListener listener) {
        this.listListeners.add(listener);
    }

    public synchronized void removeListener(BoardListListener listener) {
        this.listListeners.remove(listener);
    }

    public Connectability getConnectability(Board toBeAttached) {
        if (this.contains(toBeAttached)) {
            return this.boardProvider.getConnectability(toBeAttached);
        }
        return Connectability.TYPE_UNKNOWN;
    }

    public boolean isLocal() {
        return this.boardProvider.isLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Board> iterator() {
        Map<Integer, Board> map = this.localBoards;
        synchronized (map) {
            return new ArrayList<Board>(this.localBoards.values()).iterator();
        }
    }
}

