/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.WithInspectorNativeLib;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardControlAreaBasedImpl;
import com.sap.jvm.inspector.board.BoardDelegateImpl;
import com.sap.jvm.inspector.board.BoardInternal;
import com.sap.jvm.inspector.board.BoardProvider;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.cluster.InstanceInfo;
import com.sap.jvm.inspector.cluster.ProfilingCluster;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class BoardProviderLocal
extends WithInspectorNativeLib
implements BoardProvider {
    private static final Tracer trc;
    private static final int CONTROL_AREA_MAX_IDLE_TIME = 120000;
    private static final boolean initLocalMonitorBoards;
    private static final boolean couldElevate;
    static final String NORMALIZED_LOCALHOST;
    private Map<Integer, BoardWrapper> oldBoards = new HashMap<Integer, BoardWrapper>();
    private final boolean includeControlAreas;

    public BoardProviderLocal(boolean includeControlAreas) {
        this.includeControlAreas = includeControlAreas && !turnOffControlAreaSearch;
    }

    @Override
    public Board[] get() {
        if (!initLocalMonitorBoards) {
            return new Board[0];
        }
        Object[] tmp = BoardProviderLocal.getListOfVisibleMonitorBoards();
        TreeMap<Integer, Board> listOfBoards = new TreeMap<Integer, Board>();
        for (int i = 0; i < tmp.length; ++i) {
            Board board = (Board)tmp[i];
            listOfBoards.put(board.getPid(), board);
        }
        if (this.includeControlAreas) {
            ClusterInfo[] clusterInfos;
            for (ClusterInfo clusterInfo : clusterInfos = ProfilingCluster.getClusterInfo()) {
                if (clusterInfo.getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                    int pid = ((ProcessClusterInfo)clusterInfo).getProcessId();
                    Vm vm = ProfilingCluster.getProcessVm(pid);
                    this.addVm(vm, pid, listOfBoards, -1);
                    continue;
                }
                if (clusterInfo.getType() == ClusterType.CLUSTER_TYPE_INSTANCE) {
                    InstanceInfo[] instanceVMs;
                    int instanceId = ((InstanceClusterInfo)clusterInfo).getInstanceId();
                    for (InstanceInfo instanceVm : instanceVMs = ProfilingCluster.getInstanceInfo(instanceId)) {
                        int pid = instanceVm.getPid();
                        int vmIndex = instanceVm.getVmIndex();
                        Vm vm = ProfilingCluster.getInstanceVm(vmIndex, instanceId);
                        this.addVm(vm, pid, listOfBoards, instanceId);
                    }
                    continue;
                }
                trc.warn("Unknown cluster type " + (Object)((Object)clusterInfo.getType()) + " encountered.");
            }
        }
        return listOfBoards.values().toArray(new Board[0]);
    }

    @Override
    public boolean canUpdateBoards() {
        return initLocalMonitorBoards;
    }

    @Override
    public boolean canSearchBoards() {
        return true;
    }

    @Override
    public Connectability getConnectability(Board toBeAttached) {
        return this.getConnectability(toBeAttached.getPid());
    }

    @Override
    public Connectability getConnectability(int pid) {
        ClusterInfo[] controlAreaBasedVms;
        Connectability ret = Connectability.TYPE_UNKNOWN;
        block4: for (ClusterInfo cluster : controlAreaBasedVms = ProfilingCluster.getClusterInfo()) {
            InstanceInfo[] instanceVMs;
            if (cluster.getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                if (pid != ((ProcessClusterInfo)cluster).getProcessId()) continue;
                ret = Connectability.TYPE_YES_VIA_CONTROL_AREA;
                break;
            }
            if (cluster.getType() != ClusterType.CLUSTER_TYPE_INSTANCE) continue;
            int instanceId = ((InstanceClusterInfo)cluster).getInstanceId();
            for (InstanceInfo instanceVm : instanceVMs = ProfilingCluster.getInstanceInfo(instanceId)) {
                if (pid != instanceVm.getPid()) continue;
                ret = Connectability.TYPE_YES_VIA_CONTROL_AREA;
                continue block4;
            }
        }
        switch (InspectorInfo.isFileSocketServerAttachable(InspectorInfo.getProfilingServerIdentifier(pid))) {
            case 0: {
                if (ret == Connectability.TYPE_YES_VIA_CONTROL_AREA) {
                    ret = Connectability.TYPE_YES_VIA_CONTROL_AREA_OR_DOMAIN_SOCKET;
                    break;
                }
                ret = Connectability.TYPE_YES_VIA_DOMAIN_SOCKET;
                break;
            }
            case -1: 
            case 1: {
                if (ret != Connectability.TYPE_UNKNOWN) break;
                ret = couldElevate ? Connectability.TYPE_NO_NOTELEVATED : Connectability.TYPE_NO;
                break;
            }
            default: {
                ret = Connectability.TYPE_UNKNOWN;
            }
        }
        return ret;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public Map<Integer, BoardWrapper> getAllBoards() {
        Board[] rawBoards = this.get();
        HashSet<BoardWrapper> boards = new HashSet<BoardWrapper>();
        for (Board rawBoard : rawBoards) {
            BoardWrapper board;
            ByteBuffer buffer = ((BoardInternal)rawBoard).getCurrentByteBuffer();
            if (buffer == null) {
                trc.debug(() -> "Board with pid " + rawBoard.getPid() + " had empty buffer");
                continue;
            }
            try {
                board = new BoardWrapper((byte[])buffer.array().clone());
            }
            catch (MonitorBoardFormatException e) {
                trc.debug(() -> "Board with pid " + rawBoard.getPid() + " was corrupt");
                continue;
            }
            boards.add(board);
        }
        HashMap<Integer, BoardWrapper> newBoards = new HashMap<Integer, BoardWrapper>();
        for (BoardWrapper newBoard : boards) {
            int pid = newBoard.getPid();
            BoardWrapper oldBoard = this.oldBoards.get(pid);
            int instanceId = newBoard.getInstanceNr();
            int vmIndex = newBoard.getClusterIndex();
            boolean isClusterInstance = vmIndex > -1;
            boolean updatedFromControlArea = false;
            if (oldBoard == null || oldBoard.isDifferentProcess(newBoard)) {
                if (isClusterInstance && BoardProviderLocal.addMissingFromControlArea(newBoard, instanceId, vmIndex)) {
                    updatedFromControlArea = true;
                    if (!BoardProviderLocal.udpateFromControlArea(newBoard, instanceId, vmIndex)) {
                        trc.debug(() -> "Board with instance ID " + instanceId + " and VM Index " + vmIndex + " could not be updated from control area");
                    }
                }
                if (!(isClusterInstance && updatedFromControlArea || !BoardProviderLocal.addMissingFromControlArea(newBoard, pid, -1))) {
                    updatedFromControlArea = true;
                    if (!BoardProviderLocal.udpateFromControlArea(newBoard, pid, -1)) {
                        trc.debug(() -> "Board with pid " + pid + " could not be updated from control area");
                    }
                }
            } else {
                if (isClusterInstance && BoardProviderLocal.udpateFromControlArea(newBoard, instanceId, vmIndex)) {
                    updatedFromControlArea = true;
                }
                if (!(isClusterInstance && updatedFromControlArea || !BoardProviderLocal.udpateFromControlArea(newBoard, pid, -1))) {
                    updatedFromControlArea = true;
                }
            }
            if (!updatedFromControlArea) {
                trc.debug(() -> "Board with pid " + pid + " (instance ID " + instanceId + ", VM index " + vmIndex + ") could not be enriched with control area information");
            }
            newBoards.put(pid, newBoard);
        }
        try {
            this.fillControlAreaBords(newBoards);
        }
        catch (IOException e) {
            trc.debug((Throwable)e, () -> "Caught IOException when reading Control Area based boards");
        }
        this.oldBoards = newBoards;
        return newBoards;
    }

    private void fillControlAreaBords(Map<Integer, BoardWrapper> newBoards) throws IOException {
        int i;
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(ProfilingCluster.getClusterInfoRaw()));
        int count = stream.readInt();
        ArrayList<Integer> pidsOrInstanceIds = new ArrayList<Integer>();
        ArrayList<Integer> vmIndices = new ArrayList<Integer>();
        for (i = 0; i < count; ++i) {
            stream.readBoolean();
            boolean isInstance = stream.readInt() == 2;
            int pidOrInstanceId = stream.readInt();
            if (isInstance) {
                int maxVms = ProfilingCluster.getMaxVms(pidOrInstanceId);
                for (int index = 0; index < maxVms; ++index) {
                    if (!ProfilingCluster.isValidVm(2, pidOrInstanceId, index)) continue;
                    pidsOrInstanceIds.add(pidOrInstanceId);
                    vmIndices.add(index);
                }
                continue;
            }
            pidsOrInstanceIds.add(pidOrInstanceId);
            vmIndices.add(-1);
        }
        for (i = 0; i < pidsOrInstanceIds.size(); ++i) {
            int pid;
            int pidOrInstanceId = (Integer)pidsOrInstanceIds.get(i);
            int vmIndex = (Integer)vmIndices.get(i);
            if (vmIndex >= 0) {
                byte[] info = ProfilingCluster.getVmStateInfo(2, pidOrInstanceId, vmIndex);
                if (info == null) continue;
                DataInputStream stateInfo = new DataInputStream(new ByteArrayInputStream(info));
                stateInfo.readInt();
                pid = stateInfo.readInt();
            } else {
                pid = pidOrInstanceId;
            }
            if (newBoards.containsKey(pid)) continue;
            BoardWrapper board = new BoardWrapper(pid, InspectorInfo.getCreationTimeOfProcess(pid) * 1000L);
            BoardProviderLocal.addMissingFromControlArea(board, pidOrInstanceId, vmIndex);
            if (!BoardProviderLocal.udpateFromControlArea(board, pidOrInstanceId, vmIndex)) {
                trc.debug(() -> "Pid " + pidOrInstanceId + ": Could not update data from control area");
                continue;
            }
            if (board.hasAttribute("WILL_HAVE_MONITORING_BAORD") || !board.hasAttributes()) continue;
            newBoards.put(pid, board);
        }
    }

    private void addVm(Vm vm, int pid, Map<Integer, Board> listOfBoards, int instanceId) {
        Integer pidKey = pid;
        if (pid < 0 || listOfBoards.containsKey(pidKey)) {
            return;
        }
        try {
            if (!vm.getStartInfo().isRunningWithAMonitoringBoard()) {
                listOfBoards.put(pidKey, new BoardDelegateImpl(new BoardControlAreaBasedImpl(vm, NORMALIZED_LOCALHOST, pid, instanceId)));
            }
        }
        catch (InvalidVmException ex) {
            trc.debug(ex);
        }
    }

    private static boolean addMissingFromControlArea(BoardWrapper board, int pidOrInstanceId, int rawVmIndex) {
        try {
            int clusterType = rawVmIndex == -1 ? 1 : 2;
            int vmIndex = Math.max(0, rawVmIndex);
            byte[] stateData = ProfilingCluster.getVmStateInfo(clusterType, pidOrInstanceId, vmIndex);
            if (stateData == null) {
                trc.debug(() -> "addMissingFromControlArea for pid/instance " + pidOrInstanceId + ": Could not get state data");
                return false;
            }
            byte[] startData = ProfilingCluster.getVmStartInfo(clusterType, pidOrInstanceId, vmIndex);
            if (startData == null) {
                trc.debug(() -> "addMissingFromControlArea for pid/instance " + pidOrInstanceId + ": Could not get start data");
                return false;
            }
            DataInputStream stateInfo = new DataInputStream(new ByteArrayInputStream(stateData));
            vmIndex = stateInfo.readInt();
            int pid = stateInfo.readInt();
            DataInputStream startInfo = new DataInputStream(new ByteArrayInputStream(startData));
            String vmVersion = startInfo.readUTF();
            String workingDir = startInfo.readUTF();
            String tmpVmFlags = startInfo.readUTF();
            String tmpVmArgs = startInfo.readUTF();
            String javaArgs = startInfo.readUTF();
            String vmTag = startInfo.readUTF();
            String splitArgs = startInfo.readUTF();
            String jarMainClass = startInfo.readUTF();
            boolean withBoard = startInfo.readBoolean();
            ArrayList<String> ar = new ArrayList<String>();
            if (tmpVmFlags != null) {
                StringTokenizer st = new StringTokenizer(tmpVmFlags, "\u0001");
                while (st.hasMoreTokens()) {
                    ar.add(st.nextToken());
                }
            }
            String[] vmFlags = ar.toArray(new String[ar.size()]);
            ar.clear();
            if (tmpVmArgs != null) {
                StringTokenizer st = new StringTokenizer(tmpVmArgs, "\u0001");
                while (st.hasMoreTokens()) {
                    ar.add(st.nextToken());
                }
            }
            String[] vmArgs = ar.toArray(new String[ar.size()]);
            String toSplit = splitArgs;
            String splitChar = "\u0001";
            if (splitArgs.length() == 0) {
                toSplit = javaArgs;
                splitChar = " ";
            }
            String mainClass = null;
            String[] javaArgsArray = new String[]{};
            String jarFilename = null;
            if (toSplit.length() > 0) {
                StringTokenizer st = new StringTokenizer(toSplit, splitChar);
                ar.clear();
                while (st.hasMoreTokens()) {
                    ar.add(st.nextToken());
                }
                if (jarMainClass.length() > 0) {
                    mainClass = jarMainClass;
                    jarFilename = (String)ar.get(0);
                } else {
                    mainClass = (String)ar.get(0);
                }
                javaArgsArray = new String[ar.size() - 1];
                for (int i = 1; i < ar.size(); ++i) {
                    javaArgsArray[i - 1] = (String)ar.get(i);
                }
            }
            board.addMissing(board.getStartTime(), pid, withBoard, rawVmIndex >= 0 ? pidOrInstanceId : -1, rawVmIndex, vmVersion, workingDir, vmFlags, vmArgs, javaArgsArray, mainClass, vmTag, javaArgs, jarFilename);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean udpateFromControlArea(BoardWrapper board, int pidOrInstanceId, int rawVmIndex) {
        try {
            int clusterType = rawVmIndex == -1 ? 1 : 2;
            int vmIndex = Math.max(0, rawVmIndex);
            long startupTime = board.getStartTime();
            byte[] debugData = ProfilingCluster.getVmDebugInfo(clusterType, pidOrInstanceId, vmIndex);
            if (debugData == null) {
                trc.debug(() -> "udpateFromControlArea for pid " + pidOrInstanceId + ": Could not get debug data");
                return false;
            }
            byte[] timeData = ProfilingCluster.getVmTimeInfo(clusterType, pidOrInstanceId, vmIndex);
            if (timeData == null) {
                trc.debug(() -> "udpateFromControlArea for pid " + pidOrInstanceId + ": Could not get time data");
                return false;
            }
            byte[] memData = ProfilingCluster.getVmMemoryInfo(clusterType, pidOrInstanceId, vmIndex);
            if (memData == null) {
                trc.debug(() -> "udpateFromControlArea for pid " + pidOrInstanceId + ": Could not get memory data");
                return false;
            }
            DataInputStream debugInfo = new DataInputStream(new ByteArrayInputStream(debugData));
            boolean onDemand = debugInfo.readBoolean();
            int fromPort = debugInfo.readInt();
            int toPort = debugInfo.readInt();
            int debugState = debugInfo.readInt();
            int debugPort = debugInfo.readInt();
            String client = debugInfo.readUTF();
            boolean isLocal = debugInfo.available() > 0 ? debugInfo.readBoolean() : false;
            debugInfo.close();
            DataInputStream timeInfo = new DataInputStream(new ByteArrayInputStream(timeData));
            timeInfo.readLong();
            long systemTime = timeInfo.readLong();
            long userTime = timeInfo.readLong();
            long elapsedTime = timeInfo.readLong();
            timeInfo.close();
            if (!ignoreUptimeTimeOfBoard && startupTime + elapsedTime / 1000L < System.currentTimeMillis() - 120000L) {
                trc.debug(() -> "udpateFromControlArea for pid " + pidOrInstanceId + ": uptime check failed");
                return false;
            }
            DataInputStream memoryInfo = new DataInputStream(new ByteArrayInputStream(memData));
            memoryInfo.skip(48L);
            long committedHeap = memoryInfo.readLong();
            long committedPerm = memoryInfo.readLong();
            long committedCodeCache = memoryInfo.readLong();
            memoryInfo.skip(128L);
            long nrOfGcs = memoryInfo.readLong();
            long nrOfFullGcs = memoryInfo.readLong();
            memoryInfo.close();
            if (board.isSynthetic("DEBUGGING_PORT")) {
                board.setInt("DEBUGGING_PORT", debugPort);
            }
            if (board.isSynthetic("DEBUGGING_DEFAULT_PORT_FROM")) {
                board.setInt("DEBUGGING_DEFAULT_PORT_FROM", fromPort);
            }
            if (board.isSynthetic("DEBUGGING_DEFAULT_PORT_TO")) {
                board.setInt("DEBUGGING_DEFAULT_PORT_TO", toPort);
            }
            if (board.isSynthetic("DEBUGGING_CLIENT")) {
                board.setString("DEBUGGING_CLIENT", client);
            }
            if (board.isSynthetic("DEBUGGING_MODE")) {
                board.setShort("DEBUGGING_MODE", debugState >= 2 ? (short)1 : 0);
            }
            if (board.isSynthetic("DEBUGGING_STATE")) {
                board.setInt("DEBUGGING_STATE", debugState);
            }
            if (board.isSynthetic("SYS_CPU_TIME")) {
                board.setLong("SYS_CPU_TIME", systemTime);
            }
            if (board.isSynthetic("USER_CPU_TIME")) {
                board.setLong("USER_CPU_TIME", userTime);
            }
            if (board.isSynthetic("ELAPSED_TIME")) {
                board.setLong("ELAPSED_TIME", elapsedTime);
            }
            if (board.isSynthetic("HEAP_COMMITTED_AFTER_GC")) {
                board.setLong("HEAP_COMMITTED_AFTER_GC", committedHeap);
            }
            if (board.isSynthetic("PERM_COMMITTED_AFTER_GC")) {
                board.setLong("PERM_COMMITTED_AFTER_GC", committedPerm);
            }
            if (board.isSynthetic("CC_COMMITTED")) {
                board.setLong("CC_COMMITTED", committedCodeCache);
            }
            if (board.isSynthetic("DEBUGGING_ON_DEMAND_ENABLED")) {
                board.setBoolean("DEBUGGING_ON_DEMAND_ENABLED", onDemand);
            }
            if (board.isSynthetic("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL")) {
                board.setBoolean("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL", isLocal);
            }
            if (board.isSynthetic("NUM_GCS")) {
                board.setLong("NUM_GCS", nrOfGcs);
            }
            if (board.isSynthetic("NUM_FULL_GCS")) {
                board.setLong("NUM_FULL_GCS", nrOfFullGcs);
            }
            return true;
        }
        catch (IOException e) {
            trc.debug((Throwable)e, () -> "udpateFromControlArea for pid " + pidOrInstanceId + ": Caught exception");
            return false;
        }
    }

    private static synchronized native void initLocalMonitorBoards(Class<?> var0);

    private static synchronized native Object[] getListOfVisibleMonitorBoards();

    static {
        String host;
        trc = Trace.get(BoardProvider.class);
        try {
            host = InetAddress.getLocalHost().getHostName();
            int ndxfdt = host.indexOf(46);
            if (ndxfdt != -1) {
                host = host.substring(0, ndxfdt);
            }
        }
        catch (UnknownHostException ex) {
            trc.warn("Unable to get the hostname: " + ex.getMessage());
            host = "NOT_AVAILABLE";
        }
        NORMALIZED_LOCALHOST = host;
        boolean success = false;
        try {
            BoardProviderLocal.initLocalMonitorBoards(BoardDelegateImpl.class);
            success = true;
        }
        catch (SecurityException ex) {
            trc.error((Throwable)ex, () -> "Unable to init BoardProvider natives: " + ex.getMessage());
        }
        initLocalMonitorBoards = success;
        success = false;
        try {
            success = InspectorInfo.couldElevate();
        }
        catch (SecurityException ex) {
            trc.error((Throwable)ex, () -> "Unable to check whether we can elevate: " + ex.getMessage());
        }
        couldElevate = success;
    }
}

