/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.impl.monitor.transport.JvmmondSocketTools;
import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeImpl;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardContentProvider;
import com.sap.jvm.inspector.board.BoardControlAreaBasedCommonImpl;
import com.sap.jvm.inspector.board.BoardControlAreaBasedImpl;
import com.sap.jvm.inspector.board.BoardControlAreaBasedOnByteBufferImpl;
import com.sap.jvm.inspector.board.BoardDelegateImpl;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardProvider;
import com.sap.jvm.inspector.board.BoardWithProviderExImpl;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfo;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfoEx;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardProvider;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardProviderEx;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.inspector.jvmmon.RMIConnectException;
import com.sap.jvm.internals.RemoteInternalsProvider;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.remoteCluster.RemoteCluster;
import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.misc.ByteConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BoardProviderRemote
implements BoardProvider,
BoardContentProvider {
    private static final Tracer trc = Trace.get(BoardProvider.class);
    private static boolean requireRMICluster = true;
    private final String host;
    private final int port;
    private RemoteBoardProvider remoteBoardProvider = null;
    private boolean gotExtendedBoardProvider = false;
    private RemoteCluster remoteCluster = null;
    private RemoteInternalsProvider remoteInternals = null;
    private boolean includeControlAreas = true;
    private boolean canSearchBoards = false;
    private volatile boolean canUpdateBoards = false;
    private Map<Integer, BoardWrapper> oldBoards = new HashMap<Integer, BoardWrapper>();
    private Map<Integer, ByteBuffer> boardBuffers = new TreeMap<Integer, ByteBuffer>();
    private Map<Integer, Board> remoteBoards = new TreeMap<Integer, Board>();
    private Map<Integer, Board> remoteControlAreaBoards = new TreeMap<Integer, Board>();

    public BoardProviderRemote(String host, int port, boolean includeControlAreas, PasswordSupplier passwordSupplier) throws IOException {
        this.host = host;
        this.port = port;
        this.includeControlAreas = includeControlAreas && !turnOffControlAreaSearch;
        NotBoundException ex = null;
        Registry registry = LocateRegistry.getRegistry(host, port);
        try {
            this.remoteBoardProvider = (RemoteBoardProvider)registry.lookup("RemoteBoardProviderEx");
            this.gotExtendedBoardProvider = true;
        }
        catch (NotBoundException e) {
            ex = e;
            trc.warn((Throwable)e, "Extended RemoteBoardProvider is not bound to RMI server.");
        }
        if (!this.gotExtendedBoardProvider) {
            try {
                this.remoteBoardProvider = (RemoteBoardProvider)registry.lookup("RemoteBoardProvider");
            }
            catch (NotBoundException e) {
                ex = e;
                trc.warn((Throwable)e, "RemoteBoardProvider is not bound to RMI server.");
            }
        }
        if (this.remoteBoardProvider == null || requireRMICluster) {
            try {
                this.remoteCluster = (RemoteCluster)registry.lookup("RemoteCluster");
            }
            catch (NotBoundException e) {
                ex = e;
                trc.warn((Throwable)e, "RemoteCluster is not bound to RMI server.");
            }
        }
        if (this.remoteCluster == null) {
            if (this.remoteBoardProvider == null) {
                throw new RMIConnectException("Could not connect to RMI Services on remote server " + host + ":" + port + ".", ex);
            }
            if (requireRMICluster) {
                throw new RMIConnectException("Remote cluster service not available on server " + host + ":" + port + ".", ex);
            }
        }
        try {
            this.remoteInternals = (RemoteInternalsProvider)registry.lookup("RemoteInternalsProvider");
        }
        catch (NotBoundException e) {
            trc.warn((Throwable)e, "RemoteInternalsProvider does not exist in jvmmond. Maybe its version is too old.");
        }
        this.doPasswordAuthentication(this.remoteBoardProvider != null, passwordSupplier);
        if (this.remoteBoardProvider != null) {
            this.canSearchBoards = true;
        } else {
            this.canUpdateBoards = true;
        }
    }

    @Override
    public synchronized Board[] get() {
        Board[] result = null;
        if (this.remoteBoardProvider != null) {
            result = this.getFromBoardProvider();
        } else if (this.remoteCluster != null) {
            result = this.getFromClusterProvider();
        } else assert (false);
        return result != null ? result : new Board[]{};
    }

    @Override
    public boolean canUpdateBoards() {
        return this.canUpdateBoards;
    }

    @Override
    public boolean canSearchBoards() {
        return this.canSearchBoards;
    }

    @Override
    public Connectability getConnectability(Board toBeAttached) {
        BoardDelegateImpl boardAsDelegate = (BoardDelegateImpl)toBeAttached;
        Connectability ret = Connectability.TYPE_UNKNOWN;
        if (boardAsDelegate != null) {
            if (boardAsDelegate.getDelegate() instanceof BoardWithProviderExImpl) {
                ret = ((BoardWithProviderExImpl)boardAsDelegate.getDelegate()).getAttachStatus();
            } else if (boardAsDelegate.getDelegate() instanceof BoardDelegateImpl) {
                ret = ((BoardWithProviderExImpl)((BoardDelegateImpl)boardAsDelegate.getDelegate()).getDelegate()).getAttachStatus();
            }
        }
        return ret;
    }

    @Override
    public Connectability getConnectability(int pid) {
        Board[] boards;
        for (Board board : boards = this.get()) {
            if (board.getPid() != pid) continue;
            return this.getConnectability(board);
        }
        return Connectability.TYPE_UNKNOWN;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public Map<Integer, BoardWrapper> getAllBoards() {
        HashMap<Integer, BoardWrapper> result = new HashMap<Integer, BoardWrapper>();
        for (Board board : this.get()) {
            BoardWrapper newBoard;
            int pid;
            block29: {
                pid = board.getPid();
                byte[] rawBoard = (byte[])((BoardDelegateImpl)board).getCurrentByteBuffer().array().clone();
                if (ByteConverter.readInt32(rawBoard, 0) == BoardControlAreaBasedCommonImpl.magicNumberOfFullContent) {
                    try {
                        newBoard = new BoardWrapper(board.getPid(), 0L);
                        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
                        Iterator<Attribute> it = board.getAttributeIterator();
                        while (it.hasNext()) {
                            Attribute attr = it.next();
                            attributes.put(attr.getName(), attr);
                        }
                        Attribute systemNrAttr = (Attribute)attributes.get("SAP_SYSTEM");
                        int systemNr = systemNrAttr == null ? -1 : systemNrAttr.getIntValue();
                        int vmIndex = -1;
                        Attribute vmVersionAttr = (Attribute)attributes.get("VM_VERSION_STRING");
                        String vmVersion = vmVersionAttr == null ? "" : vmVersionAttr.getValue().getAsString();
                        Attribute workingDirAttr = (Attribute)attributes.get("WORKINGDIR");
                        String workingDir = workingDirAttr == null ? "" : workingDirAttr.getValue().getAsString();
                        String[] vmFlags = new String[]{};
                        ArrayList<String> vmArgsList = new ArrayList<String>();
                        int index = 0;
                        while (attributes.containsKey("JVM_ARGUMENT" + index)) {
                            vmArgsList.add(((Attribute)attributes.get("JVM_ARGUMENT" + index)).getValue().getAsString());
                            ++index;
                        }
                        String[] vmArgs = vmArgsList.toArray(new String[vmArgsList.size()]);
                        ArrayList<String> javaArgsList = new ArrayList<String>();
                        index = 0;
                        while (attributes.containsKey("JAVA_ARGUMENT" + index)) {
                            javaArgsList.add(((Attribute)attributes.get("JAVA_ARGUMENT" + index)).getValue().getAsString());
                            ++index;
                        }
                        String[] javaArgsArray = javaArgsList.toArray(new String[javaArgsList.size()]);
                        Attribute mainClassAttr = (Attribute)attributes.get("JAVA_MAINCLASS");
                        String mainClass = mainClassAttr == null ? "" : mainClassAttr.getValue().getAsString();
                        Attribute vmTagAttr = (Attribute)attributes.get("JVM_TAG");
                        String vmTag = vmTagAttr == null ? "" : vmTagAttr.getValue().getAsString();
                        Attribute javaArgsAttr = (Attribute)attributes.get("JAVA_ARGUMENTS");
                        String javaArgs = javaArgsAttr == null ? "" : javaArgsAttr.getValue().getAsString();
                        newBoard.addMissing(0L, board.getPid(), false, systemNr, vmIndex, vmVersion, workingDir, vmFlags, vmArgs, javaArgsArray, mainClass, vmTag, javaArgs, null);
                        Vm vm = this.getVmForBoard(newBoard);
                        if (vm != null) {
                            try {
                                VmDebugInfo debugInfo = vm.getDebugInfo();
                                PortRange portRange = debugInfo.getDefaultDebugPortRange();
                                VmTimeInfo timeInfo = vm.getTimeInfo();
                                VmMemoryInfo memInfo = vm.getMemoryInfo();
                                String jarFilename = vm.getStartInfo().getJarFilename();
                                if (jarFilename != null) {
                                    newBoard.addIfMissing("JAR_FILE_NAME", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, jarFilename);
                                }
                                if (newBoard.isSynthetic("DEBUGGING_PORT")) {
                                    newBoard.setInt("DEBUGGING_PORT", debugInfo.getDebugPort());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_DEFAULT_PORT_FROM")) {
                                    newBoard.setInt("DEBUGGING_DEFAULT_PORT_FROM", portRange.getFromPort());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_DEFAULT_PORT_TO")) {
                                    newBoard.setInt("DEBUGGING_DEFAULT_PORT_TO", portRange.getToPort());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_CLIENT")) {
                                    newBoard.setString("DEBUGGING_CLIENT", debugInfo.getDebugClient());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_MODE")) {
                                    newBoard.setShort("DEBUGGING_MODE", debugInfo.getDebugState().ordinal() >= 2 ? (short)1 : 0);
                                }
                                if (newBoard.isSynthetic("DEBUGGING_STATE")) {
                                    newBoard.setInt("DEBUGGING_STATE", debugInfo.getDebugState().ordinal());
                                }
                                if (newBoard.isSynthetic("SYS_CPU_TIME")) {
                                    newBoard.setLong("SYS_CPU_TIME", timeInfo.getSystemTime());
                                }
                                if (newBoard.isSynthetic("USER_CPU_TIME")) {
                                    newBoard.setLong("USER_CPU_TIME", timeInfo.getUserTime());
                                }
                                if (newBoard.isSynthetic("ELAPSED_TIME")) {
                                    newBoard.setLong("ELAPSED_TIME", timeInfo.getProcessingTime());
                                }
                                if (newBoard.isSynthetic("HEAP_COMMITTED_AFTER_GC")) {
                                    newBoard.setLong("HEAP_COMMITTED_AFTER_GC", memInfo.getJavaHeapMemoryConsumption());
                                }
                                if (newBoard.isSynthetic("PERM_COMMITTED_AFTER_GC")) {
                                    newBoard.setLong("PERM_COMMITTED_AFTER_GC", memInfo.getPermGenMemoryConsumptionAfterGc());
                                }
                                if (newBoard.isSynthetic("CC_COMMITTED")) {
                                    newBoard.setLong("CC_COMMITTED", memInfo.getCodeMemoryAllocation());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_ON_DEMAND_ENABLED")) {
                                    newBoard.setBoolean("DEBUGGING_ON_DEMAND_ENABLED", debugInfo.isDebugOnDemandSupported());
                                }
                                if (newBoard.isSynthetic("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL")) {
                                    newBoard.setBoolean("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL", debugInfo.isLocalOnly());
                                }
                                if (newBoard.isSynthetic("NUM_GCS")) {
                                    newBoard.setLong("NUM_GCS", memInfo.getGcNr());
                                }
                                if (newBoard.isSynthetic("NUM_FULL_GCS")) {
                                    newBoard.setLong("NUM_FULL_GCS", memInfo.getFullGcNr());
                                }
                            }
                            catch (InvalidVmException invalidVmException) {
                                // empty catch block
                            }
                        }
                        result.put(pid, newBoard);
                    }
                    catch (MonitorBoardFormatException newBoard2) {}
                    continue;
                }
                try {
                    newBoard = new BoardWrapper(rawBoard);
                    BoardWrapper oldBoard = this.oldBoards.get(pid);
                    if (oldBoard == null || oldBoard.isDifferentProcess(newBoard)) break block29;
                    newBoard = new BoardWrapper(oldBoard, newBoard);
                }
                catch (MonitorBoardFormatException e) {
                    continue;
                }
            }
            result.put(pid, newBoard);
        }
        this.oldBoards = result;
        return result;
    }

    @Override
    public synchronized ByteBuffer getContent(int pid) {
        return this.boardBuffers.get(pid);
    }

    @Override
    public boolean deliversOnlineData() {
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.canUpdateBoards();
    }

    public Vm getVmForBoard(BoardWrapper board) {
        try {
            RemoteVm remoteVm = this.remoteCluster.getVm(board.getPid());
            return this.remoteCluster.getVm(remoteVm);
        }
        catch (RemoteException e) {
            trc.warn((Throwable)e, () -> "Could not get remote VM for board" + board);
            return null;
        }
    }

    public ClusterInfo[] getClusterInfo() throws RemoteException {
        return this.remoteCluster == null ? null : this.remoteCluster.getClusterInfo();
    }

    public RemoteVm getVmOld(int processId) throws RemoteException {
        return this.remoteCluster == null ? null : this.remoteCluster.getVm(processId);
    }

    public Vm getVmOld(RemoteVm vm) throws RemoteException {
        return this.remoteCluster == null ? null : this.remoteCluster.getVm(vm);
    }

    public VmInternals getVmInternalsByProcessId(int processId) throws RemoteException {
        return this.remoteInternals == null ? null : this.remoteInternals.getVmInternalsByProcessId(processId);
    }

    public static ByteBuffer updateBoardWithDynamicBoardValues(ByteBuffer oldBuffer, Board knownBoard, RemoteBoardInfo remoteInfo, boolean gotExtendedBoardProvider) {
        int copyPos = 0;
        int headerSize = BoardImpl.getHeaderSize(oldBuffer);
        oldBuffer.position(0);
        for (int i = 0; i < headerSize; ++i) {
            byte headerValue = remoteInfo.boardContentBuffer[copyPos++];
            oldBuffer.put(headerValue);
        }
        Iterator<Attribute> attrs = knownBoard.getAttributeIterator();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            if (attr.getVariabilityType() != AttributeVariabilityType.TYPE_DYNAMIC) continue;
            AttributeImpl attrImpl = (AttributeImpl)attr;
            int pos = attrImpl.getRawValuePosition();
            int size = attrImpl.getRawValueSize();
            if (gotExtendedBoardProvider && attrImpl.getDataType() == AttributeDataType.TYPE_CHAR) {
                size = ByteBuffer.wrap(remoteInfo.boardContentBuffer).getInt(copyPos);
                copyPos += 4;
                oldBuffer.putInt(attrImpl.getArraySizePositionWithinBuffer(), size);
            }
            oldBuffer.position(pos);
            for (int i = 0; i < size; ++i) {
                byte value = remoteInfo.boardContentBuffer[copyPos++];
                oldBuffer.put(value);
            }
        }
        byte[] currentCrc = null;
        if (remoteInfo.boardContentBuffer.length > copyPos) {
            currentCrc = new byte[8];
            int pos = 0;
            while (copyPos < remoteInfo.boardContentBuffer.length) {
                currentCrc[pos++] = remoteInfo.boardContentBuffer[copyPos++];
            }
            BoardImpl.setCrc(oldBuffer, currentCrc);
        }
        return oldBuffer;
    }

    private void doPasswordAuthentication(boolean useRemoteBoardProvider, PasswordSupplier passwordSupplier) throws IOException {
        ConnectIOException cioe = null;
        try {
            if (useRemoteBoardProvider) {
                this.canUpdateBoards = this.remoteBoardProvider.canUpdateBoards();
            } else {
                this.remoteCluster.getClusterInfo();
            }
        }
        catch (ConnectIOException e) {
            cioe = e;
        }
        if (cioe == null) {
            return;
        }
        if (passwordSupplier == null) {
            throw new RMIConnectException("Jvmmond server probably needs a password but no password supplier available.", cioe);
        }
        String passwordToken = passwordSupplier.get();
        String convertedToken = null;
        try {
            convertedToken = JvmmondSocketTools.getPasswordFromHexRepresentation(passwordToken);
        }
        catch (IllegalArgumentException iae) {
            trc.debug("Password token could not be interpreted as hex string.");
        }
        JvmmondSocketTools.registerPassword(convertedToken == null ? passwordToken : convertedToken, this.host, this.port);
        cioe = null;
        try {
            if (useRemoteBoardProvider) {
                this.canUpdateBoards = this.remoteBoardProvider.canUpdateBoards();
            } else {
                this.remoteCluster.getClusterInfo();
            }
        }
        catch (ConnectIOException e) {
            cioe = e;
        }
        if (cioe == null) {
            return;
        }
        if (convertedToken == null) {
            throw new RMIConnectException("Could not authenticate with server.", cioe);
        }
        JvmmondSocketTools.registerPassword(passwordToken, this.host, this.port);
        cioe = null;
        try {
            if (useRemoteBoardProvider) {
                this.canUpdateBoards = this.remoteBoardProvider.canUpdateBoards();
            } else {
                this.remoteCluster.getClusterInfo();
            }
        }
        catch (ConnectIOException e) {
            throw new RMIConnectException("Could not authenticate with server.", cioe);
        }
    }

    private Board[] getFromBoardProvider() {
        int numBoards;
        if (this.remoteBoardProvider == null) {
            return null;
        }
        this.gotExtendedBoardProvider = false;
        if (this.remoteBoardProvider instanceof RemoteBoardProviderEx) {
            this.gotExtendedBoardProvider = true;
        }
        RemoteBoardInfo[] curRemoteInfo = null;
        try {
            RemoteBoardInfoEx remoteInfo;
            RemoteBoardInfo[] knownInfo = new RemoteBoardInfoEx[this.remoteBoards.size() + this.remoteControlAreaBoards.size()];
            int j = 0;
            for (Board knownBoard : this.remoteBoards.values()) {
                remoteInfo = null;
                remoteInfo = new RemoteBoardInfoEx();
                remoteInfo.pid = knownBoard.getPid();
                remoteInfo.startingTimestamp = knownBoard.getStartingTimeStamp();
                remoteInfo.boardContentBuffer = null;
                remoteInfo.isBoardBased = knownBoard.isBoardBased();
                knownInfo[j] = remoteInfo;
                ++j;
            }
            for (Board knownBoard : this.remoteControlAreaBoards.values()) {
                remoteInfo = null;
                remoteInfo = new RemoteBoardInfoEx();
                remoteInfo.pid = knownBoard.getPid();
                remoteInfo.startingTimestamp = knownBoard.getStartingTimeStamp();
                remoteInfo.boardContentBuffer = null;
                remoteInfo.isBoardBased = knownBoard.isBoardBased();
                knownInfo[j] = remoteInfo;
                ++j;
            }
            if (this.gotExtendedBoardProvider) {
                curRemoteInfo = ((RemoteBoardProviderEx)this.remoteBoardProvider).getRemoteBoardInfoEx(knownInfo);
            } else {
                RemoteBoardInfo[] controlAreaBased = new RemoteBoardInfo[this.remoteControlAreaBoards.size()];
                int pos = 0;
                for (int i = 0; i < knownInfo.length; ++i) {
                    if (((RemoteBoardInfoEx)knownInfo[i]).isBoardBased) continue;
                    controlAreaBased[pos] = new RemoteBoardInfo();
                    controlAreaBased[pos].boardContentBuffer = ((RemoteBoardInfoEx)knownInfo[i]).boardContentBuffer;
                    controlAreaBased[pos].fullContent = ((RemoteBoardInfoEx)knownInfo[i]).fullContent;
                    controlAreaBased[pos].isBoardBased = ((RemoteBoardInfoEx)knownInfo[i]).isBoardBased;
                    controlAreaBased[pos].pid = ((RemoteBoardInfoEx)knownInfo[i]).pid;
                    controlAreaBased[pos].startingTimestamp = ((RemoteBoardInfoEx)knownInfo[i]).startingTimestamp;
                }
                curRemoteInfo = this.remoteBoardProvider.getRemoteBoardInfo(controlAreaBased);
            }
        }
        catch (RemoteException e) {
            this.connectionLost();
            return null;
        }
        Map<Integer, ByteBuffer> oldBoardBuffers = this.boardBuffers;
        this.boardBuffers = new TreeMap<Integer, ByteBuffer>();
        if (curRemoteInfo != null) {
            for (RemoteBoardInfo remoteInfo : curRemoteInfo) {
                if (remoteInfo == null || !remoteInfo.isBoardBased) continue;
                if (remoteInfo.fullContent) {
                    ByteBuffer contentBuffer = ByteBuffer.wrap(remoteInfo.boardContentBuffer);
                    this.boardBuffers.put(remoteInfo.pid, contentBuffer);
                    Board boardToRemove = this.remoteBoards.get(remoteInfo.pid);
                    if (boardToRemove != null) {
                        if (boardToRemove.getStartingTimeStamp() == remoteInfo.startingTimestamp.longValue()) {
                            ((BoardImpl)((BoardDelegateImpl)boardToRemove).getDelegate()).update(contentBuffer, remoteInfo.pid);
                        } else {
                            ((BoardImpl)boardToRemove).processOfBoardIsGone();
                            this.remoteBoards.remove(remoteInfo.pid);
                            try {
                                this.remoteBoards.put(remoteInfo.pid, new BoardDelegateImpl(new BoardWithProviderExImpl((BoardContentProvider)this, remoteInfo)));
                            }
                            catch (MonitorBoardFormatException ex) {
                                trc.warn("Catch MonitorBoardFormatException during remoteBoards.put(remoteInfo.pid, new BoardDelegateImpl(new BoardWithProviderExImpl(this, remoteInfo )));");
                            }
                        }
                    } else {
                        try {
                            this.remoteBoards.put(remoteInfo.pid, new BoardDelegateImpl(new BoardWithProviderExImpl((BoardContentProvider)this, remoteInfo)));
                        }
                        catch (MonitorBoardFormatException ex) {
                            trc.warn("Catch MonitorBoardFormatException during remoteBoards.put(remoteInfo.pid, new BoardDelegateImpl(new BoardWithProviderExImpl(this, remoteInfo )));");
                        }
                    }
                    oldBoardBuffers.put(remoteInfo.pid, null);
                    continue;
                }
                ByteBuffer oldBuffer = oldBoardBuffers.get(remoteInfo.pid);
                Board knownBoard = this.remoteBoards.get(remoteInfo.pid);
                if (oldBuffer != null && knownBoard != null) {
                    oldBuffer = BoardProviderRemote.updateBoardWithDynamicBoardValues(oldBuffer, knownBoard, remoteInfo, this.gotExtendedBoardProvider);
                    this.boardBuffers.put(remoteInfo.pid, oldBuffer);
                    oldBoardBuffers.put(remoteInfo.pid, null);
                    continue;
                }
                assert (false);
            }
        }
        for (Integer removeKey : oldBoardBuffers.keySet()) {
            if (oldBoardBuffers.get(removeKey) == null) continue;
            Board boardToRemove = this.remoteBoards.get(removeKey);
            if (boardToRemove.isBoardBased()) {
                ((BoardDelegateImpl)boardToRemove).processOfBoardIsGone();
            }
            this.remoteBoards.remove(removeKey);
        }
        oldBoardBuffers.clear();
        oldBoardBuffers = null;
        if (this.includeControlAreas && curRemoteInfo != null) {
            Map<Integer, Board> oldControlAreaBoards = this.remoteControlAreaBoards;
            this.remoteControlAreaBoards = new TreeMap<Integer, Board>();
            for (RemoteBoardInfo remoteInfo : curRemoteInfo) {
                if (remoteInfo == null || remoteInfo.isBoardBased) continue;
                try {
                    int pid = remoteInfo.pid;
                    Integer vmKey = pid;
                    if (this.remoteBoards.containsKey(vmKey)) continue;
                    Board vmBoard = oldControlAreaBoards.get(vmKey);
                    if (vmBoard == null) {
                        vmBoard = new BoardDelegateImpl(new BoardControlAreaBasedOnByteBufferImpl(remoteInfo));
                    } else if (remoteInfo.fullContent) {
                        ((BoardControlAreaBasedOnByteBufferImpl)((BoardDelegateImpl)vmBoard).getDelegate()).init(remoteInfo);
                    } else {
                        ((BoardControlAreaBasedOnByteBufferImpl)((BoardDelegateImpl)vmBoard).getDelegate()).update(remoteInfo.boardContentBuffer, this.gotExtendedBoardProvider);
                    }
                    this.remoteControlAreaBoards.put(vmKey, vmBoard);
                    oldControlAreaBoards.put(vmKey, null);
                }
                catch (MonitorBoardFormatException monitorBoardFormatException) {
                    // empty catch block
                }
            }
            oldControlAreaBoards.clear();
            oldControlAreaBoards = null;
        }
        if ((numBoards = this.remoteBoards.values().size() + this.remoteControlAreaBoards.values().size()) > 0) {
            Board[] mergedRemoteBoards = new Board[numBoards];
            int pos = 0;
            for (Board board : this.remoteBoards.values()) {
                mergedRemoteBoards[pos++] = board;
            }
            for (Board board : this.remoteControlAreaBoards.values()) {
                mergedRemoteBoards[pos++] = board;
            }
            return mergedRemoteBoards;
        }
        return null;
    }

    private List<ClusterVm> getRemoteVms() {
        LinkedList<ClusterVm> result = new LinkedList<ClusterVm>();
        try {
            ClusterInfo[] info;
            for (ClusterInfo current : info = this.remoteCluster.getClusterInfo()) {
                Vm[] vms;
                if (current.isAttachable() && current.getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                    ProcessClusterInfo processInfo = (ProcessClusterInfo)current;
                    RemoteVm remoteVm = this.remoteCluster.getVm(processInfo.getProcessId());
                    Vm vm = this.remoteCluster.getVm(remoteVm);
                    if (vm == null) continue;
                    result.add(new ClusterVm(-1, vm));
                    continue;
                }
                if (!current.isAttachable() || current.getType() != ClusterType.CLUSTER_TYPE_INSTANCE) continue;
                InstanceClusterInfo instanceInfo = (InstanceClusterInfo)current;
                RemoteVm[] remoteVms = this.remoteCluster.getVms(instanceInfo.getInstanceId());
                for (Vm vm : vms = this.remoteCluster.getVms(remoteVms)) {
                    if (vm == null) continue;
                    result.add(new ClusterVm(instanceInfo.getInstanceId(), vm));
                }
            }
        }
        catch (RemoteException e) {
            this.connectionLost();
        }
        return result;
    }

    private Board[] getFromClusterProvider() {
        if (this.remoteCluster == null) {
            return null;
        }
        if (this.includeControlAreas) {
            Map<Integer, Board> oldControlAreaBoards = this.remoteControlAreaBoards;
            this.remoteControlAreaBoards = new TreeMap<Integer, Board>();
            List<ClusterVm> currentVms = this.getRemoteVms();
            for (ClusterVm clusterVm : currentVms) {
                Vm vm = clusterVm.vm;
                try {
                    int pid = vm.getStateInfo().getPid();
                    Integer vmKey = pid;
                    Board vmBoard = oldControlAreaBoards.get(vmKey);
                    if (vmBoard == null) {
                        vmBoard = new BoardDelegateImpl(new BoardControlAreaBasedImpl(vm, this.host, pid, clusterVm.instanceId));
                    }
                    this.remoteControlAreaBoards.put(vmKey, vmBoard);
                }
                catch (InvalidVmException invalidVmException) {}
            }
            return this.remoteControlAreaBoards.values().toArray(new Board[0]);
        }
        return null;
    }

    private void connectionLost() {
        for (Board boardToRemove : this.remoteBoards.values()) {
            assert (boardToRemove.isBoardBased());
            if (!boardToRemove.isBoardBased()) continue;
            ((BoardDelegateImpl)boardToRemove).lostConnection();
        }
        for (Board boardToRemove : this.remoteControlAreaBoards.values()) {
            assert (!boardToRemove.isBoardBased());
            if (boardToRemove.isBoardBased()) continue;
            ((BoardDelegateImpl)boardToRemove).lostConnection();
        }
        this.remoteBoards.clear();
        this.boardBuffers.clear();
        this.remoteControlAreaBoards.clear();
        this.remoteBoardProvider = null;
        this.remoteCluster = null;
        this.canUpdateBoards = false;
    }

    private class ClusterVm {
        private final int instanceId;
        private final Vm vm;

        private ClusterVm(int instanceId, Vm vm) {
            this.instanceId = instanceId;
            this.vm = vm;
        }
    }
}

