/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.BoardContentProvider;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardUpdateListener;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class BoardWithProviderImpl
extends BoardImpl {
    private final BoardContentProvider contentProvider;
    private ByteBuffer currentContent;

    public BoardWithProviderImpl(BoardContentProvider contentProvider, int pid) throws MonitorBoardFormatException {
        super(pid);
        this.init(contentProvider.getContent(pid), pid);
        this.contentProvider = contentProvider;
        this.currentContent = null;
    }

    @Override
    public synchronized boolean update() {
        if (!this.isAlive()) {
            return false;
        }
        this.currentContent = this.contentProvider.getContent(this.getPid());
        return this.updateInternal();
    }

    public synchronized boolean update(ByteBuffer content) {
        if (!this.isAlive()) {
            return false;
        }
        this.currentContent = content;
        return this.updateInternal();
    }

    private synchronized boolean updateInternal() {
        try {
            if (this.updateBoard(this.currentContent, this.contentProvider.deliversOnlineData())) {
                Iterator iter = this.updateListener.iterator();
                while (iter.hasNext()) {
                    ((BoardUpdateListener)iter.next()).updateHasBeenProcessed(this);
                }
                return true;
            }
            return false;
        }
        catch (MonitorBoardFormatException ex) {
            Trace.get(BoardImpl.class).error((Throwable)ex, "Update failed with MonitorBoardFormatException: " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            Trace.get(BoardImpl.class).error((Throwable)ex, "Update failed with IOException : " + ex.getMessage());
            return false;
        }
    }

    public synchronized ByteBuffer getContent() {
        if (this.currentContent == null) {
            this.update();
        }
        return this.currentContent;
    }

    @Override
    public boolean belongsToOwnProcess() {
        return false;
    }

    @Override
    public ByteBuffer getCurrentByteBuffer() {
        return this.getContent();
    }
}

