/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeUnitType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.BoardProviderLocal;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.jvmmon.MonitoringAttribute;
import com.sap.jvm.util.misc.ByteConverter;
import com.sap.jvm.util.misc.UTF8Util;
import com.sap.jvm.util.pair.IntPair;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BoardWrapper {
    byte[] board;
    private final Map<String, MonitoringAttribute> attributes;
    private final int pid;

    private Map<String, MonitoringAttribute> readAttributes() {
        assert (this.isValid());
        HashMap<String, MonitoringAttribute> result = new HashMap<String, MonitoringAttribute>();
        int off = ByteConverter.readInt32(this.board, 36);
        int attrCount = ByteConverter.readInt32(this.board, 28);
        for (int i = 0; i < attrCount; ++i) {
            int size = ByteConverter.readInt32(this.board, off + 4);
            try {
                MonitoringAttribute attr = new MonitoringAttribute(this.board, off);
                result.put(attr.getName(), attr);
            }
            catch (MonitorBoardFormatException monitorBoardFormatException) {
                // empty catch block
            }
            off += size;
        }
        return result;
    }

    private byte[] getCrc() {
        int size = ByteConverter.readInt32(this.board, 4) - 12;
        byte[] crc = new byte[8];
        for (int i = 0; i < size; ++i) {
            int n = i & 7;
            crc[n] = (byte)(crc[n] ^ this.board[i]);
        }
        return crc;
    }

    private void addCrc() {
        int offsetToChecksum = ByteConverter.readInt32(this.board, 4) - 12;
        byte[] crc = this.getCrc();
        for (int i = 0; i < 8; ++i) {
            this.board[offsetToChecksum + i] = crc[i];
        }
    }

    private String[] getStringList(String prefix) {
        String arg;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && (arg = this.getString(prefix + i, null)) != null; ++i) {
            result.add(arg);
        }
        return result.toArray(new String[result.size()]);
    }

    private synchronized void addAttribute(String name, int maxLength, AttributeGroupType groupType, AttributeDataType dataType, AttributeVariabilityType varType, AttributeUnitType unitType, Map<String, MonitoringAttribute> attributes) throws MonitorBoardFormatException {
        byte[] nameAsUtf = UTF8Util.modifiedUTF8(name);
        int count = Math.max(1, maxLength);
        int additionalLength = 24 + nameAsUtf.length + dataType.getSizeInBytes() * count;
        byte[] newBoard = this.board;
        int oldSize = ByteConverter.readInt32(this.board, 4);
        if (newBoard.length < oldSize + additionalLength) {
            newBoard = new byte[oldSize + additionalLength + 8192];
            System.arraycopy(this.board, 0, newBoard, 0, oldSize - 12);
        }
        ByteConverter.writeInt32(newBoard, 4, oldSize + additionalLength);
        int oldCount = ByteConverter.readInt32(newBoard, 28);
        ByteConverter.writeInt32(newBoard, 28, oldCount + 1);
        ByteConverter.writeInt32(newBoard, oldSize - 12, BoardImpl.MAGIC_NUMBER);
        ByteConverter.writeInt32(newBoard, oldSize - 8, additionalLength);
        newBoard[oldSize - 4] = (byte)AttributeGroupType.getIndexFor(groupType);
        newBoard[oldSize - 3] = (byte)AttributeDataType.getIndexFor(dataType);
        newBoard[oldSize - 2] = (byte)AttributeVariabilityType.getIndexFor(varType);
        newBoard[oldSize - 1] = (byte)AttributeUnitType.getIndexFor(unitType);
        ByteConverter.writeInt16(newBoard, oldSize, (short)16);
        ByteConverter.writeInt16(newBoard, oldSize + 2, (short)(20 + nameAsUtf.length));
        ByteConverter.writeInt32(newBoard, oldSize + 4, nameAsUtf.length);
        System.arraycopy(nameAsUtf, 0, newBoard, oldSize + 8, nameAsUtf.length);
        ByteConverter.writeInt32(newBoard, oldSize + 8 + nameAsUtf.length, maxLength);
        if (attributes != null) {
            MonitoringAttribute attr = new MonitoringAttribute(newBoard, oldSize - 12);
            attributes.put(name, attr);
        }
        this.makeValid();
        this.board = newBoard;
    }

    private boolean addAttribute(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, boolean initialValue) {
        try {
            this.addAttribute(name, 0, groupType, AttributeDataType.TYPE_BOOL, varType, unitType, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setBoolean(this.board, initialValue);
        return true;
    }

    private boolean addAttribute(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, short initialValue) {
        try {
            this.addAttribute(name, 0, groupType, AttributeDataType.TYPE_INT16, varType, unitType, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setShort(this.board, initialValue);
        return true;
    }

    private boolean addAttribute(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, int initialValue) {
        try {
            this.addAttribute(name, 0, groupType, AttributeDataType.TYPE_INT32, varType, unitType, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setInt(this.board, initialValue);
        return true;
    }

    private boolean addAttribute(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, long initialValue) {
        try {
            this.addAttribute(name, 0, groupType, AttributeDataType.TYPE_INT64, varType, unitType, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setLong(this.board, initialValue);
        return true;
    }

    private boolean addAttribute(String name, AttributeGroupType groupType, AttributeVariabilityType varType, String initialValue) {
        int arrayLength = Math.max(1, UTF8Util.modifiedUTF8(initialValue).length);
        try {
            this.addAttribute(name, arrayLength, groupType, AttributeDataType.TYPE_CHAR, varType, AttributeUnitType.TYPE_UTF8STRING, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setString(this.board, initialValue);
        return true;
    }

    private boolean addAttribute(String name, int maxLength, AttributeGroupType groupType, AttributeVariabilityType varType, String initialValue) {
        try {
            this.addAttribute(name, maxLength, groupType, AttributeDataType.TYPE_CHAR, varType, AttributeUnitType.TYPE_UTF8STRING, this.attributes);
        }
        catch (MonitorBoardFormatException e) {
            return false;
        }
        this.attributes.get(name).setString(this.board, initialValue);
        return true;
    }

    public BoardWrapper(int pid, long startTime) {
        this.board = new byte[8192];
        this.pid = pid;
        ByteConverter.writeInt32(this.board, 0, BoardImpl.MAGIC_NUMBER);
        ByteConverter.writeInt32(this.board, 4, 60);
        ByteConverter.writeInt32(this.board, 8, pid);
        ByteConverter.writeInt64(this.board, 12, System.currentTimeMillis());
        ByteConverter.writeInt32(this.board, 20, 1);
        ByteConverter.writeInt32(this.board, 24, 1);
        ByteConverter.writeInt32(this.board, 28, 0);
        ByteConverter.writeInt32(this.board, 32, 1000);
        ByteConverter.writeInt32(this.board, 36, 48);
        ByteConverter.writeInt64(this.board, 40, startTime);
        this.makeValid();
        this.attributes = this.readAttributes();
    }

    public BoardWrapper(byte[] board) throws MonitorBoardFormatException {
        this.board = board;
        if (this.isCorrupt()) {
            throw new MonitorBoardFormatException("Board data is corrupt.");
        }
        this.pid = ByteConverter.readInt32(board, 8);
        this.makeValid();
        this.attributes = this.readAttributes();
    }

    public BoardWrapper(BoardWrapper oldBoard, BoardWrapper updatedBoard) throws MonitorBoardFormatException {
        if (!updatedBoard.isValid()) {
            throw new MonitorBoardFormatException("Updated board data is corrupt.");
        }
        assert (updatedBoard.pid == oldBoard.pid);
        assert (oldBoard.pid > 0);
        int size = oldBoard.board.length;
        this.board = new byte[size];
        this.pid = oldBoard.pid;
        System.arraycopy(oldBoard.board, 0, this.board, 0, size);
        System.arraycopy(updatedBoard.board, 12, this.board, 12, 8);
        size = ByteConverter.readInt32(updatedBoard.board, 4);
        int attrStart = ByteConverter.readInt32(updatedBoard.board, 36);
        System.arraycopy(updatedBoard.board, attrStart, this.board, attrStart, size - attrStart - 12);
        this.makeValid();
        this.attributes = oldBoard.attributes;
    }

    public byte[] getRawData() {
        return this.board;
    }

    public Map<String, MonitoringAttribute> getAllAttributes() {
        return this.attributes;
    }

    public void addMissing(long startupTime, int pid, boolean withBoard, int systemNr, int vmIndex, String vmVersion, String workingDir, String[] vmFlags, String[] vmArgs, String[] javaArgsArray, String mainClass, String vmTag, String javaArgs, String jarFilename) {
        if (!this.hasAttributes()) {
            long startTime = InspectorInfo.getCreationTimeOfProcess(pid) * 1000L;
            this.setStartTime(startTime);
            this.addIfMissing("CREATED_FROM_CONTROL_AREA", AttributeGroupType.TYPE_MISC, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, true);
        }
        if (withBoard) {
            this.addIfMissing("WILL_HAVE_MONITORING_BAORD", AttributeGroupType.TYPE_MISC, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, withBoard);
        }
        if (!this.hasAttribute("HOSTNAME")) {
            this.addIfMissing("HOSTNAME", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, BoardProviderLocal.NORMALIZED_LOCALHOST);
        }
        if (javaArgsArray.length > 0 && !this.hasAttribute("JAVA_ARGUMENT0")) {
            for (int i = 0; i < javaArgsArray.length; ++i) {
                this.addIfMissing("JAVA_ARGUMENT" + i, AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, javaArgsArray[i]);
            }
        }
        if (vmFlags.length > 0 && !this.hasAttribute("JVM_FLAG0")) {
            for (int i = 0; i < vmFlags.length; ++i) {
                this.addIfMissing("JVM_FLAG" + i, AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, vmFlags[i]);
            }
        }
        if (vmArgs.length > 0 && !this.hasAttribute("JVM_ARGUMENT0")) {
            for (int i = 0; i < vmArgs.length; ++i) {
                this.addIfMissing("JVM_ARGUMENT" + i, AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, vmArgs[i]);
            }
        }
        if (jarFilename != null) {
            this.addIfMissing("JAR_FILE_NAME", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, jarFilename);
        }
        this.addIfMissing("PID", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, pid);
        this.addIfMissing("USER_NAME", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, "NOT_AVAILABLE");
        this.addIfMissing("PARENT_PID", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, 0);
        this.addIfMissing("CPU_NUM_CORES", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NUMBER, (short)InspectorInfo.getCpuCount());
        this.addIfMissing("WORKINGDIR", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, workingDir);
        this.addIfMissing("EXECUTABLE", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, "NOT AVAILABLE");
        this.addIfMissing("JVM_TAG", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, vmTag);
        this.addIfMissing("JAVA_MAINCLASS", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, mainClass == null ? "" : mainClass);
        this.addIfMissing("JAVA_ARGUMENTS", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, javaArgs);
        this.addIfMissing("VM_VERSION_STRING", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, vmVersion);
        this.addIfMissing("SAP_SYSTEM", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, systemNr);
        this.addIfMissing("JVM_INDEX", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_STATIC, AttributeUnitType.TYPE_NONE, vmIndex);
        this.addIfMissing("DEBUGGING_ON_DEMAND_ENABLED", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NONE, false);
        this.addIfMissing("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NONE, false);
        this.addIfMissing("DEBUGGING_PORT", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NONE, -1);
        this.addIfMissing("DEBUGGING_DEFAULT_PORT_FROM", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NONE, -1);
        this.addIfMissing("DEBUGGING_DEFAULT_PORT_TO", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NONE, -1);
        this.addIfMissing("DEBUGGING_MODE", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_DEBUGGINGMODE, (short)0);
        this.addIfMissing("DEBUGGING_STATE", AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_DEBUGGINGMODE, 0);
        this.addIfMissing("DEBUGGING_CLIENT", 128, AttributeGroupType.TYPE_VMINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, "");
        this.addIfMissing("SYS_CPU_TIME", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND, -1L);
        this.addIfMissing("USER_CPU_TIME", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND, -1L);
        this.addIfMissing("ELAPSED_TIME", AttributeGroupType.TYPE_PROCESSINFO, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_MICROSECOND, -1L);
        this.addIfMissing("HEAP_COMMITTED_AFTER_GC", AttributeGroupType.TYPE_GC, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_BYTE, 0L);
        this.addIfMissing("PERM_COMMITTED_AFTER_GC", AttributeGroupType.TYPE_GC, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_BYTE, 0L);
        this.addIfMissing("NUM_GCS", AttributeGroupType.TYPE_GC, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NUMBER, 0L);
        this.addIfMissing("NUM_FULL_GCS", AttributeGroupType.TYPE_GC, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_NUMBER, 0L);
        this.addIfMissing("CC_COMMITTED", AttributeGroupType.TYPE_COMPILER, AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC, AttributeUnitType.TYPE_BYTE, 0L);
    }

    public boolean addIfMissing(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, int initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, groupType, varType, unitType, initialValue);
    }

    public boolean addIfMissing(String name, AttributeGroupType groupType, AttributeVariabilityType varType, String initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, groupType, varType, initialValue);
    }

    public boolean addIfMissing(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, long initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, groupType, varType, unitType, initialValue);
    }

    public boolean addIfMissing(String name, int maxLength, AttributeGroupType groupType, AttributeVariabilityType varType, String initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, maxLength, groupType, varType, initialValue);
    }

    public boolean addIfMissing(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, short initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, groupType, varType, unitType, initialValue);
    }

    public boolean isCorrupt() {
        if (this.board.length < 60) {
            return true;
        }
        if (ByteConverter.readInt32(this.board, 0) != BoardImpl.MAGIC_NUMBER) {
            return true;
        }
        int size = ByteConverter.readInt32(this.board, 4);
        if (size > this.board.length || size < 60) {
            return true;
        }
        int nrOfAttributes = ByteConverter.readInt32(this.board, 28);
        return nrOfAttributes < 0 || nrOfAttributes * 25 > size;
    }

    public boolean isValid() {
        if (this.isCorrupt()) {
            return false;
        }
        int majorVersion = ByteConverter.readInt32(this.board, 20);
        int minorVersion = ByteConverter.readInt32(this.board, 24);
        int offsetToChecksum = this.getBoardSize() - 12;
        if (majorVersion == 1 && minorVersion > 0) {
            byte[] crc = this.getCrc();
            for (int i = 0; i < 8; ++i) {
                if (crc[i] == this.board[offsetToChecksum + i]) continue;
                return false;
            }
        } else if (majorVersion == 1 && ByteConverter.readInt64(this.board, 12) != ByteConverter.readInt64(this.board, offsetToChecksum)) {
            return false;
        }
        return true;
    }

    public void makeValid() {
        if (this.board.length < 60) {
            return;
        }
        int majorVersion = ByteConverter.readInt32(this.board, 20);
        int minorVersion = ByteConverter.readInt32(this.board, 24);
        int offsetToChecksum = this.getBoardSize() - 12;
        if (majorVersion == 1 && minorVersion > 0) {
            this.addCrc();
        } else if (majorVersion == 1) {
            long timeStamp = ByteConverter.readInt64(this.board, 12);
            ByteConverter.writeInt64(this.board, offsetToChecksum, timeStamp);
        }
    }

    public int getPid() {
        return this.pid;
    }

    public int getInstanceNr() {
        return this.getInt("SAP_SYSTEM", -1);
    }

    public int getClusterIndex() {
        return this.getInt("JVM_INDEX", -1);
    }

    public String getJavaArgumentLine() {
        return this.getString("JAVA_ARGUMENTS", "<unknown arguments>");
    }

    public String[] getJavaArguments() {
        return this.getStringList("JAVA_ARGUMENT");
    }

    public String[] getVmFlags() {
        return this.getStringList("JVM_FLAG");
    }

    public String[] getVmArguments() {
        return this.getStringList("JVM_ARGUMENT");
    }

    public String[] getVmFlagsAndArguments() {
        String[] flags = this.getVmFlags();
        String[] arguments = this.getVmArguments();
        String[] result = new String[flags.length + arguments.length];
        System.arraycopy(flags, 0, result, 0, flags.length);
        System.arraycopy(arguments, 0, result, flags.length, arguments.length);
        return result;
    }

    public String getWorkingDirectory() {
        return this.getString("WORKINGDIR", "<unknown working directory>");
    }

    public String getVmVersion() {
        return this.getString("VM_VERSION_STRING", "<unknown VM version>");
    }

    public String getVmTag() {
        return this.getString("JVM_TAG", "");
    }

    public int getVmIndex() {
        return this.getInt("JVM_INDEX", -1);
    }

    public long getCpuTime() {
        return this.getLong("SYS_CPU_TIME", 0L) + this.getLong("USER_CPU_TIME", 0L);
    }

    public long getElapsedTime() {
        return this.getLong("ELAPSED_TIME", 0L);
    }

    public long getNrOfGcs() {
        return this.getLong("NUM_GCS", 0L);
    }

    public long getNrOfFullGcs() {
        return this.getLong("NUM_FULL_GCS", 0L);
    }

    public String getJarFileName() {
        return this.getString("JAR_FILE_NAME", null);
    }

    public String getMainClass() {
        return this.getString("JAVA_MAINCLASS", null);
    }

    public int getBoardSize() {
        return ByteConverter.readInt32(this.board, 4);
    }

    public long getTimeStamp() {
        return ByteConverter.readInt64(this.board, 12);
    }

    public long getCommittedHeapSizeAfterLastGc() {
        return this.getLong("HEAP_COMMITTED_AFTER_GC", 0L);
    }

    public long getCommittedPermSizeAfterLastGc() {
        return this.getLong("PERM_COMMITTED_AFTER_GC", 0L);
    }

    public long getUsedPermSizeAfterLastGc() {
        return this.getLong("PERM_USED_AFTER_GC", 0L);
    }

    public long getCompressedClassSpaceSize() {
        return this.getLong("COMPRESSED_CLASS_SPACE_SIZE", 0L);
    }

    public long getCompressedClassSpaceUsed() {
        return this.getLong("COMPRESSED_CLASS_SPACE_USED_AFTER_GC", 0L);
    }

    public long getCompressedClassSpaceCommitted() {
        return this.getLong("COMPRESSED_CLASS_SPACE_COMMITTED_AFTER_GC", 0L);
    }

    public long getCommittedCodeCacheSize() {
        return this.getLong("CC_COMMITTED", 0L);
    }

    public boolean isDebuggingOnDemandEnabled() {
        return this.getBoolean("DEBUGGING_ON_DEMAND_ENABLED", false);
    }

    public IntPair getDefaultDebuggingPortRange() {
        int fromPort = this.getInt("DEBUGGING_DEFAULT_PORT_FROM", -1);
        int toPort = this.getInt("DEBUGGING_DEFAULT_PORT_TO", -1);
        return new IntPair(fromPort, toPort);
    }

    public DebugOnDemandState getDebugOnDemandState() {
        int state = this.getInt("DEBUGGING_STATE", 0);
        for (DebugOnDemandState result : DebugOnDemandState.values()) {
            if (result.ordinal() != state) continue;
            return result;
        }
        return DebugOnDemandState.STATE_UNKNOWN;
    }

    public int getDebugPort() {
        return this.getInt("DEBUGGING_PORT", -1);
    }

    public String getDebugClient() {
        return this.getString("DEBUGGING_CLIENT", "");
    }

    public boolean isDebugLocalOnly() {
        return this.getBoolean("DEBUGGING_ACCESSIBILITY_ONLY_LOCAL", false);
    }

    public long getStartTime() {
        return ByteConverter.readInt64(this.board, 40);
    }

    public void setStartTime(long startTime) {
        ByteConverter.writeInt64(this.board, 40, startTime);
    }

    public boolean isDifferentProcess(BoardWrapper other) {
        if (this.pid != other.getPid()) {
            return true;
        }
        long oldStartTime = this.getStartTime();
        if (oldStartTime != other.getStartTime()) {
            return true;
        }
        if (oldStartTime == 0L) {
            for (MonitoringAttribute oldAttr : this.attributes.values()) {
                MonitoringAttribute newAttr = other.attributes.get(oldAttr.getName());
                if (newAttr == null) {
                    return true;
                }
                AttributeVariabilityType varType = oldAttr.getVariabilityType();
                if (varType != AttributeVariabilityType.TYPE_STATIC && varType != AttributeVariabilityType.TYPE_SYNTHETIC_STATIC || oldAttr.getDataType() != AttributeDataType.TYPE_CHAR) continue;
                if (newAttr.getDataType() != AttributeDataType.TYPE_CHAR) {
                    return true;
                }
                if (oldAttr.getString(this.board).equals(newAttr.getString(other.board))) continue;
                return true;
            }
        }
        return false;
    }

    public byte[] getBoardData() {
        return (byte[])this.board.clone();
    }

    public String[] getAttributeNamesForPrefix(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.attributes.keySet()) {
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public MonitoringAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean isSynthetic(String name) {
        MonitoringAttribute attr = this.attributes.get(name);
        if (attr != null) {
            AttributeVariabilityType type = attr.getVariabilityType();
            return type == AttributeVariabilityType.TYPE_SYNTHETIC_DYNAMIC || type == AttributeVariabilityType.TYPE_SYNTHETIC_STATIC;
        }
        return false;
    }

    public boolean isStatic(String name) {
        MonitoringAttribute attr = this.attributes.get(name);
        if (attr != null) {
            AttributeVariabilityType type = attr.getVariabilityType();
            return type == AttributeVariabilityType.TYPE_STATIC || type == AttributeVariabilityType.TYPE_SYNTHETIC_STATIC;
        }
        return false;
    }

    public boolean isDynamic(String name) {
        MonitoringAttribute attr = this.attributes.get(name);
        if (attr != null) {
            AttributeVariabilityType type = attr.getVariabilityType();
            return type == AttributeVariabilityType.TYPE_DYNAMIC || type == AttributeVariabilityType.TYPE_SYNTHETIC_STATIC;
        }
        return false;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean addIfMissing(String name, AttributeGroupType groupType, AttributeVariabilityType varType, AttributeUnitType unitType, boolean initialValue) {
        if (this.attributes.containsKey(name)) {
            return false;
        }
        return this.addAttribute(name, groupType, varType, unitType, initialValue);
    }

    public int getLength(String name) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return -1;
        }
        return attr.getLength(this.board);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getBoolean(this.board);
    }

    boolean setBoolean(String name, boolean value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setBoolean(this.board, value);
        }
        return attr != null;
    }

    public boolean[] getBooleanArray(String name, boolean[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getBooleanArray(this.board);
    }

    boolean setBooleanArray(String name, boolean[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setBooleanArray(this.board, value);
        }
        return attr != null;
    }

    public byte getByte(String name, byte defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getByte(this.board);
    }

    boolean setByte(String name, byte value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setByte(this.board, value);
        }
        return attr != null;
    }

    public byte[] getByteArray(String name, byte[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getByteArray(this.board);
    }

    boolean setByteArray(String name, byte[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setByteArray(this.board, value);
        }
        return attr != null;
    }

    public short getShort(String name, short defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getShort(this.board);
    }

    boolean setShort(String name, short value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setShort(this.board, value);
        }
        return attr != null;
    }

    public short[] getShortArray(String name, short[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getShortArray(this.board);
    }

    boolean setShortArray(String name, short[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setShortArray(this.board, value);
        }
        return attr != null;
    }

    public int getInt(String name, int defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getInt(this.board);
    }

    boolean setInt(String name, int value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setInt(this.board, value);
        }
        return attr != null;
    }

    public int[] getIntArray(String name, int[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getIntArray(this.board);
    }

    boolean setIntArray(String name, int[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setIntArray(this.board, value);
        }
        return attr != null;
    }

    public long getLong(String name, long defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getLong(this.board);
    }

    boolean setLong(String name, long value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setLong(this.board, value);
        }
        return attr != null;
    }

    public long[] getLongArray(String name, long[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getLongArray(this.board);
    }

    boolean setLongArray(String name, long[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setLongArray(this.board, value);
        }
        return attr != null;
    }

    public float getFloat(String name, float defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getFloat(this.board);
    }

    boolean setFloat(String name, float value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setFloat(this.board, value);
        }
        return attr != null;
    }

    public float[] getFloatArray(String name, float[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getFloatArray(this.board);
    }

    boolean setFloatArray(String name, float[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setFloatArray(this.board, value);
        }
        return attr != null;
    }

    public double getDouble(String name, double defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getDouble(this.board);
    }

    boolean setDouble(String name, double value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setDouble(this.board, value);
        }
        return attr != null;
    }

    public double[] getDoubleArray(String name, double[] defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getDoubleArray(this.board);
    }

    boolean setDoubleArray(String name, double[] value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setDoubleArray(this.board, value);
        }
        return attr != null;
    }

    public String getString(String name, String defaultValue) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getString(this.board);
    }

    public boolean setString(String name, String value) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setString(this.board, value);
        }
        return attr != null;
    }

    public String toString(String name) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return "<undefined attribute '" + name + "'>";
        }
        return attr.toString(this.board);
    }

    public List<String> getValuesAsString(String name) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return new ArrayList<String>();
        }
        return attr.getValuesAsString(this.board);
    }

    public void print(String name, PrintStream stream) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            stream.println(this.toString(name));
        } else {
            attr.print(this.board, stream);
        }
    }

    public void printDetailed(String name, PrintStream stream) {
        MonitoringAttribute attr = this.getAttribute(name);
        if (attr == null) {
            stream.println(this.toString(name));
        } else {
            attr.printDetailed(this.board, stream);
        }
    }

    public void print(boolean detailed, PrintStream stream) {
        ArrayList<String> names = new ArrayList<String>(this.attributes.keySet());
        Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
        for (String name : names) {
            if (detailed) {
                this.attributes.get(name).printDetailed(this.board, stream);
                continue;
            }
            this.attributes.get(name).print(this.board, stream);
        }
    }

    public static enum DebugOnDemandState {
        STATE_UNKNOWN("Debugging state is unknown"),
        STATE_NOT_ACTIVE("Debugging not active"),
        STATE_REQUESTED("Debugging not active, but requested"),
        STATE_STARTING("Debugging is starting up"),
        STATE_WAIT_FOR_DEBUGGER("Debugging back is waiting for debugger to connect"),
        STATE_DEBUGGER_ATTACHED("Debugger is attached"),
        STATE_STOPPING("Debugging is stopping");

        private final String description;

        private DebugOnDemandState(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

