/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.board.Value;
import com.sap.jvm.util.misc.ByteConverter;
import java.nio.ByteBuffer;

public class ValueHelperImpl
implements Value {
    private byte[] valueBuffer;
    private AttributeDataType dataType;
    private long timeStamp;

    public ValueHelperImpl(byte[] buff, AttributeDataType dt, long ts) {
        this.init(buff, dt, ts);
    }

    public ValueHelperImpl() {
        this.valueBuffer = null;
        this.dataType = null;
        this.timeStamp = 0L;
    }

    public synchronized void init(byte[] buff, AttributeDataType dt, long ts) {
        this.valueBuffer = (byte[])buff.clone();
        this.dataType = dt;
        this.timeStamp = ts;
    }

    public static boolean buffersAreEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    protected synchronized byte[] updatebuffer(byte[] buff, long timeStamp1) {
        if (!ValueHelperImpl.buffersAreEqual(this.valueBuffer, buff)) {
            this.valueBuffer = buff;
            return this.valueBuffer;
        }
        return null;
    }

    protected synchronized void updateTimeStamp(long ts) {
        this.timeStamp = ts;
    }

    public String getValue() throws MonitorBoardFormatException {
        switch (this.dataType) {
            case TYPE_CHAR: {
                int length = this.valueBuffer.length;
                if (length > 0 && this.valueBuffer[length - 1] == 0) {
                    --length;
                }
                return new String(this.valueBuffer, 0, length);
            }
            case TYPE_BOOL: {
                return Boolean.toString(this.valueBuffer[0] != 0);
            }
            case TYPE_INT8: {
                return Byte.toString(this.valueBuffer[0]);
            }
            case TYPE_INT16: {
                return Short.toString(ByteBuffer.wrap(this.valueBuffer).getShort());
            }
            case TYPE_INT32: {
                return Integer.toString(ByteBuffer.wrap(this.valueBuffer).getInt());
            }
            case TYPE_INT64: {
                return Long.toString(ByteBuffer.wrap(this.valueBuffer).getLong());
            }
            case TYPE_FLOAT: {
                return Float.toString(ByteBuffer.wrap(this.valueBuffer).getFloat());
            }
            case TYPE_DOUBLE: {
                return Double.toString(ByteBuffer.wrap(this.valueBuffer).getDouble());
            }
        }
        throw new MonitorBoardFormatException("Unknown data type " + (Object)((Object)this.dataType));
    }

    @Override
    public boolean getBoolValue() throws MonitorBoardFormatException {
        return ValueHelperImpl.getBoolValue(this.valueBuffer, 0);
    }

    public static boolean getBoolValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readBoolean(buf, pos);
    }

    @Override
    public double getDoubleValue() throws MonitorBoardFormatException {
        if (this.dataType == AttributeDataType.TYPE_DOUBLE) {
            return ValueHelperImpl.getDoubleValue(this.valueBuffer, 0);
        }
        return Double.parseDouble(this.getAsString());
    }

    public static double getDoubleValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readDouble(buf, pos);
    }

    @Override
    public float getFloatValue() throws MonitorBoardFormatException {
        if (this.dataType == AttributeDataType.TYPE_FLOAT) {
            return ValueHelperImpl.getFloatValue(this.valueBuffer, 0);
        }
        return Float.parseFloat(this.getAsString());
    }

    public static float getFloatValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readFloat(buf, pos);
    }

    @Override
    public long getLongValue() throws MonitorBoardFormatException {
        if (this.dataType == AttributeDataType.TYPE_INT64) {
            return ValueHelperImpl.getLongValue(this.valueBuffer, 0);
        }
        return Long.parseLong(this.getAsString());
    }

    public static long getLongValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readInt64(buf, pos);
    }

    @Override
    public short getShortValue() throws MonitorBoardFormatException {
        if (this.dataType == AttributeDataType.TYPE_INT16) {
            return ValueHelperImpl.getShortValue(this.valueBuffer, 0);
        }
        return Short.parseShort(this.getAsString());
    }

    public static short getShortValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readInt16(buf, pos);
    }

    @Override
    public int getIntValue() throws MonitorBoardFormatException {
        if (this.dataType == AttributeDataType.TYPE_INT32) {
            return ByteConverter.readInt32(this.valueBuffer, 0);
        }
        return Integer.parseInt(this.getAsString());
    }

    public static int getIntValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return ByteConverter.readInt32(buf, pos);
    }

    public byte getRawByteValue() throws MonitorBoardFormatException {
        return this.valueBuffer[0];
    }

    public static byte getRawByteValue(byte[] buf, int pos) throws MonitorBoardFormatException {
        return buf[pos];
    }

    @Override
    public byte getByteValue() throws MonitorBoardFormatException {
        return Byte.parseByte(this.getAsString());
    }

    @Override
    public String getAsString() throws MonitorBoardFormatException {
        return this.getValue();
    }

    @Override
    public synchronized byte[] getRawData() {
        return this.valueBuffer;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (MonitorBoardFormatException e) {
            return "<invalid value>";
        }
    }
}

