/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.board;

import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeImpl;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.board.ValueHelperImpl;
import com.sap.jvm.tracing.Trace;
import java.nio.ByteBuffer;

public class ValueImpl
extends ValueHelperImpl {
    private final int startPosition;
    private int size;
    private final AttributeDataType dataType;

    protected ValueImpl(long timeStamp, AttributeImpl parentAttribute, ByteBuffer boardContent, int startPosition, int arraySize, AttributeDataType dt) throws MonitorBoardFormatException {
        this.startPosition = startPosition;
        if (this.startPosition > boardContent.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("this.startPosition > boardContent.capacity()");
            Trace.get(ValueImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        this.dataType = dt;
        this.size = ValueImpl.getRawDataBuffersize(dt, arraySize);
        if (this.size > boardContent.capacity()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("this.size > boardContent.capacity()");
            Trace.get(ValueImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
        byte[] valueBuffer = new byte[this.size];
        boardContent.position(this.startPosition);
        boardContent.get(valueBuffer, 0, this.size);
        this.init(valueBuffer, this.dataType, timeStamp);
        if (this.dataType != AttributeDataType.TYPE_CHAR & this.size > this.dataType.getSizeInBytes()) {
            MonitorBoardFormatException ex = new MonitorBoardFormatException("Got a byte array of size (" + arraySize + ") for type " + this.dataType.getId());
            Trace.get(ValueImpl.class).error((Throwable)ex, ex.getMessage());
            throw ex;
        }
    }

    static int getRawDataBuffersize(AttributeDataType dt, int arraySize) {
        int size = 0;
        if (dt == AttributeDataType.TYPE_CHAR) {
            int _elementCount = 1;
            if (arraySize > 1) {
                _elementCount = arraySize - 1;
            }
            size = _elementCount * dt.getSizeInBytes();
        } else {
            size = dt.getSizeInBytes();
        }
        return size;
    }

    protected int getSize() {
        return this.size;
    }
}

