/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.cluster;

import com.sap.jvm.impl.monitor.cluster.ClusterInfoImpl;
import com.sap.jvm.impl.monitor.cluster.InstanceClusterInfoImpl;
import com.sap.jvm.impl.monitor.cluster.ProcessClusterInfoImpl;
import com.sap.jvm.inspector.WithInspectorNativeLib;
import com.sap.jvm.inspector.cluster.InstanceInfo;
import com.sap.jvm.inspector.cluster.ProfilingVmImpl;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ProfilingCluster
extends WithInspectorNativeLib {
    private static Vm getVmWithVmIndex(int instanceId, int vmIndex) {
        int clusterTypeId = ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_INSTANCE);
        ProfilingVmImpl vm = new ProfilingVmImpl(clusterTypeId, instanceId, vmIndex);
        if (vm.isValid()) {
            return vm;
        }
        return null;
    }

    public static synchronized native byte[] getClusterInfoRaw();

    public static native int getUniqueId(int var0, int var1, int var2);

    public static native int getMaxVms(int var0);

    public static native boolean isValidVm(int var0, int var1, int var2);

    public static native byte[] getClusterDetailedInfo(int var0);

    public static native boolean exit(int var0, int var1, int var2, int var3);

    public static native byte[] getVmDebugInfo(int var0, int var1, int var2);

    public static native boolean startDebug(int var0, int var1, int var2, int var3);

    public static native boolean stopDebug(int var0, int var1, int var2);

    public static native byte[] getVmStateInfo(int var0, int var1, int var2);

    public static native byte[] getVmStartInfo(int var0, int var1, int var2);

    public static native byte[] getVmTimeInfo(int var0, int var1, int var2);

    public static native byte[] getVmMemoryInfo(int var0, int var1, int var2);

    public static ClusterInfo[] getClusterInfo() {
        byte[] data = ProfilingCluster.getClusterInfoRaw();
        if (data == null) {
            return new ClusterInfo[0];
        }
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int numberElements = dataStream.readInt();
            ClusterInfo[] retValue = new ClusterInfo[numberElements];
            for (int i = 0; i < numberElements; ++i) {
                boolean attachable = dataStream.readBoolean();
                int typeId = dataStream.readInt();
                int id = dataStream.readInt();
                ClusterType type = ClusterType.getTypeForIndex(typeId);
                retValue[i] = type == ClusterType.CLUSTER_TYPE_PROCESS ? new ProcessClusterInfoImpl(id, attachable) : (type == ClusterType.CLUSTER_TYPE_INSTANCE ? new InstanceClusterInfoImpl(id, attachable) : new ClusterInfoImpl(type, attachable));
            }
            return retValue;
        }
        catch (IOException e) {
            Trace.get(ProfilingCluster.class).error((Throwable)e, "I/O exception during reading cluster monitoring information.");
        }
        catch (IllegalArgumentException e) {
            Trace.get(ProfilingCluster.class).error((Throwable)e, "Got illegal cluster type.");
        }
        return new ClusterInfo[0];
    }

    public static Vm getVm(int processId) {
        int i;
        ClusterInfo[] clusterInfo = ProfilingCluster.getClusterInfo();
        for (i = 0; i < clusterInfo.length; ++i) {
            if (!clusterInfo[i].isAttachable() || clusterInfo[i].getType() != ClusterType.CLUSTER_TYPE_PROCESS || ((ProcessClusterInfo)clusterInfo[i]).getProcessId() != processId) continue;
            boolean vmIndex = false;
            int clusterTypeId = ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_PROCESS);
            return new ProfilingVmImpl(clusterTypeId, processId, 0);
        }
        for (i = 0; i < clusterInfo.length; ++i) {
            if (!clusterInfo[i].isAttachable() || clusterInfo[i].getType() != ClusterType.CLUSTER_TYPE_INSTANCE) continue;
            InstanceClusterInfo instanceInfo = (InstanceClusterInfo)clusterInfo[i];
            Vm[] vms = ProfilingCluster.getVms(instanceInfo.getInstanceId());
            for (int k = 0; k < vms.length; ++k) {
                try {
                    if (vms[k].getStateInfo().getPid() != processId) continue;
                    return vms[k];
                }
                catch (InvalidVmException invalidVmException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Vm getProcessVm(int pid) {
        int clusterTypeId = ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_PROCESS);
        boolean vmIndex = false;
        return new ProfilingVmImpl(clusterTypeId, pid, 0);
    }

    public static Vm getInstanceVm(int vmIndex, int instanceId) {
        int clusterTypeId = ClusterType.getConfigurationIndex(ClusterType.CLUSTER_TYPE_INSTANCE);
        return new ProfilingVmImpl(clusterTypeId, instanceId, vmIndex);
    }

    public static Vm[] getVms(int instanceId) {
        int maxVms = ProfilingCluster.getMaxVms(instanceId);
        if (maxVms == -1) {
            return new Vm[0];
        }
        int validVms = 0;
        ProfilingVmImpl[] rawVms = new ProfilingVmImpl[maxVms];
        for (int i = 0; i < maxVms; ++i) {
            Vm actVm = ProfilingCluster.getVmWithVmIndex(instanceId, i);
            if (actVm == null) continue;
            rawVms[validVms] = actVm;
            ++validVms;
        }
        Vm[] result = new Vm[validVms];
        System.arraycopy(rawVms, 0, result, 0, validVms);
        return result;
    }

    public static InstanceInfo[] getInstanceInfo(int instanceId) {
        byte[] data = ProfilingCluster.getClusterDetailedInfo(instanceId);
        if (data == null) {
            return new InstanceInfo[0];
        }
        DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int vmIndex;
            int maxNumberElements = dataStream.readInt();
            ArrayList<InstanceInfo> instanceVms = new ArrayList<InstanceInfo>(maxNumberElements);
            while ((vmIndex = dataStream.readInt()) >= 0) {
                int pid = dataStream.readInt();
                int uniqueId = dataStream.readInt();
                instanceVms.add(new InstanceInfo(pid, vmIndex, uniqueId));
            }
            return instanceVms.toArray(new InstanceInfo[0]);
        }
        catch (IOException e) {
            Trace.get(ProfilingCluster.class).error((Throwable)e, "I/O exception during reading detailed instance information.");
            return new InstanceInfo[0];
        }
        catch (IndexOutOfBoundsException e) {
            Trace.get(ProfilingCluster.class).error((Throwable)e, "Index exception during reading detailed instance information.");
            return new InstanceInfo[0];
        }
    }
}

