/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.cluster;

import com.sap.jvm.impl.monitor.vm.VmDebugInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmMemoryInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmStartInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmStateInfoImpl;
import com.sap.jvm.impl.monitor.vm.VmTimeInfoImpl;
import com.sap.jvm.inspector.cluster.ProfilingCluster;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.monitor.vm.VmSnapshot;
import com.sap.jvm.monitor.vm.VmStartInfo;
import com.sap.jvm.monitor.vm.VmStateInfo;
import com.sap.jvm.monitor.vm.VmTimeInfo;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ProfilingVmImpl
implements Vm {
    private final int clusterTypeId;
    private final int clusterId;
    private final int vmIndex;

    protected ProfilingVmImpl(int clusterTypeId, int clusterId, int vmIndex) {
        this.clusterTypeId = clusterTypeId;
        this.clusterId = clusterId;
        this.vmIndex = vmIndex;
    }

    @Override
    public boolean isValid() {
        return ProfilingCluster.isValidVm(this.clusterTypeId, this.clusterId, this.vmIndex);
    }

    @Override
    public int getVmIndex() {
        return this.vmIndex;
    }

    @Override
    public VmStateInfo getStateInfo() throws InvalidVmException {
        try {
            byte[] rawData = ProfilingCluster.getVmStateInfo(this.clusterTypeId, this.clusterId, this.vmIndex);
            if (rawData == null) {
                throw new InvalidVmException(this);
            }
            return new VmStateInfoImpl(new DataInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            Trace.get(ProfilingVmImpl.class).error((Throwable)e, "Unexpected exception during reading state information.");
            return null;
        }
    }

    @Override
    public VmStartInfo getStartInfo() throws InvalidVmException {
        try {
            byte[] rawData = ProfilingCluster.getVmStartInfo(this.clusterTypeId, this.clusterId, this.vmIndex);
            if (rawData == null) {
                throw new InvalidVmException(this);
            }
            return new VmStartInfoImpl(new DataInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            Trace.get(ProfilingVmImpl.class).error((Throwable)e, "Unexpected exception during reading state information.");
            return null;
        }
    }

    @Override
    public VmDebugInfo getDebugInfo() throws InvalidVmException {
        try {
            byte[] rawData = ProfilingCluster.getVmDebugInfo(this.clusterTypeId, this.clusterId, this.vmIndex);
            if (rawData == null) {
                throw new InvalidVmException(this);
            }
            return new VmDebugInfoImpl(new DataInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            Trace.get(ProfilingVmImpl.class).error((Throwable)e, "Unexpected exception during reading debug information.");
            return null;
        }
    }

    @Override
    public VmProfilingInfo getProfilingInfo() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exit(int exitCode) throws InvalidVmException {
        if (!ProfilingCluster.exit(this.clusterTypeId, this.clusterId, this.vmIndex, exitCode)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void startDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        if (!ProfilingCluster.startDebug(this.clusterTypeId, this.clusterId, this.vmIndex, suspendPolicy.getIndex())) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void startLocalDebug(SuspendPolicy suspendPolicy) throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopDebug() throws InvalidVmException {
        if (!ProfilingCluster.stopDebug(this.clusterTypeId, this.clusterId, this.vmIndex)) {
            throw new InvalidVmException(this);
        }
    }

    @Override
    public void dumpHeap() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpHeap(String info) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized String encode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceGc() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceMaxGc() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpGcHistory() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpDllInformation() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpClassStatistic() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpDetailedClassStatistic() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpCodeblobs(String methodName, boolean showDetails) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpHsErrorInfo() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpSymbolInfo() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpSafepointState() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public VmMemoryInfo getMemoryInfo() throws InvalidVmException {
        try {
            byte[] rawData = ProfilingCluster.getVmMemoryInfo(this.clusterTypeId, this.clusterId, this.vmIndex);
            if (rawData == null) {
                throw new InvalidVmException(this);
            }
            return new VmMemoryInfoImpl(new DataInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            Trace.get(ProfilingVmImpl.class).error((Throwable)e, "Unexpected exception during reading memory information.");
            return null;
        }
    }

    @Override
    public VmTimeInfo getTimeInfo() throws InvalidVmException {
        try {
            byte[] rawData = ProfilingCluster.getVmTimeInfo(this.clusterTypeId, this.clusterId, this.vmIndex);
            if (rawData == null) {
                throw new InvalidVmException(this);
            }
            return new VmTimeInfoImpl(new DataInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            Trace.get(ProfilingVmImpl.class).error((Throwable)e, "Unexpected exception during reading time information.");
            return null;
        }
    }

    @Override
    public VmTraceFlagsSet getTraceFlags() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public VmSnapshot getVmSnapshot() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printStackDump() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printStackDump(String info) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultDebugPortRange(PortRange range) throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultProfilingPortRange(PortRange range) throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTraceFlags(VmTraceFlagsSet traceFlags) throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startProfiling() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopProfiling() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getClassStatistic() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getCodeblobs(String methodName, boolean showDetails) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getDetailedClassStatistic() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getDllInformation() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getFlightrecorder(int numLastEntries) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getGcHistory() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getHsErrorInfo() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayList<String> getStackDump() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getSymbolInfo() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getSymbolInfo(int maxNumber) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsOperation(MonitorOperation op) throws InvalidVmException {
        return false;
    }

    @Override
    public void startAttachServer() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean attachServerIsStarted() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> performOperation(MonitorOperation op, String ... args) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] retrieveCompleteGcHistory() throws InvalidVmException {
        throw new UnsupportedOperationException();
    }
}

