/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.debugging;

import java.security.AccessController;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;

public class DebuggingBackendServiceLoader<S> {
    protected ServiceLoader<S> serviceLoader;

    protected DebuggingBackendServiceLoader(ServiceLoader<S> sl) {
        this.serviceLoader = sl;
    }

    public static <S> DebuggingBackendServiceLoader<S> load(Class<S> service) {
        ServiceLoader sl = AccessController.doPrivileged(() -> ServiceLoader.load(service));
        return new DebuggingBackendServiceLoader<S>(sl);
    }

    public Optional<S> findFirst() {
        Iterator iterator = this.serviceLoader.iterator();
        if (iterator.hasNext()) {
            return AccessController.doPrivileged(() -> Optional.of(iterator.next()));
        }
        return Optional.empty();
    }
}

