/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.filesocket;

import com.sap.jdk.ext.filesocket.FileSocket;
import com.sap.jdk.ext.filesocket.FileSocketAddress;
import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.filesocket.FileSocketAdapter;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;

public class FileSocketConnection {
    private static final int MAX_CONNECT_TRIALS = 20;

    public static boolean testServer(String socketIdentifier, int timeout) {
        if (socketIdentifier == null || socketIdentifier.isEmpty()) {
            return false;
        }
        long t1 = System.currentTimeMillis();
        int timeoutFraq = timeout / 40;
        boolean success = false;
        try (FileSocket testFS = new FileSocket();){
            while (!success && System.currentTimeMillis() - t1 < (long)timeout) {
                try {
                    testFS.connect(new FileSocketAddress(socketIdentifier), timeoutFraq);
                    success = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(timeoutFraq);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    public static SocketAdapter connectToPid(int pid, int timeout) throws IOException {
        String socketIdentifier = InspectorInfo.getProfilingServerIdentifier(pid);
        if (socketIdentifier == null || socketIdentifier.isEmpty()) {
            throw new IOException("No server socket identifier could be determined for process with pid " + pid);
        }
        return FileSocketConnection.connectToSocket(socketIdentifier, timeout);
    }

    public static SocketAdapter connectToSocket(String socketIdentifier, int timeout) throws IOException {
        if (socketIdentifier == null || socketIdentifier.isEmpty()) {
            throw new IOException("Socket Identifier must not be null or empty");
        }
        long t1 = System.currentTimeMillis();
        int timeoutFrac = timeout / 40;
        FileSocket fileSocket = new FileSocket();
        FileSocketAddress serverAddr = new FileSocketAddress(socketIdentifier);
        IOException lastError = null;
        while (!fileSocket.isConnected() && System.currentTimeMillis() - t1 < (long)timeout) {
            try {
                fileSocket.connect(serverAddr, timeoutFrac);
            }
            catch (IOException e) {
                lastError = e;
            }
            if (fileSocket.isConnected()) continue;
            try {
                Thread.sleep(timeoutFrac);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!fileSocket.isConnected()) {
            fileSocket.close();
            throw lastError == null ? new IOException("Not able to connect to FileSocket " + serverAddr.getSocketIdentifier()) : lastError;
        }
        return new FileSocketAdapter(fileSocket);
    }
}

