/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.filesocket;

import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Socket2SocketAdapter
extends Thread {
    private final SocketAdapter fromSocket;
    private final SocketAdapter toSocket;

    public Socket2SocketAdapter(SocketAdapter fromSocket, SocketAdapter toSocket) {
        this.fromSocket = fromSocket;
        this.toSocket = toSocket;
        this.setDaemon(true);
        this.setName("Socket2SocketAdapter: " + fromSocket.toString() + "->" + toSocket.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStream in = this.fromSocket.getInputStream();
            OutputStream out = this.toSocket.getOutputStream();
            byte[] buffer = new byte[2048];
            while (true) {
                int num_read;
                if ((num_read = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, num_read);
                    out.flush();
                    continue;
                }
                if (num_read == -1) break;
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.fromSocket.close();
                this.toSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

