/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.impl.board.remote;

import com.sap.jvm.inspector.board.AttributeByteBufferBasedContainerImpl;
import com.sap.jvm.inspector.board.Board;
import com.sap.jvm.inspector.board.BoardDelegateImpl;
import com.sap.jvm.inspector.board.BoardProviderLocal;
import com.sap.jvm.inspector.board.BoardState;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfo;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardInfoEx;
import com.sap.jvm.inspector.impl.board.remote.RemoteBoardProviderEx;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;

public class RemoteBoardProviderImpl
extends UnicastRemoteObject
implements RemoteBoardProviderEx {
    private static final long serialVersionUID = -843083253814192988L;
    BoardProviderLocal localBoards = new BoardProviderLocal(true);
    private AttributeByteBufferBasedContainerImpl additionaleInformation = null;

    public RemoteBoardProviderImpl() throws RemoteException {
        this.additionaleInformation = new AttributeByteBufferBasedContainerImpl(0);
    }

    public RemoteBoardProviderImpl(RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(0, csf, ssf);
    }

    private RemoteBoardInfo searchBoardInfo(Board board, RemoteBoardInfo[] knownInfo) {
        if (knownInfo == null) {
            return null;
        }
        int curPid = board.getPid();
        long curTimestamp = board.getStartingTimeStamp();
        for (RemoteBoardInfo boardInfo : knownInfo) {
            if (boardInfo == null || boardInfo.pid != curPid || boardInfo.startingTimestamp != curTimestamp) continue;
            return boardInfo;
        }
        return null;
    }

    private RemoteBoardInfoEx[] _getRemoteBoardInfoEx(RemoteBoardInfo[] knownInfo, boolean addSize4DynamicCharAttributes) throws RemoteException {
        Board[] boards = this.localBoards.get();
        if (boards == null) {
            return null;
        }
        ArrayList<RemoteBoardInfoEx> resultBoardInfos = new ArrayList<RemoteBoardInfoEx>();
        for (int i = 0; i < boards.length; ++i) {
            Board board = boards[i];
            try {
                if (!board.update()) {
                }
            }
            catch (MonitorBoardFormatException e1) {}
            continue;
            if (board.isBoardBased() && (board.getState() == BoardState.TYPE_ALIVE_UNREADABLE_BOARD || board.getState() == BoardState.TYPE_DEAD_UNREADABLE_BOARD)) continue;
            RemoteBoardInfoEx newBoardInfo = new RemoteBoardInfoEx();
            newBoardInfo.pid = board.getPid();
            newBoardInfo.startingTimestamp = board.getStartingTimeStamp();
            newBoardInfo.isBoardBased = board.isBoardBased();
            AttributeByteBufferBasedContainerImpl addInfo = new AttributeByteBufferBasedContainerImpl();
            newBoardInfo.version = 1;
            newBoardInfo.additionalInfo = addInfo.getAsByteBuffer().array();
            newBoardInfo.connectabilityState = Connectability.TYPE_UNKNOWN;
            RemoteBoardInfo info = this.searchBoardInfo(board, knownInfo);
            if (info == null) {
                newBoardInfo.fullContent = true;
                newBoardInfo.connectabilityState = this.localBoards.getConnectability(newBoardInfo.pid);
                ByteBuffer currentBuffer = ((BoardDelegateImpl)board).getCurrentByteBuffer();
                newBoardInfo.boardContentBuffer = (byte[])(currentBuffer != null ? currentBuffer.array() : null);
            } else {
                newBoardInfo.fullContent = false;
                newBoardInfo.connectabilityState = info instanceof RemoteBoardInfoEx ? (((RemoteBoardInfoEx)info).connectabilityState == Connectability.TYPE_UNKNOWN ? this.localBoards.getConnectability(newBoardInfo.pid) : ((RemoteBoardInfoEx)info).connectabilityState) : this.localBoards.getConnectability(newBoardInfo.pid);
                ByteBuffer dynamicAttribute = ((BoardDelegateImpl)board).getDynamicPartsOfBoardAsByteArray(addSize4DynamicCharAttributes);
                newBoardInfo.boardContentBuffer = (byte[])(dynamicAttribute != null ? dynamicAttribute.array() : null);
            }
            if (newBoardInfo.boardContentBuffer == null) continue;
            resultBoardInfos.add(newBoardInfo);
        }
        return resultBoardInfos.toArray(new RemoteBoardInfoEx[0]);
    }

    @Override
    public boolean canUpdateBoards() throws RemoteException {
        return this.localBoards.canUpdateBoards();
    }

    @Override
    public RemoteBoardInfo[] getRemoteBoardInfo(RemoteBoardInfo[] knownInfo) throws RemoteException {
        RemoteBoardInfoEx[] listOfBoards = this._getRemoteBoardInfoEx(knownInfo, false);
        RemoteBoardInfo[] ret = new RemoteBoardInfo[listOfBoards.length];
        int i = 0;
        for (RemoteBoardInfoEx elem : listOfBoards) {
            ret[i++] = elem;
        }
        return ret;
    }

    @Override
    public RemoteBoardInfoEx[] getRemoteBoardInfoEx(RemoteBoardInfo[] knownInfo) throws RemoteException {
        return this._getRemoteBoardInfoEx(knownInfo, true);
    }

    @Override
    public byte[] getAdditionalInfo() {
        return this.additionaleInformation.getAsByteBuffer().array();
    }
}

