/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringListener;
import com.sap.jvm.inspector.jvmmon.MonitoringManager;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;

public class BoardDumper
implements MonitoringListener {
    private static int count;
    private static boolean changed;
    private static boolean detailed;
    private static boolean print;

    public static void main(String[] args) throws Exception {
        MonitoringManager manager = new MonitoringManager(1000);
        manager.addListener(new BoardDumper());
        manager.addLocal();
        manager.addRemote("localhost", 1099, new PasswordSupplier(){

            @Override
            public String get() throws IOException {
                System.out.print("Password: ");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                return br.readLine();
            }
        });
        while (true) {
            Thread.sleep(10000000L);
        }
    }

    @Override
    public void vmChanges(MonitoredVm[] newInfos, MonitoredVm[] changedInfos, MonitoredVm[] deletedInfos) {
        String name;
        int pid;
        BoardWrapper board;
        for (MonitoredVm info : newInfos) {
            board = info.getBoard();
            pid = board.getPid();
            name = board.getString("JAVA_MAINCLASS", "UNKNOWN MAIN CLASS");
            System.out.println("Found new board for pid " + pid + " and class " + name);
            System.out.println(info);
            System.out.println("Current board count " + ++count);
            long startTime = InspectorInfo.getCreationTimeOfProcess(pid) * 1000L;
            if (startTime != 0L) {
                System.out.println("Started at " + new Date(startTime));
            } else {
                System.out.println("Started at unknown time");
            }
            if (!detailed && !print) continue;
            board.print(detailed, System.out);
        }
        if (changed) {
            for (MonitoredVm info : changedInfos) {
                board = info.getBoard();
                pid = board.getPid();
                name = board.getString("JAVA_MAINCLASS", "UNKNOWN MAIN CLASS");
                System.out.println("Found changed board for pid " + pid + " and class " + name);
                System.out.println(info);
                if (!detailed && !print) continue;
                board.print(detailed, System.out);
            }
        }
        for (MonitoredVm info : deletedInfos) {
            board = info.getBoard();
            pid = board.getPid();
            name = board.getString("JAVA_MAINCLASS", "UNKNOWN MAIN CLASS");
            System.out.println("Found deleted board for pid " + pid + " and class " + name);
            System.out.println(info);
            System.out.println("Current board count " + --count);
            if (!detailed && !print) continue;
            board.print(detailed, System.out);
        }
    }
}

