/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.SignatureHelper;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.UTF8Util;
import com.sap.jvm.util.persistence.TypedPacketReader;
import com.sap.jvm.util.persistence.TypedPacketWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class ConnectableVm {
    private static final String DUMP = "dump";
    private final String vmId;

    protected ConnectableVm(String vmId) {
        this.vmId = vmId;
    }

    private LegacyMonitorOperationResult performLegacyMonitorOperation(String opName, boolean getRaw, String ... args) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            String opStr = opName + " " + Arrays.toString(args);
            TypedPacketWriter writer = connection.writer;
            TypedPacketReader reader = connection.reader;
            writer.startPacket(73);
            writer.writeInt64(0L);
            writer.writeBoolean(false);
            writer.writeString(opName);
            writer.writeInt32(args.length);
            for (int i = 0; i < args.length; ++i) {
                writer.writeString(args[i]);
            }
            writer.finishAndFlushPacket();
            while (reader.nextPacket() && reader.getType() != 1076) {
                LegacyMonitorOperationResult legacyMonitorOperationResult;
                if (reader.getType() != 1071) continue;
                long commandId = reader.readInt64();
                long timeStamp = reader.readInt64();
                String errorMessage = reader.readBoolean() ? null : reader.readString();
                boolean wasDumpOnly = reader.readBoolean();
                String resultOpName = reader.readString();
                int resultNrOfArgs = reader.readInt32();
                int resultActualNrOfArgs = reader.readInt32();
                String[] resultArgs = new String[resultActualNrOfArgs];
                for (int i = 0; i < resultActualNrOfArgs; ++i) {
                    resultArgs[i] = reader.readString();
                }
                ArrayList<byte[]> parts = new ArrayList<byte[]>();
                int len = 0;
                while (reader.readBoolean()) {
                    byte[] part = new byte[reader.readUint16()];
                    len += part.length;
                    reader.readBytes(part);
                    parts.add(part);
                }
                byte[] raw = new byte[len];
                int off = 0;
                for (byte[] part : parts) {
                    System.arraycopy(part, 0, raw, off, part.length);
                    off += part.length;
                }
                boolean wasSupported = reader.hasNext() ? reader.readBoolean() : true;
                Trace.get(this.getClass()).debug(() -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Got PROFILING_RESPONSE_GET_LEGACY_MONITORING_OPERATION_RESULT_TAG\n");
                    sb.append("VM Id           : " + this.vmId + "\n");
                    sb.append("Command Id      : " + commandId + "\n");
                    sb.append("Timestamp       : " + new Date(timeStamp) + "\n");
                    if (errorMessage != null) {
                        sb.append("Error message   : " + errorMessage + "\n");
                    }
                    sb.append("Was dump only   : " + wasDumpOnly + "\n");
                    sb.append("Was supported   : " + wasSupported + "\n");
                    sb.append("Operation name  : " + resultOpName + "\n");
                    sb.append("Nr of arguments : " + resultNrOfArgs + "\n");
                    for (String arg : resultArgs) {
                        sb.append("Argument        : " + arg + "\n");
                    }
                    sb.append("Result          :\n");
                    sb.append("<----- START -----\n");
                    if (getRaw) {
                        sb.append("Raw bytes of length " + raw.length + ":\n");
                        int toDump = Math.min(128, raw.length);
                        for (int i = 0; i < toDump; ++i) {
                            String hex = "0" + Integer.toHexString(raw[i] & 0xFF);
                            sb.append(hex.substring(hex.length() - 2));
                            if ((i & 0xF) == 15) {
                                sb.append("\n");
                                continue;
                            }
                            sb.append(' ');
                        }
                        if (toDump < raw.length) {
                            sb.append("...\n");
                        }
                    } else {
                        sb.append(UTF8Util.asString(raw) + "\n");
                    }
                    sb.append("----- END ----->\n");
                    return sb.toString();
                });
                if (!wasSupported) {
                    legacyMonitorOperationResult = new LegacyMonitorOperationResult(opStr, false, "Unsupported");
                    return legacyMonitorOperationResult;
                }
                legacyMonitorOperationResult = getRaw ? new LegacyMonitorOperationResult(opStr, errorMessage, raw) : new LegacyMonitorOperationResult(opStr, errorMessage, UTF8Util.asString(raw));
                return legacyMonitorOperationResult;
            }
            LegacyMonitorOperationResult legacyMonitorOperationResult = new LegacyMonitorOperationResult(opStr, false, "Unknown or no response");
            return legacyMonitorOperationResult;
        }
    }

    private void waitForEndOrTag(TypedPacketReader reader, int tag) {
        try {
            while (reader.nextPacket() && reader.getType() != 1076 && reader.getType() != tag) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract MonitoringConnection getMonitoringConnection() throws IOException;

    public TraceFlagSpec[] getTraceFlags() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(76);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            ArrayList<TraceFlagSpec> result = new ArrayList<TraceFlagSpec>();
            TypedPacketReader reader = connection.reader;
            while (reader.nextPacket() && reader.getType() != 1076) {
                String errorMessage;
                if (reader.getType() != 1074) continue;
                long commandId = reader.readInt64();
                long timeStamp = reader.readInt64();
                String string = errorMessage = reader.readBoolean() ? null : reader.readString();
                while (reader.readBoolean()) {
                    int id = reader.readInt32();
                    boolean enabled = reader.readBoolean();
                    String name = reader.readString();
                    String description = reader.readString();
                    result.add(new TraceFlagSpec(id, name, description, enabled));
                }
                Trace.get(this.getClass()).debug(() -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Got PROFILING_RESPONSE_GET_TRACE_FLAGS_RESULT_TAG\n");
                    sb.append("VM Id           : " + this.vmId + "\n");
                    sb.append("Command Id      : " + commandId + "\n");
                    sb.append("Timestamp       : " + new Date(timeStamp) + "\n");
                    if (errorMessage != null) {
                        sb.append("Error message   : " + errorMessage + "\n");
                    }
                    for (TraceFlagSpec flag : result) {
                        sb.append(flag.name + " (id=" + flag.id + ", desc=" + flag.description + ") : " + (flag.enabled ? "enabled" : "disabled") + "\n");
                    }
                    return sb.toString();
                });
                TraceFlagSpec[] traceFlagSpecArray = result.toArray(new TraceFlagSpec[result.size()]);
                return traceFlagSpecArray;
            }
            TraceFlagSpec[] traceFlagSpecArray = new TraceFlagSpec[]{};
            return traceFlagSpecArray;
        }
    }

    public TraceFlagSpec[] setTraceFlags(int[] ids) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(77);
            writer.writeInt64(0L);
            for (int id : ids) {
                writer.writeBoolean(true);
                writer.writeInt32(id);
            }
            writer.writeBoolean(false);
            writer.finishAndFlushPacket();
            ArrayList<TraceFlagSpec> result = new ArrayList<TraceFlagSpec>();
            TypedPacketReader reader = connection.reader;
            while (reader.nextPacket() && reader.getType() != 1076) {
                String errorMessage;
                if (reader.getType() != 1075) continue;
                long commandId = reader.readInt64();
                long timeStamp = reader.readInt64();
                String string = errorMessage = reader.readBoolean() ? null : reader.readString();
                while (reader.readBoolean()) {
                    int id = reader.readInt32();
                    boolean enabled = reader.readBoolean();
                    String name = reader.readString();
                    String description = reader.readString();
                    result.add(new TraceFlagSpec(id, name, description, enabled));
                }
                Trace.get(this.getClass()).debug(() -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Got PROFILING_RESPONSE_SET_TRACE_FLAGS_RESULT_TAG\n");
                    sb.append("VM Id           : " + this.vmId + "\n");
                    sb.append("Command Id      : " + commandId + "\n");
                    sb.append("Timestamp       : " + new Date(timeStamp) + "\n");
                    if (errorMessage != null) {
                        sb.append("Error message   : " + errorMessage + "\n");
                    }
                    for (TraceFlagSpec flag : result) {
                        sb.append(flag.name + " (id=" + flag.id + ", desc=" + flag.description + ") : " + (flag.enabled ? "enabled" : "disabled") + "\n");
                    }
                    return sb.toString();
                });
                TraceFlagSpec[] traceFlagSpecArray = result.toArray(new TraceFlagSpec[result.size()]);
                return traceFlagSpecArray;
            }
            TraceFlagSpec[] traceFlagSpecArray = new TraceFlagSpec[]{};
            return traceFlagSpecArray;
        }
    }

    public void setDefaultDebuggingPortRange(int min, int max) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(83);
            writer.writeInt64(0L);
            writer.writeInt32(min);
            writer.writeInt32(max);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1082);
        }
    }

    public void exitVm(int exitCode, ExitType type) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(78);
            writer.writeInt64(0L);
            writer.writeInt32(exitCode);
            writer.writeBoolean(type != ExitType.JAVA);
            writer.writeBoolean(type == ExitType.FORCED_OS || type == ExitType.JAVA_HALT);
            writer.finishPacket();
            try {
                writer.sendFlushPacket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.waitForEndOrTag(connection.reader, 1078);
        }
    }

    public void crashVm() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(79);
            writer.writeInt64(0L);
            writer.finishPacket();
            try {
                writer.sendFlushPacket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.waitForEndOrTag(connection.reader, 1079);
        }
    }

    public LegacyMonitorOperationResult getStackTrace(boolean dumpOnly, boolean detailed, String info) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_STACK_TRACE, detailed ? "-l" : "-s", info, dumpOnly ? DUMP : null);
    }

    public void dumpHeap(boolean forceGc, String info) throws IOException {
        this.performLegacyMonitorOperation(MonitorOperation.DUMP_HEAP, null, forceGc ? "-live" : "-all", info);
    }

    public void forceGc(boolean maxCompaction) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(26);
            writer.writeInt64(0L);
            writer.writeBoolean(maxCompaction);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1024);
        }
    }

    public LegacyMonitorOperationResult getGcHistory(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_GC_HISTORY, dumpOnly ? DUMP : null);
    }

    public byte[] retrieveGcHistory() throws IOException {
        return this.performLegacyMonitorOperation((String)MonitorOperation.RETRIEVE_COMPLETE_GC_HISTORY.getOperationID(), (boolean)true, (String[])new String[0]).rawData;
    }

    public LegacyMonitorOperationResult getClassStatistic(boolean dumpOnly, boolean detailed) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_CLASS_STATISTIC, detailed ? "true" : "", dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getDllInfo(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_DLL_INFO, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getCodeBlobs(boolean dumpOnly, String filter, boolean detailed) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_CODE_BLOBS, filter == null || filter.length() == 0 ? "*" : filter, detailed ? "true" : "", dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getHsInfo(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_HS_ERROR_INFO, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getSymbolInfo(boolean dumpOnly, int maxToDump) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_SYMBOL_INFO, maxToDump <= 0 ? null : Integer.toString(maxToDump), dumpOnly ? DUMP : null);
    }

    public void dumpSafepointState() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(87);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1085);
        }
    }

    public LegacyMonitorOperationResult getFlightRecorder(boolean dumpOnly, int maxToDump) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_FLIGHT_RECORDER, maxToDump <= 0 ? null : Integer.toString(maxToDump), dumpOnly ? DUMP : null);
    }

    public void openDebugPort(boolean suspended, boolean localOnly) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(84);
            writer.writeInt64(0L);
            writer.writeBoolean(localOnly);
            writer.writeBoolean(suspended);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1083);
        }
    }

    public void closeDebugPort() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(85);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1084);
        }
    }

    public LegacyMonitorOperationResult performLegacyMonitorOperation(MonitorOperation op, String ... args) throws IOException {
        return this.performLegacyMonitorOperation(op.getOperationID(), false, args);
    }

    public Map<String, String> getVirtualizationInfo() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(81);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            HashMap<String, String> result = new HashMap<String, String>();
            TypedPacketReader reader = connection.reader;
            while (reader.nextPacket() && reader.getType() != 1076) {
                if (reader.getType() != 1077) continue;
                long commandId = reader.readInt64();
                long timeStamp = reader.readInt64();
                String errorMessage = reader.readBoolean() ? null : reader.readString();
                int nrOfEntries = reader.readInt32();
                for (int i = 0; i < nrOfEntries; ++i) {
                    String key = reader.readString();
                    String value = reader.readString();
                    result.put(key, value);
                }
                Trace.get(this.getClass()).debug(() -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Got PROFILING_RESPONSE_GET_VIRTUALIZATION_INFO_TAG\n");
                    sb.append("VM Id           : " + this.vmId + "\n");
                    sb.append("Command Id      : " + commandId + "\n");
                    sb.append("Timestamp       : " + new Date(timeStamp) + "\n");
                    if (errorMessage != null) {
                        sb.append("Error message   : " + errorMessage + "\n");
                    }
                    for (String key : result.keySet()) {
                        sb.append(key + " : " + (String)result.get(key) + "\n");
                    }
                    return sb.toString();
                });
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
    }

    public void stopCommandLineProfiling() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(75);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1073);
        }
    }

    public void setCoreSizeLimitToMax() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(82);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1081);
        }
    }

    public void changeCommandLineFlags(String newFlags) throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            writer.startPacket(74);
            writer.writeInt64(0L);
            writer.writeString(newFlags);
            writer.finishAndFlushPacket();
            this.waitForEndOrTag(connection.reader, 1072);
        }
    }

    public LegacyMonitorOperationResult deoptimizeAllMethods() throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.DEOPTIMIZE_ALL, new String[0]);
    }

    public LegacyMonitorOperationResult deoptimizeMethod(String filter) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.DEOPTIMIZE_METHOD, filter);
    }

    public LegacyMonitorOperationResult forceCompile(String method, boolean blocking, boolean internalSig) throws IOException {
        String rawMethod = method;
        if (!internalSig) {
            int sigStart = method.indexOf(40);
            if (sigStart <= 0) {
                throw new IOException("No signature found in method specification '" + method + "'");
            }
            rawMethod = method.substring(0, sigStart) + SignatureHelper.toInternalSignature(method.substring(sigStart));
        }
        return this.performLegacyMonitorOperation(MonitorOperation.FORCE_COMPILE, rawMethod, blocking ? "!" : "");
    }

    public LegacyMonitorOperationResult forceOsrCompile(String method, int bci) throws IOException {
        int sigStart = method.indexOf(40);
        if (sigStart <= 0) {
            throw new IOException("No signature found in method specification '" + method + "'");
        }
        String rawMethod = method.substring(0, sigStart) + SignatureHelper.toInternalSignature(method.substring(sigStart));
        return this.performLegacyMonitorOperation(MonitorOperation.FORCE_OSR_COMPILE, rawMethod, "" + bci);
    }

    public LegacyMonitorOperationResult getClassLoaderDataGraph(boolean dumpOnly, boolean includeLoaders, boolean includeClasses) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_CLASS_DATA_GRAPH_INFO, includeClasses ? "classes" : (includeLoaders ? "loaders" : ""), dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getCompressedClassSpaceDetails(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_CCS_INTERNALS, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getJITInformation(boolean dumpOnly, String function, String detail, String granule) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_JIT_INFO, dumpOnly ? "DUMP" + (function == null ? "" : function) : function, detail, granule);
    }

    public LegacyMonitorOperationResult getMallocStatistic(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_MALLOCSTAT, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getMallocStatisticInternals(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_MALLOCSTAT_INTERNALS, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getMemoryHistory(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_MEMHIST, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getMetaspaceMap(String type, boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_METASPACE_MAP, type, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getMetaspaceStat(String type, boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_METASPACE_STAT, type, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getSignalHandlers(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_SIGNAL_HANDLERS, dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getSystemInformation(boolean dumpOnly, boolean full) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_SYSTEM_INFORMATION, full ? "full" : "brief", dumpOnly ? DUMP : null);
    }

    public LegacyMonitorOperationResult getSystemProperties(boolean dumpOnly) throws IOException {
        return this.performLegacyMonitorOperation(MonitorOperation.GET_SYSTEM_PROPERTIES, dumpOnly ? DUMP : null);
    }

    public boolean resetMallocStatistic() throws IOException {
        return this.performLegacyMonitorOperation((MonitorOperation)MonitorOperation.MALLOCSTAT_RESET, (String[])new String[0]).wasSupported;
    }

    public boolean startMallocStatistic() throws IOException {
        return this.performLegacyMonitorOperation((MonitorOperation)MonitorOperation.MALLOCSTAT_STARTCAP, (String[])new String[0]).wasSupported;
    }

    public boolean stopMallocStatistic() throws IOException {
        return this.performLegacyMonitorOperation((MonitorOperation)MonitorOperation.MALLOCSTAT_STOPCAP, (String[])new String[0]).wasSupported;
    }

    public Map<String, Long> getClusterMemoryInformation() throws IOException {
        try (MonitoringConnection connection = this.getMonitoringConnection();){
            TypedPacketWriter writer = connection.writer;
            TypedPacketReader reader = connection.reader;
            writer.startPacket(88);
            writer.writeInt64(0L);
            writer.finishAndFlushPacket();
            HashMap<String, Long> result = new HashMap<String, Long>();
            while (reader.nextPacket() && reader.getType() != 1076) {
                if (reader.getType() != 1086) continue;
                long commandId = reader.readInt64();
                long timeStamp = reader.readInt64();
                String errorMessage = reader.readBoolean() ? null : reader.readString();
                int nrOfEntries = reader.readInt32();
                for (int i = 0; i < nrOfEntries; ++i) {
                    String key = reader.readString();
                    Long value = reader.readInt64();
                    result.put(key, value);
                }
                Trace.get(this.getClass()).debug(() -> {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Got PROFILING_RESPONSE_GET_CLUSTER_MEMORY_TAG\n");
                    sb.append("VM Id           : " + this.vmId + "\n");
                    sb.append("Command Id      : " + commandId + "\n");
                    sb.append("Timestamp       : " + new Date(timeStamp) + "\n");
                    if (errorMessage != null) {
                        sb.append("Error message   : " + errorMessage + "\n");
                    }
                    for (String key : result.keySet()) {
                        sb.append(key + " : " + result.get(key) + "\n");
                    }
                    return sb.toString();
                });
                HashMap<String, Long> hashMap = result;
                return hashMap;
            }
            HashMap<String, Long> hashMap = result;
            return hashMap;
        }
    }

    public static class TraceFlagSpec {
        public final int id;
        public final String name;
        public final String description;
        public final boolean enabled;

        public TraceFlagSpec(int id, String name, String description, boolean enabled) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.enabled = enabled;
        }

        public String toString() {
            return this.name;
        }

        public static Comparator<TraceFlagSpec> getNameComparator() {
            return new Comparator<TraceFlagSpec>(){

                @Override
                public int compare(TraceFlagSpec o1, TraceFlagSpec o2) {
                    return o1.name.compareTo(o2.name);
                }
            };
        }
    }

    public static enum ExitType {
        FORCED_OS,
        OS,
        JAVA,
        JAVA_HALT;

    }

    public static class LegacyMonitorOperationResult {
        public final String operation;
        public final boolean wasSupported;
        public final String errorMessage;
        public final String data;
        public final byte[] rawData;

        private LegacyMonitorOperationResult(String operation, String errorMessage, String data) {
            this.operation = operation;
            this.wasSupported = true;
            this.errorMessage = errorMessage;
            this.data = data;
            this.rawData = null;
        }

        private LegacyMonitorOperationResult(String operation, String errorMessage, byte[] rawData) {
            this.operation = operation;
            this.wasSupported = true;
            this.errorMessage = errorMessage;
            this.data = null;
            this.rawData = rawData;
        }

        private LegacyMonitorOperationResult(String operation, boolean wasSupported, String errorMessage) {
            this.operation = operation;
            this.wasSupported = wasSupported;
            this.errorMessage = errorMessage;
            this.data = null;
            this.rawData = null;
        }
    }

    protected static class MonitoringConnection
    implements AutoCloseable {
        public final TypedPacketReader reader;
        public final TypedPacketWriter writer;
        public final SocketAdapter adapter;

        public MonitoringConnection(SocketAdapter adapter) throws IOException {
            this.adapter = adapter;
            this.writer = new TypedPacketWriter(adapter.getOutputStream());
            this.reader = TypedPacketReader.forProfilingConnection(adapter.getInputStream(), this.writer, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() {
            try {
                this.writer.startPacket(0);
                this.writer.writeInt64(0L);
                this.writer.finishAndFlushPacket();
                while (this.reader.nextPacket()) {
                    if (this.reader.getType() != 1023) continue;
                    ** GOTO lbl60
                }
                ** GOTO lbl87
            }
            catch (IOException var1_7) {
                try {
                    this.writer.close();
                    return;
                }
                catch (IOException var1_9) {
                    try {
                        this.reader.close();
                        return;
                    }
                    finally {
                        try {
                            this.adapter.close();
                        }
                        catch (IOException var1_10) {}
                    }
                }
                finally {
                    try {
                        this.reader.close();
                    }
                    catch (Throwable var18_27) {
                        try {
                            this.adapter.close();
                            throw var18_27;
                        }
                        catch (IOException var19_28) {}
                    }
                    try {
                        this.adapter.close();
                    }
                    catch (IOException var1_8) {}
                }
            }
            catch (Throwable var26_35) {
                try {
                    this.writer.close();
                    throw var26_35;
                }
                catch (IOException var27_37) {
                    try {
                        this.reader.close();
                        throw var26_35;
                    }
                    finally {
                        try {
                            this.adapter.close();
                        }
                        catch (IOException var27_38) {}
                    }
                }
                finally {
                    try {
                        this.reader.close();
                    }
                    catch (Throwable var28_39) {
                        try {
                            this.adapter.close();
                            throw var28_39;
                        }
                        catch (IOException var29_40) {}
                    }
lbl60:
                    // 1 sources

                    try {
                        this.writer.close();
                        return;
                    }
                    catch (IOException var1_2) {
                        try {
                            this.reader.close();
                            return;
                        }
                        finally {
                            try {
                                this.adapter.close();
                            }
                            catch (IOException var1_3) {}
                        }
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (Throwable var2_11) {
                            try {
                                this.adapter.close();
                                throw var2_11;
                            }
                            catch (IOException var3_12) {}
                        }
                        try {
                            this.adapter.close();
                        }
                        catch (IOException var1_1) {}
                    }
lbl87:
                    // 1 sources

                    try {
                        this.writer.close();
                        return;
                    }
                    catch (IOException var1_5) {
                        try {
                            this.reader.close();
                            return;
                        }
                        finally {
                            try {
                                this.adapter.close();
                            }
                            catch (IOException var1_6) {}
                        }
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (Throwable var10_19) {
                            try {
                                this.adapter.close();
                                throw var10_19;
                            }
                            catch (IOException var11_20) {}
                        }
                        try {
                            this.adapter.close();
                        }
                        catch (IOException var1_4) {}
                    }
                    try {
                        this.adapter.close();
                    }
                    catch (IOException var27_36) {}
                }
            }
        }
    }
}

