/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.impl.monitor.remoteCluster.VmImpl;
import com.sap.jvm.inspector.cluster.ProfilingCluster;
import com.sap.jvm.internal.InternalAPIFactory;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.MonitorOperation;
import com.sap.jvm.monitor.vm.PortRange;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.monitor.vm.VmMemoryInfo;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.monitor.vm.VmTraceFlagsSet;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import com.sap.jvm.util.persistence.TypedPacketReader;
import com.sap.jvm.util.persistence.TypedPacketWriter;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.Deflater;

public class ControllerFallbacks {
    private static final String DUMP = "dump";
    private static final Tracer trc = Trace.get(ControllerFallbacks.class);

    private static void simulateProfilingServerLoopForMonitoring(TypedPacketReader reader, TypedPacketWriter writer, Vm vm, VmInternals vmInternals) throws IOException {
        block19: while (reader.nextPacket()) {
            trc.debug(() -> "Got packet type " + reader.getType() + " in profiling server loop simulation");
            switch (reader.getType()) {
                case 36: {
                    continue block19;
                }
                case 0: {
                    ControllerFallbacks.performStopCommand(writer, vm);
                    continue block19;
                }
                case 73: {
                    ControllerFallbacks.performLegacyMonitoringOperation(reader, writer, vm);
                    continue block19;
                }
                case 76: {
                    ControllerFallbacks.getTraceFlags(reader, writer, vm);
                    continue block19;
                }
                case 77: {
                    ControllerFallbacks.setTraceFlags(reader, writer, vm);
                    continue block19;
                }
                case 83: {
                    ControllerFallbacks.setDefaultDebuggingPortRange(reader, writer, vm);
                    continue block19;
                }
                case 78: {
                    ControllerFallbacks.exitVm(reader, writer, false, vm);
                    continue block19;
                }
                case 79: {
                    ControllerFallbacks.exitVm(reader, writer, true, vm);
                    continue block19;
                }
                case 26: {
                    ControllerFallbacks.forceGc(reader, writer, vm);
                    continue block19;
                }
                case 87: {
                    ControllerFallbacks.dumpSafepointState(reader, writer, vm);
                    continue block19;
                }
                case 84: {
                    ControllerFallbacks.openDebuggingPort(reader, writer, vm);
                    continue block19;
                }
                case 85: {
                    ControllerFallbacks.closeDebuggingPort(reader, writer, vm);
                    continue block19;
                }
                case 81: {
                    ControllerFallbacks.getVirtualizationInfo(reader, writer, vmInternals);
                    continue block19;
                }
                case 75: {
                    ControllerFallbacks.stopCommandLineProfiling(reader, writer, vm);
                    continue block19;
                }
                case 82: {
                    ControllerFallbacks.setCoreSizeLimitToMax(reader, writer, vm);
                    continue block19;
                }
                case 74: {
                    ControllerFallbacks.changeCommandLineFlags(reader, writer, vm);
                    continue block19;
                }
                case 88: {
                    ControllerFallbacks.getClusterMemoryInformation(reader, writer, vm);
                    continue block19;
                }
            }
            writer.startPacket(1076);
            writer.writeInt64(0L);
            writer.writeInt64(System.currentTimeMillis());
            writer.writeBoolean(true);
            writer.writeInt32(reader.getType());
            writer.finishAndFlushPacket();
        }
    }

    private static VmId getId(Vm vm) {
        if (!(vm instanceof VmImpl)) {
            int pid;
            try {
                pid = vm.getStateInfo().getPid();
            }
            catch (InvalidVmException e) {
                pid = -1;
            }
            try {
                ClusterInfo[] clusters;
                for (ClusterInfo cluster : clusters = ProfilingCluster.getClusterInfo()) {
                    int clusterTypeId = ClusterType.getConfigurationIndex(cluster.getType());
                    int id = -1;
                    int index = -1;
                    if (cluster.getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                        if (((ProcessClusterInfo)cluster).getProcessId() == pid) {
                            id = pid;
                            index = 0;
                        }
                    } else {
                        if (cluster.getType() != ClusterType.CLUSTER_TYPE_INSTANCE) continue;
                        InstanceClusterInfo ici = (InstanceClusterInfo)cluster;
                        for (Vm clusterVm : ProfilingCluster.getVms(ici.getInstanceId())) {
                            if (clusterVm.getStateInfo().getPid() != pid) continue;
                            id = ici.getInstanceId();
                            index = vm.getVmIndex();
                        }
                    }
                    if (id < 0) continue;
                    return new VmId(clusterTypeId, id, index);
                }
            }
            catch (InvalidVmException invalidVmException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void performStopCommand(TypedPacketWriter writer, Vm vm) throws IOException {
        writer.startPacket(1023);
        writer.writeInt64(0L);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.finishAndFlushPacket();
    }

    private static void performLegacyMonitoringOperation(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long id = reader.readInt64();
        boolean dumpOnly = reader.readBoolean();
        String opName = reader.readString();
        int argc = reader.readInt32();
        String[] args = new String[3];
        for (int i = 0; i < argc; ++i) {
            args[i] = reader.readString();
        }
        String errorMessage = null;
        boolean wasSupported = true;
        List<String> lines = null;
        byte[] raw = null;
        trc.debug(() -> "Performing operation '" + opName + "' with arguments " + Arrays.toString(args) + ", dumpOnly=" + dumpOnly);
        boolean handled = false;
        try {
            if (MonitorOperation.GET_STACK_TRACE.getOperationID().equals(opName)) {
                if ("-l".equals(args[0]) && (dumpOnly || DUMP.equals(args[2]))) {
                    vm.printStackDump(args[1]);
                    handled = true;
                } else if (dumpOnly) {
                    args[2] = DUMP;
                }
            } else if (MonitorOperation.GET_CLASS_STATISTIC.getOperationID().equals(opName)) {
                if (dumpOnly || DUMP.equals(args[1])) {
                    if ("true".equals(args[0])) {
                        vm.dumpDetailedClassStatistic();
                    } else {
                        vm.dumpClassStatistic();
                    }
                    handled = true;
                }
            } else if (MonitorOperation.GET_CODE_BLOBS.getOperationID().equals(opName)) {
                if (dumpOnly || DUMP.equals(args[2])) {
                    vm.dumpCodeblobs(args[0], "true".equals(args[1]));
                    handled = true;
                }
            } else if (MonitorOperation.GET_HS_ERROR_INFO.getOperationID().equals(opName)) {
                if (dumpOnly || DUMP.equals(args[0])) {
                    vm.dumpHsErrorInfo();
                    handled = true;
                }
            } else if (MonitorOperation.GET_DLL_INFO.getOperationID().equals(opName)) {
                if (dumpOnly || DUMP.equals(args[0])) {
                    vm.dumpDllInformation();
                    handled = true;
                }
            } else if (MonitorOperation.GET_SYMBOL_INFO.getOperationID().equals(opName)) {
                if (args[0] == null && (dumpOnly || DUMP.equals(args[1]))) {
                    vm.dumpSymbolInfo();
                    handled = true;
                } else if (dumpOnly) {
                    args[1] = DUMP;
                }
            } else if (MonitorOperation.GET_GC_HISTORY.getOperationID().equals(opName)) {
                if (dumpOnly || DUMP.equals(args[0])) {
                    vm.dumpGcHistory();
                    handled = true;
                }
            } else if (MonitorOperation.RETRIEVE_COMPLETE_GC_HISTORY.getOperationID().equals(opName)) {
                raw = vm.retrieveCompleteGcHistory();
                handled = true;
            } else if (MonitorOperation.DUMP_HEAP.getOperationID().equals(opName) && args[0] == null && "-live".equals(args[1])) {
                vm.dumpHeap(args[2]);
                handled = true;
            }
            if (dumpOnly) {
                if (MonitorOperation.GET_FLIGHT_RECORDER.getOperationID().equals(opName) || MonitorOperation.GET_MALLOCSTAT.getOperationID().equals(opName) || MonitorOperation.GET_MALLOCSTAT_INTERNALS.getOperationID().equals(opName) || MonitorOperation.GET_CCS_INTERNALS.getOperationID().equals(opName) || MonitorOperation.GET_SIGNAL_HANDLERS.getOperationID().equals(opName) || MonitorOperation.GET_SYSTEM_PROPERTIES.getOperationID().equals(opName) || MonitorOperation.GET_MEMHIST.getOperationID().equals(opName)) {
                    args[0] = DUMP;
                } else if (MonitorOperation.GET_SYSTEM_INFORMATION.getOperationID().equals(opName) || MonitorOperation.GET_CLASS_DATA_GRAPH_INFO.getOperationID().equals(opName)) {
                    args[1] = DUMP;
                }
            }
            if (!handled) {
                MonitorOperation op = MonitorOperation.getByOperationID(opName);
                if (op == null) {
                    wasSupported = false;
                } else {
                    lines = vm.performOperation(op, args);
                }
            }
        }
        catch (Throwable e) {
            errorMessage = e.getClass() + ": " + e.getMessage();
        }
        writer.startPacket(1071);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        if (errorMessage == null) {
            writer.writeBoolean(true);
        } else {
            writer.writeBoolean(false);
            writer.writeString(errorMessage);
        }
        writer.writeBoolean(dumpOnly);
        writer.writeString(opName);
        writer.writeInt32(args.length);
        writer.writeInt32(args.length);
        for (String arg : args) {
            writer.writeString(arg);
        }
        if (raw != null) {
            int len;
            for (int off = 0; off < raw.length; off += len) {
                writer.writeBoolean(true);
                len = Math.min(30000, raw.length - off);
                writer.writeUint16((char)len);
                writer.writeBytes(raw, off, len);
            }
        } else if (lines != null) {
            for (String line : lines) {
                writer.writeBoolean(true);
                writer.writeString(line + "\n");
            }
        }
        writer.writeBoolean(false);
        writer.writeBoolean(wasSupported);
        writer.finishAndFlushPacket();
    }

    private static void getTraceFlags(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long id = reader.readInt64();
        String errorMessage = null;
        VmTraceFlagsSet flags = new VmTraceFlagsSet();
        try {
            flags = vm.getTraceFlags();
        }
        catch (Throwable e) {
            errorMessage = e.getClass() + ": " + e.getMessage();
        }
        writer.startPacket(1074);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(errorMessage == null);
        if (errorMessage != null) {
            writer.writeString(errorMessage);
        }
        for (VmTraceFlag flag : VmTraceFlag.values()) {
            writer.writeBoolean(true);
            writer.writeInt32(flag.getNumber());
            writer.writeBoolean(flags.isSet(flag));
            writer.writeString(flag.name());
            writer.writeString(flag.getDescription());
        }
        writer.writeBoolean(false);
        writer.finishAndFlushPacket();
    }

    private static void setTraceFlags(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long id = reader.readInt64();
        VmTraceFlagsSet flags = new VmTraceFlagsSet();
        HashSet<Integer> ids = new HashSet<Integer>();
        String errorMessage = null;
        long t1 = System.currentTimeMillis();
        while (reader.readBoolean()) {
            ids.add(reader.readInt32());
        }
        for (VmTraceFlag flag : VmTraceFlag.values()) {
            if (!ids.contains(flag.getNumber())) continue;
            flags.setFlag(flag);
        }
        VmTraceFlagsSet newFlags = flags;
        do {
            try {
                vm.setTraceFlags(flags);
                newFlags = vm.getTraceFlags();
                boolean isUpToDate = true;
                for (VmTraceFlag flag : VmTraceFlag.values()) {
                    if (flags.isSet(flag) == newFlags.isSet(flag)) continue;
                    Thread.sleep(100L);
                    isUpToDate = false;
                    break;
                }
                if (!isUpToDate) continue;
                break;
            }
            catch (Throwable e) {
                errorMessage = e.getClass() + ": " + e.getMessage();
            }
        } while (System.currentTimeMillis() - t1 < 4000L);
        writer.startPacket(1075);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(errorMessage == null);
        if (errorMessage != null) {
            writer.writeString(errorMessage);
        }
        for (VmTraceFlag flag : VmTraceFlag.values()) {
            writer.writeBoolean(true);
            writer.writeInt32(flag.getNumber());
            writer.writeBoolean(newFlags.isSet(flag));
            writer.writeString(flag.name());
            writer.writeString(flag.getDescription());
        }
        writer.writeBoolean(false);
        writer.finishAndFlushPacket();
    }

    private static void setDefaultDebuggingPortRange(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        int min = reader.readInt32();
        int max = reader.readInt32();
        try {
            vm.setDefaultDebugPortRange(new PortRange(min, max));
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
        }
        writer.startPacket(1082);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.writeInt32(min);
        writer.writeInt32(max);
        writer.finishAndFlushPacket();
    }

    private static void exitVm(TypedPacketReader reader, TypedPacketWriter writer, boolean isCrash, Vm vm) throws IOException {
        int exitCode;
        long id = reader.readInt64();
        if (isCrash) {
            exitCode = 1;
            writer.startPacket(1079);
            writer.writeInt64(id);
            writer.writeInt64(System.currentTimeMillis());
            writer.writeBoolean(true);
            writer.finishAndFlushPacket();
        } else {
            exitCode = reader.readInt32();
            boolean useOsExit = reader.readBoolean();
            boolean force = reader.readBoolean();
            writer.startPacket(1078);
            writer.writeInt64(id);
            writer.writeInt64(System.currentTimeMillis());
            writer.writeBoolean(true);
            writer.writeInt32(exitCode);
            writer.writeBoolean(useOsExit);
            writer.writeBoolean(force);
            writer.finishAndFlushPacket();
        }
        int pid = -1;
        try {
            pid = vm.getStateInfo().getPid();
        }
        catch (InvalidVmException e) {
            trc.debug((Throwable)e, "Exiting VM failed since VM is already dead");
        }
        int pidL = pid;
        try {
            long t2;
            long t = System.currentTimeMillis() + 10000L;
            do {
                t2 = System.currentTimeMillis();
                vm.exit(exitCode);
                Thread.sleep(1000L);
            } while (t2 < t && vm.isValid());
            if (t2 >= t) {
                trc.debug(() -> "Exiting VM with pid " + pidL + " failed with timeout");
            } else {
                trc.debug(() -> "Exiting VM with pid " + pidL + " worked");
            }
        }
        catch (InvalidVmException e) {
            trc.debug(() -> "Exiting VM with pid " + pidL + " worked");
        }
        catch (InterruptedException e) {
            trc.debug((Throwable)e, "Caught InterruptedException");
        }
    }

    private static void forceGc(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        reader.readInt64();
        boolean maxCompaction = reader.readBoolean();
        try {
            if (maxCompaction) {
                vm.forceMaxGc();
            } else {
                vm.forceGc();
            }
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
        }
        writer.startPacket(1024);
        writer.writeInt64(0L);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.writeBoolean(maxCompaction);
        writer.finishAndFlushPacket();
    }

    private static void dumpSafepointState(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long id = reader.readInt64();
        try {
            vm.dumpSafepointState();
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
        }
        writer.startPacket(1085);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.finishAndFlushPacket();
    }

    private static void openDebuggingPort(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        boolean localOnly = reader.readBoolean();
        boolean suspended = reader.readBoolean();
        SuspendPolicy policy = suspended ? SuspendPolicy.SUSPEND_ALL : SuspendPolicy.SUSPEND_NONE;
        try {
            if (localOnly) {
                vm.startLocalDebug(policy);
            } else {
                vm.startDebug(policy);
            }
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
        }
        writer.startPacket(1083);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.writeBoolean(localOnly);
        writer.writeBoolean(suspended);
        writer.finishAndFlushPacket();
    }

    private static void closeDebuggingPort(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        try {
            vm.stopDebug();
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
        }
        writer.startPacket(1084);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.finishAndFlushPacket();
    }

    private static void getVirtualizationInfo(TypedPacketReader reader, TypedPacketWriter writer, VmInternals vmInternals) throws IOException {
        long id = reader.readInt64();
        writer.startPacket(1077);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        if (vmInternals != null) {
            Properties props = vmInternals.getVirtualizationInfo();
            writer.writeInt32(props.size());
            for (Object key : props.keySet()) {
                writer.writeString(key.toString());
                writer.writeString(props.getProperty((String)key));
            }
        } else {
            writer.writeInt32(0);
        }
        writer.finishAndFlushPacket();
    }

    private static void stopCommandLineProfiling(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        VmId id = ControllerFallbacks.getId(vm);
        if (id != null) {
            try {
                InternalAPIFactory.getVm(ClusterType.getTypeForIndex(id.clusterTypeId), id.id, id.index).stopCommandLineProfiling();
            }
            catch (InvalidVmException e) {
                e.printStackTrace();
            }
        }
        writer.startPacket(1073);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.finishAndFlushPacket();
    }

    private static void setCoreSizeLimitToMax(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        VmId id = ControllerFallbacks.getId(vm);
        if (id != null) {
            try {
                InternalAPIFactory.getVm(ClusterType.getTypeForIndex(id.clusterTypeId), id.id, id.index).setCoreSizeToMax();
            }
            catch (InvalidVmException e) {
                e.printStackTrace();
            }
        }
        writer.startPacket(1081);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.finishAndFlushPacket();
    }

    private static void changeCommandLineFlags(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long commandId = reader.readInt64();
        String flags = reader.readString();
        VmId id = ControllerFallbacks.getId(vm);
        if (id != null) {
            try {
                InternalAPIFactory.getVm(ClusterType.getTypeForIndex(id.clusterTypeId), id.id, id.index).changeCommandLineFlags(flags);
            }
            catch (InvalidVmException e) {
                e.printStackTrace();
            }
        } else {
            trc.warn("Cannot change command line flags via legacy rmi jvmmond connection.");
        }
        writer.startPacket(1072);
        writer.writeInt64(commandId);
        writer.writeInt64(System.currentTimeMillis());
        writer.writeBoolean(true);
        writer.writeString(flags);
        writer.finishAndFlushPacket();
    }

    private static void getClusterMemoryInformation(TypedPacketReader reader, TypedPacketWriter writer, Vm vm) throws IOException {
        long id = reader.readInt64();
        writer.startPacket(1086);
        writer.writeInt64(id);
        writer.writeInt64(System.currentTimeMillis());
        try {
            VmMemoryInfo info = vm.getMemoryInfo();
            writer.writeBoolean(true);
            writer.writeInt32(4);
            writer.writeString("SHARED_POOL_SIZE");
            writer.writeInt64(info.getSharedPoolSize());
            writer.writeString("SHARED_MEMORY_CONSUMPTION");
            writer.writeInt64(info.getSharedMemoryConsumption());
            writer.writeString("SHARED_MEMORY_ALLOCATION");
            writer.writeInt64(info.getSharedMemoryAllocation());
            writer.writeString("SHARED_MEMORY_PEAK");
            writer.writeInt64(info.getSharedDataPeakMemoryConsumption());
        }
        catch (InvalidVmException e) {
            e.printStackTrace();
            writer.writeBoolean(false);
            writer.writeString("Caught Exception retrieving VM memory information.");
            writer.writeInt32(0);
        }
        writer.finishAndFlushPacket();
    }

    private static int startDebugging(Vm vm, boolean suspendAll) throws IOException {
        if (vm == null) {
            throw new IOException("Could not connect to VM");
        }
        try {
            if (vm.getDebugInfo().getDebugState() == DebugState.STATE_UNKNOWN) {
                throw new IOException("Debugging state unknown");
            }
            if (vm.getDebugInfo().getDebugState() != DebugState.STATE_NOT_ACTIVE) {
                throw new IOException("Debugging already active");
            }
            vm.startDebug(suspendAll ? SuspendPolicy.SUSPEND_ALL : SuspendPolicy.SUSPEND_NONE);
            int counter = 0;
            while (vm.getDebugInfo().getDebugState() != DebugState.STATE_WAIT_FOR_DEBUGGER && counter++ < 10) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
            VmDebugInfo info = vm.getDebugInfo();
            if (info.getDebugState() != DebugState.STATE_WAIT_FOR_DEBUGGER) {
                vm.stopDebug();
                throw new IOException("Could not switch VM to debugging mode");
            }
            if (info.getDebugPort() <= 0) {
                throw new IOException("Debugging already closed");
            }
            return info.getDebugPort();
        }
        catch (InvalidVmException e) {
            throw new IOException("Could not connect to VM");
        }
    }

    public static void simulateProfilingServerForMonitoring(SocketAdapter adapter, final Vm vm, final VmInternals vmInternals) throws IOException {
        adapter.getOutputStream().write(new byte[]{0, 1, 0, 6, 0, 1, 0, 6, 0, 0});
        final TypedPacketReader reader = new TypedPacketReader(new ContinuedPacketReader(new BufferedInputStream(adapter.getInputStream()), false));
        final TypedPacketWriter writer = new TypedPacketWriter(new BufferedOutputStream(new FilterOutputStream(adapter.getOutputStream()){

            @Override
            public void write(int b) throws IOException {
                byte[] buf = new byte[]{(byte)b};
                this.write(buf);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                int outLen;
                Deflater def = new Deflater(0);
                def.setInput(b, off, len);
                byte[] outBuf = new byte[512];
                while (!def.needsInput()) {
                    outLen = def.deflate(outBuf);
                    this.out.write(outBuf, 0, outLen);
                }
                def.finish();
                while (!def.finished()) {
                    outLen = def.deflate(outBuf);
                    this.out.write(outBuf, 0, outLen);
                }
            }
        }));
        ThreadRunner.run(new Runnable(){

            @Override
            public void run() {
                trc.debug("Starting new profiling server loop");
                try {
                    try {
                        ControllerFallbacks.simulateProfilingServerLoopForMonitoring(reader, writer, vm, vmInternals);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        finally {
                            writer.close();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static SocketAdapter getDebuggingConnection(Vm vm, String host, boolean suspendAll) throws IOException {
        return SocketAdapterFactory.getForSocket(new Socket(host, ControllerFallbacks.startDebugging(vm, suspendAll)));
    }

    private static class VmId {
        public final int clusterTypeId;
        public final int id;
        public final int index;

        public VmId(int clusterTypeId, int id, int index) {
            this.clusterTypeId = clusterTypeId;
            this.id = id;
            this.index = index;
        }
    }
}

