/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.jvmmon.JvmmondUtils;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringListener;
import com.sap.jvm.inspector.jvmmon.MonitoringManager;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class DebuggingByFileSocketProxy
implements MonitoringListener {
    public static void main(String[] args) throws Exception {
        MonitoringManager manager = new MonitoringManager(1000);
        manager.addListener(new DebuggingByFileSocketProxy());
        manager.addLocal();
        Thread.sleep(100000000000L);
    }

    @Override
    public void vmChanges(MonitoredVm[] newInfos, MonitoredVm[] changedInfos, MonitoredVm[] deletedInfos) {
        for (MonitoredVm info : newInfos) {
            String name = info.getBoard().getString("JAVA_MAINCLASS", "UNKNOWN MAIN CLASS");
            System.out.println(name);
            if (!name.contains("JvmMon")) continue;
            try (ServerSocket ss = new ServerSocket(8000);){
                SocketAdapter socket = info.getDebuggingConnection(true);
                Socket cs = ss.accept();
                cs.setTcpNoDelay(true);
                JvmmondUtils.connect(socket.getInputStream(), socket.getOutputStream(), cs.getInputStream(), cs.getOutputStream());
                System.out.println("Connected!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

