/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.impl.monitor.transport.JvmmondSocketTools;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.inspector.jvmmon.BoardChanges;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.inspector.jvmmon.SimplePacketReader;
import com.sap.jvm.inspector.jvmmon.SimplePacketWriter;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class JvmmondNewClient {
    private final Socket socket;
    private final SimplePacketReader reader;
    private final SimplePacketWriter writer;
    private HashMap<Integer, BoardWrapper> boards = new HashMap();
    private final String host;
    private final int port;
    private boolean storePassword = true;

    public JvmmondNewClient(final String host, final int port) throws IOException {
        this(host, port, new PasswordSupplier(){

            @Override
            public String get() throws IOException {
                return JvmmondSocketTools.lookupPasswordToken(host, port);
            }
        });
        this.storePassword = false;
    }

    public JvmmondNewClient(String host, int port, PasswordSupplier passwordSupplier) throws IOException {
        this.host = host;
        this.port = port;
        this.socket = new Socket(host, port);
        OutputStream os = this.socket.getOutputStream();
        InputStream is = this.socket.getInputStream();
        for (char c : JvmmondSocketTools.HANDSHAKE) {
            os.write(c);
        }
        for (char c : JvmmondSocketTools.HANDSHAKE) {
            if (c == is.read()) continue;
            this.socket.close();
            throw new IOException("Did not read character " + c + " during jvmmond protocol handshake.");
        }
        this.reader = new SimplePacketReader(is);
        this.writer = new SimplePacketWriter(os);
        if (!this.authenticate(passwordSupplier)) {
            throw new IOException("Failed to authenticate.");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BoardWrapper readBoard() throws IOException {
        BoardWrapper board;
        byte type = this.reader.readInt8();
        if (type != 0) throw new IOException("Unknown board type " + type);
        byte[] boardData = new byte[this.reader.readInt32()];
        this.reader.readBytes(boardData);
        try {
            board = new BoardWrapper(boardData);
            BoardWrapper oldBoard = this.boards.get(board.getPid());
            if (oldBoard != null) {
                board = new BoardWrapper(oldBoard, board);
            }
        }
        catch (MonitorBoardFormatException e) {
            throw new IOException("Caught MonitorBoardFormatException when reading board");
        }
        this.boards.put(board.getPid(), board);
        return board;
    }

    public BoardChanges getBoardChanges(MonitoringController mc) throws IOException {
        this.writer.startPacket(107);
        this.writer.endPacket(107);
        int tag = this.reader.getPacket();
        if (tag != 108) {
            throw new IOException("Got unexpected tag " + tag);
        }
        int boardCount = this.reader.readInt32();
        HashMap<Integer, BoardWrapper> newBoards = new HashMap<Integer, BoardWrapper>(boardCount);
        for (int i = 0; i < boardCount; ++i) {
            BoardWrapper board = this.readBoard();
            newBoards.put(board.getPid(), board);
        }
        boardCount = this.reader.readInt32();
        HashMap<Integer, BoardWrapper> changedBoards = new HashMap<Integer, BoardWrapper>(boardCount);
        for (int i = 0; i < boardCount; ++i) {
            Integer pid = this.reader.readInt32();
            BoardWrapper changedBoard = this.readBoard();
            changedBoards.put(pid, changedBoard);
        }
        boardCount = this.reader.readInt32();
        HashMap<Integer, BoardWrapper> deletedBoards = new HashMap<Integer, BoardWrapper>(boardCount);
        for (int i = 0; i < boardCount; ++i) {
            BoardWrapper board = this.readBoard();
            Integer pid = board.getPid();
            deletedBoards.put(pid, board);
            this.boards.remove(pid);
        }
        return new BoardChanges(newBoards, deletedBoards, changedBoards);
    }

    private boolean authenticate(PasswordSupplier passwordSupplier) throws IOException {
        MessageDigest md;
        this.writer.startPacket(101);
        this.writer.endPacket(101);
        int tag = this.reader.getPacket();
        if (tag != 102) {
            throw new IOException("Got unexpected tag " + tag);
        }
        int version = this.reader.readInt32();
        if (version != 0) {
            throw new IOException("Unsupported version " + version);
        }
        boolean needsPassword = this.reader.readBoolean();
        if (!needsPassword) {
            this.reader.finishPacket();
            Trace.get(this.getClass()).debug("Password not needed");
            return true;
        }
        byte[] salt = new byte[this.reader.readInt32()];
        this.reader.readBytes(salt);
        this.reader.finishPacket();
        if (passwordSupplier == null) {
            this.socket.close();
            throw new IOException("Jvmmond server needs a password but no password supplier available.");
        }
        String passwordToken = passwordSupplier.get();
        String convertedToken = null;
        try {
            convertedToken = JvmmondSocketTools.getPasswordFromHexRepresentation(passwordToken);
        }
        catch (IllegalArgumentException iae) {
            Trace.get(this.getClass()).debug("Password token could not be interpreted as hex string.");
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not instantiate crypto algorithm for authentication.", e);
        }
        md.update(salt);
        byte[] digest = md.digest(convertedToken == null ? passwordToken.getBytes(StandardCharsets.UTF_8) : convertedToken.getBytes(StandardCharsets.UTF_8));
        this.writer.startPacket(103);
        this.writer.writeBytes(digest);
        this.writer.endPacket(103);
        tag = this.reader.getPacket();
        if (tag != 104) {
            throw new IOException("Unexpected tag " + tag);
        }
        boolean success = this.reader.readBoolean();
        this.reader.finishPacket();
        if (success && this.storePassword) {
            JvmmondSocketTools.registerPassword(convertedToken == null ? passwordToken : convertedToken, this.host, this.port);
        }
        if (success || convertedToken == null) {
            return success;
        }
        md.reset();
        md.update(salt);
        digest = md.digest(passwordToken.getBytes(StandardCharsets.UTF_8));
        this.writer.startPacket(103);
        this.writer.writeBytes(digest);
        this.writer.endPacket(103);
        tag = this.reader.getPacket();
        if (tag != 104) {
            throw new IOException("Unexpected tag " + tag);
        }
        success = this.reader.readBoolean();
        this.reader.finishPacket();
        if (success && this.storePassword) {
            JvmmondSocketTools.registerPassword(passwordToken, this.host, this.port);
        }
        return success;
    }

    public Socket convertToProfilingSession(int pid) throws IOException {
        this.writer.startPacket(105);
        this.writer.writeInt32(pid);
        this.writer.endPacket(105);
        int tag = this.reader.getPacket();
        if (tag != 106) {
            throw new IOException("Unexpected tag " + tag);
        }
        boolean success = this.reader.readBoolean();
        if (success) {
            this.reader.finishPacket();
            this.reader.detach();
            this.writer.detach();
            return this.socket;
        }
        this.reader.readInt32();
        boolean foundPid = this.reader.readBoolean();
        boolean gotException = this.reader.readBoolean();
        this.reader.finishPacket();
        if (!foundPid) {
            Trace.warn(() -> "Could not find pid " + pid);
        } else if (gotException) {
            Trace.warn("Got exception");
        }
        return null;
    }

    public Socket convertToMonitoringSession(int pid) throws IOException {
        this.writer.startPacket(112);
        this.writer.writeInt32(pid);
        this.writer.endPacket(112);
        int tag = this.reader.getPacket();
        if (tag != 113) {
            throw new IOException("Unexpected tag " + tag);
        }
        boolean success = this.reader.readBoolean();
        if (success) {
            this.reader.finishPacket();
            this.reader.detach();
            this.writer.detach();
            return this.socket;
        }
        this.reader.readInt32();
        this.reader.finishPacket();
        if (!success) {
            Trace.warn(() -> "Could not find pid " + pid);
        }
        return null;
    }

    public Socket convertToDebuggingSession(int pid, SuspendPolicy sp) throws IOException {
        this.writer.startPacket(110);
        this.writer.writeInt32(pid);
        this.writer.writeInt8((byte)sp.getIndex());
        this.writer.endPacket(110);
        int tag = this.reader.getPacket();
        if (tag != 111) {
            throw new IOException("Unexpected tag " + tag);
        }
        boolean success = this.reader.readBoolean();
        if (success) {
            this.reader.finishPacket();
            this.reader.detach();
            this.writer.detach();
            return this.socket;
        }
        this.reader.readInt32();
        boolean foundPid = this.reader.readBoolean();
        boolean gotException = this.reader.readBoolean();
        this.reader.finishPacket();
        if (!foundPid) {
            Trace.warn(() -> "Could not find pid " + pid);
        } else if (gotException) {
            Trace.warn("Got exception");
        }
        return null;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }
}

