/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;

public class MonitoredVm
extends ConnectableVm {
    private volatile BoardWrapper board;
    private volatile boolean isAlive;
    private final MonitoringController controller;
    private final Connectability connectability;

    public MonitoredVm(MonitoringController controller, BoardWrapper board, Connectability connectability) {
        super("pid " + board.getPid());
        this.board = board;
        this.isAlive = true;
        this.controller = controller;
        this.connectability = connectability;
    }

    public boolean isAlive() {
        return this.isAlive && this.controller.isConnected();
    }

    public String getHost() {
        return this.getHost("localhost");
    }

    public String getHost(String localhost) {
        String host = this.controller.getHost();
        if (host == null) {
            return localhost;
        }
        return host;
    }

    public SocketAdapter getDebuggingConnection(boolean suspendAll) throws IOException {
        return this.controller.getDebuggingConnection(this, suspendAll);
    }

    @Override
    public ConnectableVm.MonitoringConnection getMonitoringConnection() throws IOException {
        SocketAdapter result = this.controller.getMonitoringConnection(this.board);
        if (result == null) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            result = this.controller.getMonitoringConnection(this.board);
            if (result == null) {
                throw new IOException("Could not connect");
            }
        }
        try {
            return new ConnectableVm.MonitoringConnection(result);
        }
        catch (IOException e) {
            result.close();
            throw e;
        }
    }

    public Connectability getConnectability() {
        return this.connectability;
    }

    public MonitoringController getController() {
        return this.controller;
    }

    public boolean isLocal() {
        return this.controller.isLocal();
    }

    public boolean isOldJvmmond() {
        return !this.isLocal() && this.controller.isOldJvmmond();
    }

    public boolean isOldStyle() {
        return this.controller.isOldStyle(this.board);
    }

    public void updateBoard(BoardWrapper newBoard) {
        assert (newBoard == null || newBoard.getPid() == this.board.getPid());
        if (newBoard == null) {
            this.isAlive = false;
        } else {
            this.board = newBoard;
        }
    }

    public BoardWrapper getBoard() {
        return this.board;
    }

    public int getPid() {
        return this.board == null ? -1 : this.board.getPid();
    }

    public Vm getVmOld() {
        return this.getController().getVmOld(this.getPid());
    }

    public int hashCode() {
        return this.controller.hashCode() ^ this.board.getPid();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MonitoredVm) {
            MonitoredVm other = (MonitoredVm)obj;
            return this.board.getPid() == other.board.getPid() && this.controller.equals(other.controller);
        }
        return false;
    }

    public String toString() {
        String tagAndPid = this.board.getVmTag().length() > 0 ? "'" + this.board.getVmTag() + "' (pid " + this.board.getPid() + ")" : "pid " + this.board.getPid();
        if (this.controller.isLocal()) {
            return "<local monitoring info for " + tagAndPid + ">";
        }
        String add = "";
        if (this.controller.isOldStyle(this.getBoard())) {
            add = "old style, ";
        }
        if (this.controller.isOldJvmmond()) {
            add = add + "old jvmmond, ";
        }
        return "<remote monitoring info, " + add + tagAndPid + ", host: " + this.controller.getHost() + ", port: " + this.controller.getPort() + ", connected: " + this.controller.isConnected() + ">";
    }
}

