/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.board.AttributeDataType;
import com.sap.jvm.inspector.board.AttributeGroupType;
import com.sap.jvm.inspector.board.AttributeUnitType;
import com.sap.jvm.inspector.board.AttributeVariabilityType;
import com.sap.jvm.inspector.board.BoardImpl;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.util.misc.ByteConverter;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class MonitoringAttribute {
    private final int maxLength;
    private final int valueLengthOffset;
    private final int valueOffset;
    private final boolean isArray;
    private final AttributeGroupType groupType;
    private final AttributeDataType dataType;
    private final AttributeVariabilityType variabilityType;
    private final AttributeUnitType unitType;
    private final String name;

    public MonitoringAttribute(byte[] board, int offset) throws MonitorBoardFormatException {
        if (board.length < offset + 16) {
            throw new MonitorBoardFormatException("Board size is too small for offset " + offset);
        }
        int magic = ByteConverter.readInt32(board, offset);
        if (magic != BoardImpl.MAGIC_NUMBER) {
            throw new MonitorBoardFormatException("Invalid eyecatcher 0x" + Integer.toHexString(magic));
        }
        int size = ByteConverter.readInt32(board, offset + 4);
        if (size < 0) {
            throw new MonitorBoardFormatException("Invalid maximum length " + size);
        }
        if (board.length < offset + size) {
            throw new MonitorBoardFormatException("Board size is too small for size " + size);
        }
        this.groupType = AttributeGroupType.getGroupType(board[offset + 8]);
        this.dataType = AttributeDataType.getDataType(board[offset + 9]);
        this.variabilityType = AttributeVariabilityType.getVariabilityType(board[offset + 10]);
        this.unitType = AttributeUnitType.getUnitType(board[offset + 11]);
        char nameOffset = ByteConverter.readUint16(board, offset + 12);
        if (board.length < nameOffset + 4) {
            throw new MonitorBoardFormatException("Board too small for name offset " + nameOffset);
        }
        this.valueLengthOffset = offset + ByteConverter.readUint16(board, offset + 14);
        if (board.length < this.valueLengthOffset + 4) {
            throw new MonitorBoardFormatException("Board too small for value offset " + this.valueLengthOffset);
        }
        int nameLength = ByteConverter.readInt32(board, offset + nameOffset);
        if (nameLength <= 0) {
            throw new MonitorBoardFormatException("Name length is invalid: " + nameLength);
        }
        if (board.length < offset + nameOffset + nameLength + 4) {
            throw new MonitorBoardFormatException("Board too small for name length " + nameLength);
        }
        if (nameLength > 0 && board[offset + nameOffset + 4 + nameLength - 1] == 0) {
            --nameLength;
        }
        this.name = UTF8Util.asString(board, offset + nameOffset + 4, nameLength);
        int valueSize = size - this.valueLengthOffset - 4 + offset;
        if (valueSize < 0) {
            throw new MonitorBoardFormatException("Invalid value size for " + this.name);
        }
        this.valueOffset = this.valueLengthOffset + 4;
        this.maxLength = valueSize / this.dataType.getSizeInBytes();
        if (this.maxLength * this.dataType.getSizeInBytes() != valueSize) {
            throw new MonitorBoardFormatException("Value size " + valueSize + " not multiple of data type size " + this.dataType.getSizeInBytes());
        }
        this.isArray = this.dataType == AttributeDataType.TYPE_CHAR ? false : (this.getLength(board) > 0 ? true : this.maxLength > 1);
    }

    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public AttributeGroupType getGroupType() {
        return this.groupType;
    }

    public AttributeDataType getDataType() {
        return this.dataType;
    }

    public AttributeVariabilityType getVariabilityType() {
        return this.variabilityType;
    }

    public AttributeUnitType getUnitType() {
        return this.unitType;
    }

    public boolean isBoolean() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_BOOL;
    }

    public boolean isByte() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT8;
    }

    public boolean isShort() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT16;
    }

    public boolean isInt() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT32;
    }

    public boolean isLong() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT64;
    }

    public boolean isFloat() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_FLOAT;
    }

    public boolean isDouble() {
        return !this.isArray() && this.getDataType() == AttributeDataType.TYPE_DOUBLE;
    }

    public boolean isBooleanArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_BOOL;
    }

    public boolean isByteArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT8;
    }

    public boolean isShortArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT16;
    }

    public boolean isIntArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT32;
    }

    public boolean isLongArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_INT64;
    }

    public boolean isFloatArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_FLOAT;
    }

    public boolean isDoubleArray() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_DOUBLE;
    }

    public boolean isString() {
        return this.isArray() && this.getDataType() == AttributeDataType.TYPE_CHAR;
    }

    public int getLength(byte[] board) {
        return ByteConverter.readInt32(board, this.valueLengthOffset);
    }

    public boolean getBoolean(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_BOOL));
        return board[this.valueOffset] != 0;
    }

    public void setBoolean(byte[] board, boolean value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_BOOL));
        board[this.valueOffset] = value ? (byte)1 : 0;
    }

    public boolean[] getBooleanArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_BOOL, this.getLength(board)));
        boolean[] result = new boolean[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = board[this.valueOffset + i] != 0;
        }
        return result;
    }

    public void setBooleanArray(byte[] board, boolean[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_BOOL, value.length));
        for (int i = 0; i < value.length; ++i) {
            board[this.valueOffset + i] = value[i] ? (byte)1 : 0;
        }
    }

    public byte getByte(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT8));
        return board[this.valueOffset];
    }

    public void setByte(byte[] board, byte value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT8));
        board[this.valueOffset] = value;
    }

    public byte[] getByteArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT8, this.getLength(board)));
        byte[] result = new byte[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = board[this.valueOffset + i];
        }
        return result;
    }

    public void setByteArray(byte[] board, byte[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT8, value.length));
        for (int i = 0; i < value.length; ++i) {
            board[this.valueOffset + i] = value[i];
        }
    }

    public short getShort(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT16));
        return ByteConverter.readInt16(board, this.valueOffset);
    }

    public void setShort(byte[] board, short value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT16));
        ByteConverter.writeInt16(board, this.valueOffset, value);
    }

    public short[] getShortArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT16, this.getLength(board)));
        short[] result = new short[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteConverter.readInt16(board, this.valueOffset + i * 2);
        }
        return result;
    }

    public void setShortArray(byte[] board, short[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT16, value.length));
        for (int i = 0; i < value.length; ++i) {
            ByteConverter.writeInt16(board, this.valueOffset + 2 * i, value[i]);
        }
    }

    public int getInt(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT32));
        return ByteConverter.readInt32(board, this.valueOffset);
    }

    public void setInt(byte[] board, int value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT32));
        ByteConverter.writeInt32(board, this.valueOffset, value);
    }

    public int[] getIntArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT32, this.getLength(board)));
        int[] result = new int[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteConverter.readInt32(board, this.valueOffset + i * 4);
        }
        return result;
    }

    public void setIntArray(byte[] board, int[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT32, value.length));
        for (int i = 0; i < value.length; ++i) {
            ByteConverter.writeInt32(board, this.valueOffset + 4 * i, value[i]);
        }
    }

    public long getLong(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT64));
        return ByteConverter.readInt64(board, this.valueOffset);
    }

    public void setLong(byte[] board, long value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_INT64));
        ByteConverter.writeInt64(board, this.valueOffset, value);
    }

    public long[] getLongArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT64, this.getLength(board)));
        long[] result = new long[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteConverter.readInt64(board, this.valueOffset + i * 8);
        }
        return result;
    }

    public void setLongArray(byte[] board, long[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_INT64, value.length));
        for (int i = 0; i < value.length; ++i) {
            ByteConverter.writeInt64(board, this.valueOffset + 8 * i, value[i]);
        }
    }

    public float getFloat(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_FLOAT));
        return ByteConverter.readFloat(board, this.valueOffset);
    }

    public void setFloat(byte[] board, float value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_FLOAT));
        ByteConverter.writeFloat(board, this.valueOffset, value);
    }

    public float[] getFloatArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_FLOAT, this.getLength(board)));
        float[] result = new float[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteConverter.readFloat(board, this.valueOffset + i * 4);
        }
        return result;
    }

    public void setFloatArray(byte[] board, float[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_FLOAT, value.length));
        for (int i = 0; i < value.length; ++i) {
            ByteConverter.writeFloat(board, this.valueOffset + 4 * i, value[i]);
        }
    }

    public double getDouble(byte[] board) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_DOUBLE));
        return ByteConverter.readDouble(board, this.valueOffset);
    }

    public void setDouble(byte[] board, double value) {
        assert (this.isScalarType(board, AttributeDataType.TYPE_DOUBLE));
        ByteConverter.writeDouble(board, this.valueOffset, value);
    }

    public double[] getDoubleArray(byte[] board) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_DOUBLE, this.getLength(board)));
        double[] result = new double[this.getLength(board)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteConverter.readDouble(board, this.valueOffset + i * 8);
        }
        return result;
    }

    public void setDoubleArray(byte[] board, double[] value) {
        assert (this.isValidArray(board, AttributeDataType.TYPE_DOUBLE, value.length));
        for (int i = 0; i < value.length; ++i) {
            ByteConverter.writeDouble(board, this.valueOffset + 8 * i, value[i]);
        }
    }

    public String getString(byte[] board) {
        assert (this.dataType == AttributeDataType.TYPE_CHAR);
        int len = this.getLength(board);
        if (len > 0 && board[this.valueOffset + len - 1] == 0) {
            --len;
        }
        return UTF8Util.asString(board, this.valueOffset, len);
    }

    public void setString(byte[] board, String value) {
        byte[] asBytes = value == null ? new byte[]{} : UTF8Util.modifiedUTF8(value);
        int len = Math.min(asBytes.length, this.maxLength);
        ByteConverter.writeInt32(board, this.valueLengthOffset, len);
        System.arraycopy(asBytes, 0, board, this.valueOffset, len);
    }

    public String toString() {
        return this.name;
    }

    public String toString(byte[] board) {
        if (this.isArray) {
            return this.name + ": " + this.getValuesAsString(board).toString();
        }
        return this.name + ": " + this.getValuesAsString(board).get(0);
    }

    public List<String> getValuesAsString(byte[] board) {
        ArrayList<String> result;
        block26: {
            block27: {
                block25: {
                    result = new ArrayList<String>();
                    if (this.getDataType() != AttributeDataType.TYPE_CHAR) break block25;
                    result.add(this.getString(board));
                    break block26;
                }
                if (!this.isArray) break block27;
                switch (this.getDataType()) {
                    case TYPE_BOOL: {
                        for (boolean v : this.getBooleanArray(board)) {
                            result.add(v ? "true" : "false");
                        }
                        break block26;
                    }
                    case TYPE_INT8: {
                        for (byte v : this.getByteArray(board)) {
                            result.add(Byte.toString(v));
                        }
                        break block26;
                    }
                    case TYPE_INT16: {
                        for (short v : this.getShortArray(board)) {
                            result.add(Short.toString(v));
                        }
                        break block26;
                    }
                    case TYPE_INT32: {
                        for (int v : this.getIntArray(board)) {
                            result.add(Integer.toString(v));
                        }
                        break block26;
                    }
                    case TYPE_INT64: {
                        for (long v : this.getLongArray(board)) {
                            result.add(Long.toString(v));
                        }
                        break block26;
                    }
                    case TYPE_FLOAT: {
                        for (float v : this.getFloatArray(board)) {
                            result.add(Float.toString(v));
                        }
                        break block26;
                    }
                    case TYPE_DOUBLE: {
                        for (double v : this.getDoubleArray(board)) {
                            result.add(Double.toString(v));
                        }
                        break block26;
                    }
                }
                break block26;
            }
            switch (this.getDataType()) {
                case TYPE_BOOL: {
                    result.add(this.getBoolean(board) ? "true" : "false");
                    break;
                }
                case TYPE_INT8: {
                    result.add(Byte.toString(this.getByte(board)));
                    break;
                }
                case TYPE_INT16: {
                    result.add(Short.toString(this.getShort(board)));
                    break;
                }
                case TYPE_INT32: {
                    result.add(Integer.toString(this.getInt(board)));
                    break;
                }
                case TYPE_INT64: {
                    result.add(Long.toString(this.getLong(board)));
                    break;
                }
                case TYPE_FLOAT: {
                    result.add(Float.toString(this.getFloat(board)));
                    break;
                }
                case TYPE_DOUBLE: {
                    result.add(Double.toString(this.getDouble(board)));
                    break;
                }
            }
        }
        return result;
    }

    public void print(byte[] board, PrintStream stream) {
        stream.print(this.name + ": ");
        List<String> values = this.getValuesAsString(board);
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                stream.println();
                for (int j = -2; j < this.name.length(); ++j) {
                    stream.print(' ');
                }
            }
            stream.print(values.get(i));
        }
        stream.println();
    }

    public void printDetailed(byte[] board, PrintStream stream) {
        stream.print(this.name + ": ");
        List<String> values = this.getValuesAsString(board);
        values.add(0, "Data Type: " + (Object)((Object)this.getDataType()));
        values.add(1, "Variability Type: " + (Object)((Object)this.getVariabilityType()));
        values.add(2, "Unit Type: " + (Object)((Object)this.getUnitType()));
        values.add(3, "Group Type: " + (Object)((Object)this.getGroupType()));
        values.add(4, "Is Array: " + this.isArray);
        if (this.isArray) {
            values.add(5, "Max Length: " + this.maxLength);
        }
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                stream.println();
                for (int j = -2; j < this.name.length(); ++j) {
                    stream.print(' ');
                }
            }
            stream.print(values.get(i));
        }
        stream.println();
    }

    private boolean isScalarType(byte[] board, AttributeDataType type) {
        if (this.getLength(board) > 0) {
            return false;
        }
        if (this.isArray) {
            return false;
        }
        return type == this.dataType;
    }

    private boolean isValidArray(byte[] board, AttributeDataType type, int length) {
        if (!this.isArray) {
            return false;
        }
        if (type != this.dataType) {
            return false;
        }
        return length <= this.maxLength;
    }
}

