/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.impl.internals.InternalsProviderImpl;
import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardProviderLocal;
import com.sap.jvm.inspector.board.BoardProviderRemote;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.board.Connectability;
import com.sap.jvm.inspector.cluster.ProfilingCluster;
import com.sap.jvm.inspector.filesocket.FileSocketConnection;
import com.sap.jvm.inspector.jvmmon.BoardChanges;
import com.sap.jvm.inspector.jvmmon.ControllerFallbacks;
import com.sap.jvm.inspector.jvmmon.HostSpec;
import com.sap.jvm.inspector.jvmmon.JvmmondNewClient;
import com.sap.jvm.inspector.jvmmon.JvmmondUtils;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.misc.PipedSocket;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class MonitoringController
implements Closeable {
    private static final byte[] JDWP_HANDSHAKE = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    private static final Map<String, Boolean> hostLocalCache = new HashMap<String, Boolean>();
    private final Map<Integer, BoardWrapper> currentBoards = new HashMap<Integer, BoardWrapper>();
    private final Map<Integer, BoardWrapper> toBeRemovedBoards = new HashMap<Integer, BoardWrapper>();
    private long lastUpdateTime;
    private final long updateInterval = 500L;
    private final Map<Integer, MonitoredVm> vms = new HashMap<Integer, MonitoredVm>();
    private BoardProviderLocal localProvider;
    private BoardProviderRemote remoteProvider;
    private JvmmondNewClient jvmmondClient;
    private boolean isDisabled = false;
    private final HostSpec hostSpec;
    private final int ownPid;
    private final boolean isHostLocal;

    public MonitoringController() throws IOException {
        this(new HostSpec(null, -1), null, false);
    }

    public MonitoringController(String host, int port, PasswordSupplier passwordSupplier, boolean alwaysUseRMI) throws IOException {
        this(new HostSpec(host, port), passwordSupplier, alwaysUseRMI);
    }

    private MonitoringController(HostSpec hostSpec, PasswordSupplier passwordSupplier, boolean alwaysUseRMI) throws IOException {
        this.hostSpec = hostSpec;
        this.lastUpdateTime = System.currentTimeMillis() - 1000L;
        this.ownPid = InspectorInfo.getOwnProcessId();
        this.isHostLocal = this.isHostLocal();
        if (hostSpec.getHost() == null) {
            this.localProvider = new BoardProviderLocal(true);
        } else {
            IOException ioe;
            block8: {
                ioe = null;
                try {
                    this.jvmmondClient = new JvmmondNewClient(hostSpec.getHost(), hostSpec.getPort(), passwordSupplier);
                }
                catch (IOException e) {
                    Trace.get(this.getClass()).warn((Throwable)e, "Caught IOException while connecting new jvmmond client.");
                    ioe = e;
                }
                if (alwaysUseRMI || this.jvmmondClient == null) {
                    try {
                        this.remoteProvider = new BoardProviderRemote(hostSpec.getHost(), hostSpec.getPort(), true, passwordSupplier);
                    }
                    catch (IOException e) {
                        Trace.get(this.getClass()).warn((Throwable)e, "Caught IOException while connecting old (RMI) jvmmond client.");
                        if (ioe != null) break block8;
                        ioe = e;
                    }
                }
            }
            if (this.remoteProvider == null && (this.jvmmondClient == null || alwaysUseRMI)) {
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHostLocal() {
        Boolean result;
        if (this.hostSpec.getHost() == null) {
            return true;
        }
        Map<String, Boolean> map = hostLocalCache;
        synchronized (map) {
            result = hostLocalCache.get(this.hostSpec.getHost());
        }
        if (result == null) {
            try {
                result = false;
                HashSet<InetAddress> addrs = new HashSet<InetAddress>(Arrays.asList(InetAddress.getAllByName(this.hostSpec.getHost())));
                Enumeration<NetworkInterface> it = NetworkInterface.getNetworkInterfaces();
                while (it.hasMoreElements()) {
                    NetworkInterface nif = it.nextElement();
                    Enumeration<InetAddress> it2 = nif.getInetAddresses();
                    while (it2.hasMoreElements()) {
                        if (!addrs.contains(it2.nextElement())) continue;
                        result = true;
                    }
                }
            }
            catch (SocketException | UnknownHostException e) {
                result = false;
            }
            map = hostLocalCache;
            synchronized (map) {
                hostLocalCache.put(this.hostSpec.getHost(), result);
            }
        }
        return result;
    }

    private synchronized BoardChanges update(boolean force) {
        BoardWrapper board;
        long t = System.currentTimeMillis();
        if (!force && t - this.lastUpdateTime < 500L) {
            return BoardChanges.NOTHING;
        }
        this.lastUpdateTime = t;
        BoardChanges changes = null;
        if (!this.isConnected() || this.isDisabled) {
            changes = new BoardChanges(Collections.emptyMap(), this.currentBoards, Collections.emptyMap());
            this.jvmmondClient = null;
            this.remoteProvider = null;
        } else if (this.jvmmondClient != null) {
            try {
                changes = this.jvmmondClient.getBoardChanges(this);
            }
            catch (IOException iOException) {}
        } else {
            Map<Integer, BoardWrapper> boards = this.localProvider == null ? this.remoteProvider.getAllBoards() : this.localProvider.getAllBoards();
            HashMap<Integer, BoardWrapper> hashMap = new HashMap<Integer, BoardWrapper>();
            HashMap<Integer, BoardWrapper> changedBoards = new HashMap<Integer, BoardWrapper>();
            HashMap<Integer, BoardWrapper> deletedBoards = new HashMap<Integer, BoardWrapper>();
            for (Integer pid : this.currentBoards.keySet()) {
                if (boards.containsKey(pid)) continue;
                deletedBoards.put(pid, this.currentBoards.get(pid));
            }
            for (Integer pid : boards.keySet()) {
                BoardWrapper board2 = boards.get(pid);
                if (this.currentBoards.containsKey(pid)) {
                    BoardWrapper oldBoard = this.currentBoards.get(pid);
                    if (oldBoard.isDifferentProcess(board2)) {
                        assert (!deletedBoards.containsKey(pid));
                        deletedBoards.put(pid, oldBoard);
                        continue;
                    }
                    if (oldBoard.getTimeStamp() == board2.getTimeStamp()) continue;
                    assert (!changedBoards.containsKey(pid));
                    changedBoards.put(pid, board2);
                    continue;
                }
                hashMap.put(pid, board2);
            }
            changes = new BoardChanges(hashMap, deletedBoards, changedBoards);
        }
        if (changes == null) {
            return BoardChanges.NOTHING;
        }
        if (this.isHostLocal) {
            changes.removePid(this.ownPid);
        }
        Iterator<Object> iterator = this.toBeRemovedBoards.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.vms.remove(n);
        }
        this.toBeRemovedBoards.clear();
        for (Map.Entry entry : changes.deletedBoards.entrySet()) {
            int pid = (Integer)entry.getKey();
            board = (BoardWrapper)entry.getValue();
            MonitoredVm vm = this.vms.get(pid);
            vm.updateBoard(null);
            this.toBeRemovedBoards.put(pid, board);
            this.currentBoards.remove(pid);
        }
        for (Map.Entry entry : changes.changedBoards.entrySet()) {
            BoardWrapper newBoard = (BoardWrapper)entry.getValue();
            int pid = (Integer)entry.getKey();
            this.vms.get(pid).updateBoard(newBoard);
        }
        for (Map.Entry entry : changes.newBoards.entrySet()) {
            int pid = (Integer)entry.getKey();
            board = (BoardWrapper)entry.getValue();
            assert (!this.currentBoards.containsKey(pid));
            this.vms.put(pid, new MonitoredVm(this, board, Connectability.TYPE_YES_VIA_CONTROL_AREA_OR_DOMAIN_SOCKET));
            this.currentBoards.put(pid, board);
        }
        iterator = this.currentBoards.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            assert (!this.toBeRemovedBoards.containsKey(n));
        }
        iterator = this.toBeRemovedBoards.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            assert (!this.currentBoards.containsKey(n));
        }
        return changes;
    }

    private boolean needsLegacy(BoardWrapper board) {
        if (this.jvmmondClient != null) {
            return false;
        }
        if (this.remoteProvider != null) {
            return true;
        }
        return !board.getBoolean("PROFILING_SERVER_SUPPORTS_LEGACY_MONITORING_OPERATIONS", false);
    }

    public BoardChanges getChanges() {
        return this.update(false);
    }

    @Deprecated
    public static MonitoringController getForLocal() {
        try {
            return new MonitoringController();
        }
        catch (IOException e) {
            return null;
        }
    }

    synchronized MonitoredVm getMonitoredVm(BoardWrapper board) {
        return this.vms.get(board.getPid());
    }

    public synchronized MonitoredVm getVmForPid(int pid, boolean forceUpdate) {
        this.update(forceUpdate);
        return this.vms.get(pid);
    }

    public synchronized MonitoredVm getVmForInstance(int instanceNr, int clusterIndex, boolean forceUpdate) {
        this.update(forceUpdate);
        for (MonitoredVm vm : this.vms.values()) {
            if (vm.getBoard().getInt("", -1) != instanceNr || vm.getBoard().getInt("", -1) != clusterIndex) continue;
            return vm;
        }
        return null;
    }

    public MonitoredVm getVmForPidOrInstance(int pid, int instanceNr, int clusterIndex, boolean forceUpdate) {
        MonitoredVm result = this.getVmForPid(pid, forceUpdate);
        return result == null ? this.getVmForInstance(instanceNr, clusterIndex, false) : result;
    }

    public synchronized MonitoredVm[] getAllMonitoredVms(boolean forceUpdate) {
        this.update(forceUpdate);
        HashMap<Integer, MonitoredVm> copy = new HashMap<Integer, MonitoredVm>(this.vms);
        for (int pid : this.toBeRemovedBoards.keySet()) {
            copy.remove(pid);
        }
        return copy.values().toArray(new MonitoredVm[copy.size()]);
    }

    public ClusterInfo[] getClusterInfo() {
        if (this.remoteProvider == null) {
            return Cluster.getClusterInfo();
        }
        try {
            return this.remoteProvider.getClusterInfo();
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return new ClusterInfo[0];
        }
    }

    public Vm getVmOld(int pid) {
        if (this.remoteProvider == null) {
            return Cluster.getVm(pid);
        }
        try {
            RemoteVm remoteVm = this.remoteProvider.getVmOld(pid);
            return this.remoteProvider.getVmOld(remoteVm);
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return null;
        }
    }

    public MonitoredVm getVm(int pid) {
        for (MonitoredVm vm : this.getAllMonitoredVms(true)) {
            if (vm.getBoard().getPid() != pid) continue;
            return vm;
        }
        return null;
    }

    public MonitoredVm[] getInstanceVms(int instanceId) {
        ArrayList<MonitoredVm> result = new ArrayList<MonitoredVm>();
        for (MonitoredVm vm : this.getAllMonitoredVms(true)) {
            if (vm.getBoard().getInstanceNr() != instanceId) continue;
            result.add(vm);
        }
        return result.toArray(new MonitoredVm[result.size()]);
    }

    public VmInternals getVmInternalsByProcessId(int processId) {
        if (this.remoteProvider == null) {
            return InternalsProviderImpl.get().getVmInternalsByProcessId(processId);
        }
        try {
            return this.remoteProvider.getVmInternalsByProcessId(processId);
        }
        catch (RemoteException e) {
            Trace.get(this.getClass()).warn(e);
            return null;
        }
    }

    public SocketAdapter getDebuggingConnection(MonitoredVm vm, boolean suspendAll) throws IOException {
        SuspendPolicy sp;
        if (!vm.isAlive()) {
            throw new IOException("The VM is already dead");
        }
        if (vm.getController() != this) {
            throw new IOException("Called for wrong controller");
        }
        BoardWrapper board = vm.getBoard();
        Vm legacyVm = null;
        String legacyHost = null;
        if (this.remoteProvider != null) {
            legacyHost = this.remoteProvider.getHost();
            legacyVm = this.remoteProvider.getVmForBoard(board);
        }
        if (this.jvmmondClient == null && !board.getBoolean("DEBUGGING_ON_DEMAND_VIA_PROFILING_SERVER_ENABLED", false)) {
            legacyHost = "localhost";
            legacyVm = ProfilingCluster.getVm(board.getPid());
        }
        if (legacyHost != null) {
            if (legacyVm == null) {
                throw new IOException("Could not find the VM with pid " + board.getPid());
            }
            return ControllerFallbacks.getDebuggingConnection(legacyVm, legacyHost, suspendAll);
        }
        int pid = board.getPid();
        BoardWrapper current = this.currentBoards.get(pid);
        if (current == null || board.isDifferentProcess(current)) {
            throw new IOException("VM is already dead");
        }
        SuspendPolicy suspendPolicy = sp = suspendAll ? SuspendPolicy.SUSPEND_ALL : SuspendPolicy.SUSPEND_NONE;
        if (this.jvmmondClient != null) {
            JvmmondNewClient newClient = new JvmmondNewClient(this.hostSpec.getHost(), this.hostSpec.getPort());
            return SocketAdapterFactory.getForSocket(newClient.convertToDebuggingSession(pid, sp));
        }
        SocketAdapter adapter = FileSocketConnection.connectToPid(pid, 10000);
        adapter.getOutputStream().write(JvmmondUtils.getChangeToDebuggingCommand(sp));
        adapter.getInputStream().read(new byte[4]);
        adapter.getOutputStream().write(JDWP_HANDSHAKE);
        adapter.getInputStream().read(new byte[JDWP_HANDSHAKE.length]);
        return adapter;
    }

    public SocketAdapter getMonitoringConnection(BoardWrapper board) throws IOException {
        Vm vm = null;
        VmInternals vmInternals = null;
        int pid = board.getPid();
        if (this.jvmmondClient == null) {
            if (this.remoteProvider == null) {
                if (this.needsLegacy(board)) {
                    vm = Cluster.getVm(pid);
                    vmInternals = InternalsProviderImpl.get().getVmInternalsByProcessId(pid);
                }
            } else {
                vm = this.remoteProvider.getVmForBoard(board);
                vmInternals = this.remoteProvider.getVmInternalsByProcessId(pid);
            }
        }
        if (vm != null) {
            PipedSocket ps = new PipedSocket();
            ControllerFallbacks.simulateProfilingServerForMonitoring(ps.rightSide(), vm, vmInternals);
            return ps.leftSide();
        }
        BoardWrapper current = this.currentBoards.get(pid);
        if (current == null) {
            throw new IOException("VM is already dead");
        }
        if (board.isDifferentProcess(current)) {
            throw new IOException("VM is already dead (process with same pid seems to be different");
        }
        if (this.jvmmondClient == null) {
            return FileSocketConnection.connectToPid(pid, 10000);
        }
        JvmmondNewClient newClient = new JvmmondNewClient(this.hostSpec.getHost(), this.hostSpec.getPort());
        if (!newClient.isConnected()) {
            throw new IOException("Could not connect another jvmmond client");
        }
        Socket socket = newClient.convertToMonitoringSession(pid);
        return socket == null ? null : SocketAdapterFactory.getForSocket(socket);
    }

    public boolean isLocal() {
        return this.localProvider != null;
    }

    public boolean isOldStyle(BoardWrapper board) {
        if (this.jvmmondClient == null && this.remoteProvider != null) {
            return true;
        }
        return this.needsLegacy(board);
    }

    public boolean isOldJvmmond() {
        return this.jvmmondClient == null && this.remoteProvider != null;
    }

    public boolean isConnected() {
        if (this.localProvider != null) {
            return true;
        }
        if (this.remoteProvider != null) {
            return this.remoteProvider.isConnected();
        }
        return this.jvmmondClient != null && this.jvmmondClient.isConnected();
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public String getHost() {
        return this.hostSpec.getHost();
    }

    public int getPort() {
        return this.hostSpec.getPort();
    }

    @Override
    public synchronized void close() {
        this.isDisabled = true;
        this.vms.clear();
        this.toBeRemovedBoards.clear();
    }

    public synchronized boolean isDisabled() {
        return this.isDisabled;
    }

    public int hashCode() {
        return this.hostSpec.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MonitoringController) {
            MonitoringController other = (MonitoringController)obj;
            return this.hostSpec.equals(other.hostSpec);
        }
        return false;
    }

    public String toString() {
        if (this.hostSpec.getHost() == null) {
            return "<local monitoring controller>";
        }
        return "<remote monitoring controller, host: " + this.hostSpec.getHost() + ", port: " + this.hostSpec.getPort() + ", connected: " + this.isConnected() + ">";
    }
}

