/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.BoardChanges;
import com.sap.jvm.inspector.jvmmon.HostSpec;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.inspector.jvmmon.MonitoringListener;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class MonitoringManager {
    private static final MonitoredVm[] EMPTY = new MonitoredVm[0];
    private final Set<MonitoringListener> listeners = new HashSet<MonitoringListener>();
    private final Set<MonitoringListener> newListeners = new HashSet<MonitoringListener>();
    private final Map<HostSpec, MonitoringController> controllers = new HashMap<HostSpec, MonitoringController>();
    private final Map<HostSpec, MonitoringController> toBeAdded = new HashMap<HostSpec, MonitoringController>();
    private final Map<MonitoringController, BoardChanges> pendingChanges = new IdentityHashMap<MonitoringController, BoardChanges>();
    private final Map<MonitoringController, MonitoredVm[]> livingVms = new IdentityHashMap<MonitoringController, MonitoredVm[]>();
    private final int updateInterval;
    private volatile boolean isClosed;

    public MonitoringManager(int updateInterval) {
        this.updateInterval = updateInterval;
        this.runUpdate(updateInterval);
    }

    private synchronized void addController(MonitoringController controller) {
        MonitoringController oldController;
        MonitoringController tbaCon = this.toBeAdded.get(controller.getHostSpec());
        if (tbaCon != null) {
            if (tbaCon == controller) {
                return;
            }
            Trace.get(this.getClass()).warn("Adding monitoring controller " + controller + ", but different controller " + tbaCon + " was to be added.");
            this.toBeAdded.put(controller.getHostSpec(), controller);
        }
        if ((oldController = this.controllers.get(controller.getHostSpec())) != null && !oldController.isDisabled()) {
            Trace.get(this.getClass()).warn("Adding monitoring controller " + controller + ", but old controller " + oldController + " not yet disabled.");
            return;
        }
        this.toBeAdded.put(controller.getHostSpec(), controller);
    }

    private synchronized void removeController(HostSpec spec) {
        MonitoringController oldController;
        if (this.toBeAdded.containsKey(spec)) {
            this.toBeAdded.remove(spec);
        }
        if ((oldController = this.controllers.get(spec)) != null) {
            oldController.close();
        }
    }

    private void notifyListeners(MonitoredVm[] newVms, MonitoredVm[] changedVms, MonitoredVm[] deletedVms) {
        if (!this.isClosed) {
            for (MonitoringListener listener : new ArrayList<MonitoringListener>(this.listeners)) {
                listener.vmChanges(newVms, changedVms, deletedVms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateController(MonitoringController controller) {
        while (!this.isClosed) {
            BoardChanges changes;
            MonitoringManager monitoringManager = this;
            synchronized (monitoringManager) {
                if (!this.pendingChanges.containsKey(controller)) {
                    return;
                }
                changes = this.pendingChanges.get(controller);
            }
            if (changes == null) {
                changes = controller.getChanges();
                monitoringManager = this;
                synchronized (monitoringManager) {
                    this.pendingChanges.put(controller, changes);
                    continue;
                }
            }
            monitoringManager = this;
            synchronized (monitoringManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Trace.warn((Throwable)e, "Got interrupt");
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        MonitoredVm[] deletedVmsArray;
        MonitoredVm[] changedVmsArray;
        MonitoredVm[] newVmsArray;
        if (this.isClosed) {
            return;
        }
        ArrayList<Object> lastVms = new ArrayList<Object>();
        MonitoringManager monitoringManager = this;
        synchronized (monitoringManager) {
            this.notifyAll();
        }
        try {
            Thread.sleep(this.updateInterval / 2);
        }
        catch (InterruptedException e) {
            Trace.warn((Throwable)e, "Got interrupt");
            return;
        }
        MonitoringManager monitoringManager2 = this;
        synchronized (monitoringManager2) {
            for (MonitoringController controller : this.controllers.values()) {
                lastVms.addAll(Arrays.asList((Object[])this.livingVms.get(controller)));
            }
            ArrayList<MonitoredVm> newVms = new ArrayList<MonitoredVm>();
            ArrayList<MonitoredVm> changedVms = new ArrayList<MonitoredVm>();
            ArrayList<MonitoredVm> deletedVms = new ArrayList<MonitoredVm>();
            ArrayList<MonitoringController> removedThisIteration = new ArrayList<MonitoringController>();
            for (MonitoringController controller : this.controllers.values()) {
                BoardChanges changes = this.pendingChanges.get(controller);
                HashMap<Integer, MonitoredVm> currentVms = new HashMap<Integer, MonitoredVm>();
                for (MonitoredVm vm : this.livingVms.get(controller)) {
                    currentVms.put(vm.getBoard().getPid(), vm);
                }
                if (changes != null) {
                    for (Map.Entry entry : changes.newBoards.entrySet()) {
                        MonitoredVm vm = controller.getMonitoredVm((BoardWrapper)entry.getValue());
                        newVms.add(vm);
                        currentVms.put((Integer)entry.getKey(), vm);
                    }
                    for (Map.Entry entry : changes.changedBoards.entrySet()) {
                        changedVms.add(controller.getMonitoredVm((BoardWrapper)entry.getValue()));
                    }
                    for (Map.Entry entry : changes.deletedBoards.entrySet()) {
                        deletedVms.add(controller.getMonitoredVm((BoardWrapper)entry.getValue()));
                        currentVms.remove(entry.getKey());
                    }
                }
                this.livingVms.put(controller, currentVms.values().toArray(new MonitoredVm[currentVms.size()]));
                if (!controller.isDisabled() || currentVms.size() != 0) continue;
                removedThisIteration.add(controller);
            }
            for (MonitoringController controller : removedThisIteration) {
                this.controllers.remove(controller.getHostSpec());
                this.pendingChanges.remove(controller);
                this.livingVms.remove(controller);
            }
            for (MonitoringController controller : this.controllers.values()) {
                this.pendingChanges.put(controller, null);
            }
            if (this.newListeners.size() > 0) {
                newVmsArray = lastVms.toArray(new MonitoredVm[lastVms.size()]);
                for (MonitoringListener listener : new ArrayList<MonitoringListener>(this.newListeners)) {
                    listener.vmChanges(newVmsArray, EMPTY, EMPTY);
                }
            }
            this.listeners.addAll(this.newListeners);
            this.newListeners.clear();
            newVmsArray = newVms.toArray(new MonitoredVm[newVms.size()]);
            changedVmsArray = changedVms.toArray(new MonitoredVm[changedVms.size()]);
            deletedVmsArray = deletedVms.toArray(new MonitoredVm[deletedVms.size()]);
            if (this.toBeAdded.size() > 0) {
                ArrayList<HostSpec> added = new ArrayList<HostSpec>();
                for (HostSpec hsToAdd : this.toBeAdded.keySet()) {
                    if (this.controllers.containsKey(hsToAdd)) continue;
                    final MonitoringController mcToAdd = this.toBeAdded.get(hsToAdd);
                    this.controllers.put(hsToAdd, mcToAdd);
                    this.pendingChanges.put(mcToAdd, null);
                    this.livingVms.put(mcToAdd, new MonitoredVm[0]);
                    added.add(hsToAdd);
                    ThreadRunner.run(new Runnable(){

                        @Override
                        public void run() {
                            MonitoringManager.this.updateController(mcToAdd);
                        }
                    });
                }
                for (HostSpec hs : added) {
                    this.toBeAdded.remove(hs);
                }
            }
        }
        this.notifyListeners(newVmsArray, changedVmsArray, deletedVmsArray);
        this.runUpdate(this.updateInterval / 2);
    }

    private void runUpdate(final long interval) {
        ThreadRunner.run(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    Trace.warn((Throwable)e, "Got interrupt");
                }
                MonitoringManager.this.update();
            }
        });
    }

    public synchronized void close() {
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public void addLocal() throws IOException {
        this.addController(new MonitoringController());
    }

    public void addRemote(String host, int port, PasswordSupplier passwordSupplier) throws IOException {
        this.addController(new MonitoringController(host, port, passwordSupplier, true));
    }

    public void removeRemote(String host, int port) {
        this.removeController(new HostSpec(host, port));
    }

    public HostSpec[] getRemoteHosts() {
        ArrayList<HostSpec> result = new ArrayList<HostSpec>();
        for (HostSpec hs : this.controllers.keySet()) {
            if (hs.getHost() == null) continue;
            result.add(hs);
        }
        return result.toArray(new HostSpec[result.size()]);
    }

    public synchronized void addListener(MonitoringListener listener) {
        if (!this.listeners.contains(listener)) {
            this.newListeners.add(listener);
        }
    }

    public synchronized void removeListener(MonitoringListener listener) {
        this.listeners.remove(listener);
        this.newListeners.remove(listener);
    }
}

