/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringListener;
import com.sap.jvm.inspector.jvmmon.MonitoringManager;
import java.io.IOException;

public class ProfilingServerCommunicationTest
implements MonitoringListener {
    public static void main(String[] args) throws Exception {
        MonitoringManager manager = new MonitoringManager(1000);
        manager.addListener(new ProfilingServerCommunicationTest());
        manager.addLocal();
        Thread.sleep(100000000000L);
    }

    @Override
    public void vmChanges(MonitoredVm[] newVms, MonitoredVm[] changedVms, MonitoredVm[] deletedVms) {
        for (MonitoredVm vm : newVms) {
            String name = vm.getBoard().getString("JAVA_MAINCLASS", "UNKNOWN MAIN CLASS");
            System.out.println(name);
            if (!name.contains("JvmMon")) continue;
            try {
                for (int i = 0; i < 2; ++i) {
                    boolean dumpOnly = i == 0;
                    vm.getStackTrace(dumpOnly, false, null);
                    vm.getStackTrace(dumpOnly, true, null);
                    vm.getClassStatistic(dumpOnly, false);
                    vm.getClassStatistic(dumpOnly, true);
                    vm.getCodeBlobs(dumpOnly, null, false);
                    vm.getCodeBlobs(dumpOnly, null, true);
                    vm.getCodeBlobs(dumpOnly, "java.util.*", false);
                    vm.getCodeBlobs(dumpOnly, "java.util.*", true);
                    vm.getHsInfo(dumpOnly);
                    vm.getDllInfo(dumpOnly);
                    vm.getSymbolInfo(dumpOnly, 0);
                    vm.getSymbolInfo(dumpOnly, 10);
                    vm.getGcHistory(dumpOnly);
                    vm.getFlightRecorder(dumpOnly, 0);
                    vm.getFlightRecorder(dumpOnly, 10);
                }
                vm.deoptimizeMethod("java.util");
                vm.deoptimizeMethod("");
                vm.deoptimizeAllMethods();
                vm.forceOsrCompile("this.is.no.method()", 0);
                vm.forceOsrCompile("java.lang.String.toString()java.lang.String", 0);
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

