/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.util.misc.UTF8Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class SimplePacketReader {
    private int[] ends = new int[20];
    private int[] tags = new int[20];
    private int depth = 0;
    private DataInputStream dis;
    private int offset = 0;

    public SimplePacketReader(InputStream is) {
        this.dis = new DataInputStream(is);
    }

    public void detach() throws IOException {
        while (this.depth > 0) {
            this.finishPacket();
        }
        this.dis = null;
    }

    public void close() throws IOException {
        this.dis.close();
    }

    private void checkActivePacket(int toRead) throws IOException {
        if (this.depth <= 0) {
            throw new IOException("No active packet");
        }
        if (this.offset + toRead > this.ends[this.depth - 1]) {
            throw new IOException("End of packet is reached");
        }
    }

    public boolean hasMoreData() {
        return this.depth > 0 && this.offset < this.ends[this.depth - 1];
    }

    public boolean hasMoreData(int toRead) {
        return this.depth > 0 && this.offset + toRead <= this.ends[this.depth - 1];
    }

    public int getPacket() throws IOException {
        if (this.depth >= this.ends.length) {
            assert (this.tags.length == this.ends.length);
            int[] newEnds = new int[this.ends.length * 2];
            System.arraycopy(this.ends, 0, newEnds, 0, this.ends.length);
            this.ends = newEnds;
            int[] newTags = new int[this.tags.length * 2];
            System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
            this.tags = newTags;
        }
        int size = this.dis.readInt();
        int tag = this.dis.readInt();
        this.ends[this.depth] = this.offset + size;
        this.tags[this.depth] = tag;
        this.offset += 8;
        ++this.depth;
        return tag;
    }

    public void finishPacket() throws IOException {
        if (this.depth <= 0) {
            throw new IOException("No active packet");
        }
        --this.depth;
        this.dis.skip(this.ends[this.depth] - this.offset);
        this.offset = this.ends[this.depth];
        if (this.depth == 0) {
            this.offset = 0;
        }
    }

    public String[] readException() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        boolean hasData = false;
        while (hasData) {
            int nrOfStackTraces = this.readInt32();
            lines.add(this.readString() + ": " + this.readString());
            for (int i = 0; i < nrOfStackTraces; ++i) {
                lines.add("    " + this.readString());
            }
            hasData = this.readBoolean();
            if (!hasData) continue;
            lines.add("Caused by:");
        }
        return lines.toArray(new String[lines.size()]);
    }

    public boolean readBoolean() throws IOException {
        return this.readInt8() != 0;
    }

    public byte readInt8() throws IOException {
        this.checkActivePacket(1);
        ++this.offset;
        return this.dis.readByte();
    }

    public short readInt16() throws IOException {
        this.checkActivePacket(2);
        this.offset += 2;
        return this.dis.readShort();
    }

    public char readUint16() throws IOException {
        this.checkActivePacket(2);
        this.offset += 2;
        return this.dis.readChar();
    }

    public int readInt32() throws IOException {
        this.checkActivePacket(4);
        this.offset += 4;
        return this.dis.readInt();
    }

    public long readInt64() throws IOException {
        this.checkActivePacket(8);
        this.offset += 8;
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        this.checkActivePacket(4);
        this.offset += 4;
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        this.checkActivePacket(8);
        this.offset += 8;
        return this.dis.readDouble();
    }

    public String readString() throws IOException {
        char len = this.readUint16();
        byte[] utf = new byte[len];
        this.readBytes(utf);
        return UTF8Util.asString(utf);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] result = new byte[length];
        this.readBytes(result);
        return result;
    }

    public void readBytes(byte[] bytes) throws IOException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int off, int len) throws IOException {
        this.checkActivePacket(len);
        this.offset += len;
        this.dis.readFully(bytes, off, len);
    }
}

