/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.inspector.jvmmon;

import com.sap.jvm.util.misc.ByteConverter;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class SimplePacketWriter {
    private int[] starts;
    private int[] tags;
    private int depth;
    private OutputStream os;
    private byte[] buffer;
    private int offset;

    public SimplePacketWriter(OutputStream os) {
        this.os = os;
        this.buffer = new byte[8192];
        this.starts = new int[20];
        this.tags = new int[20];
    }

    public void detach() throws IOException {
        while (this.depth > 0) {
            this.endPacket(this.tags[this.depth - 1]);
        }
        this.os = null;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void startPacket(int tag) {
        if (this.depth >= this.starts.length) {
            assert (this.tags.length == this.starts.length);
            int[] newStarts = new int[this.starts.length * 2];
            System.arraycopy(this.starts, 0, newStarts, 0, this.starts.length);
            this.starts = newStarts;
            int[] newTags = new int[this.tags.length * 2];
            System.arraycopy(this.tags, 0, newTags, 0, this.tags.length);
            this.tags = newTags;
        }
        this.starts[this.depth] = this.offset;
        this.tags[this.depth] = tag;
        ++this.depth;
        this.offset += 8;
    }

    public void endPacket(int tag) throws IOException {
        if (this.depth <= 0) {
            throw new IOException("No active packet");
        }
        if (this.tags[this.depth - 1] != tag) {
            throw new IOException("Expected tag " + this.tags[this.depth - 1] + " but got " + tag);
        }
        int oldOffset = this.offset;
        this.offset = this.starts[this.depth - 1];
        this.writeInt32(oldOffset - this.offset);
        this.writeInt32(tag);
        this.offset = oldOffset;
        --this.depth;
        if (this.depth == 0) {
            this.os.write(this.buffer, 0, this.offset);
            this.os.flush();
            this.offset = 0;
        }
    }

    private void ensureLength(int length) {
        while (this.offset + length >= this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    private void checkActivePacket() throws IOException {
        if (this.depth <= 0) {
            throw new IOException("Not active packet");
        }
    }

    public void writeException(Throwable t) throws IOException {
        this.writeBoolean(t != null);
        if (t != null) {
            StackTraceElement[] elements = t.getStackTrace();
            this.writeInt32(elements.length);
            this.writeString(t.getClass().getName());
            this.writeString(t.getMessage());
            for (StackTraceElement e : elements) {
                this.writeString(e.toString());
            }
            Throwable c = t.getCause();
            this.writeBoolean(c != null);
            if (c != null) {
                this.writeException(c);
            }
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeInt8(value ? (byte)1 : 0);
    }

    public void writeInt8(byte value) throws IOException {
        this.checkActivePacket();
        this.ensureLength(1);
        this.buffer[this.offset] = value;
        ++this.offset;
    }

    public void writeUint16(char value) throws IOException {
        this.checkActivePacket();
        this.ensureLength(2);
        ByteConverter.writeUint16(this.buffer, this.offset, value);
        this.offset += 2;
    }

    public void writeInt16(short value) throws IOException {
        this.checkActivePacket();
        this.ensureLength(2);
        ByteConverter.writeInt16(this.buffer, this.offset, value);
        this.offset += 2;
    }

    public void writeInt32(int value) throws IOException {
        this.checkActivePacket();
        this.ensureLength(4);
        ByteConverter.writeInt32(this.buffer, this.offset, value);
        this.offset += 4;
    }

    public void writeInt64(long value) throws IOException {
        this.checkActivePacket();
        this.ensureLength(8);
        ByteConverter.writeInt64(this.buffer, this.offset, value);
        this.offset += 8;
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt32(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeInt64(Double.doubleToLongBits(value));
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.writeString("");
            return;
        }
        byte[] utf = UTF8Util.modifiedUTF8(value);
        int length = utf.length;
        if (length > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + length + " bytes");
        }
        this.writeUint16((char)length);
        this.writeBytes(utf, 0, length);
    }

    public void writeBytes(byte[] data) throws IOException {
        this.writeBytes(data, 0, data.length);
    }

    public void writeBytes(byte[] data, int off, int len) throws IOException {
        this.checkActivePacket();
        this.ensureLength(len);
        System.arraycopy(data, off, this.buffer, this.offset, len);
        this.offset += len;
    }
}

