/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.internal;

import java.security.AccessController;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;

public class InternalAPIServiceLoader<S> {
    protected ServiceLoader<S> serviceLoader;

    protected InternalAPIServiceLoader(ServiceLoader<S> sl) {
        this.serviceLoader = sl;
    }

    public static <S> InternalAPIServiceLoader<S> load(Class<S> service) {
        ServiceLoader sl = AccessController.doPrivileged(() -> ServiceLoader.load(service));
        return new InternalAPIServiceLoader<S>(sl);
    }

    public Optional<S> findFirst() {
        Iterator iterator = this.serviceLoader.iterator();
        if (iterator.hasNext()) {
            return AccessController.doPrivileged(() -> Optional.of(iterator.next()));
        }
        return Optional.empty();
    }
}

