/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.management.impl;

import com.sap.jvm.management.GcProblemReportingMXBean;
import javax.management.ObjectName;
import sun.management.Util;

public class GcProblemReporting
implements GcProblemReportingMXBean {
    private static final long SHORT_PERIOD = 60000L;
    private static final long MEDIUM_PERIOD = 300000L;
    private static final long LONG_PERIOD = 900000L;

    @Override
    public double[] getConcurrentGcRatio() {
        long now = System.currentTimeMillis();
        double[] result = new double[]{GcProblemReporting.getConcGcRatio(now - 60000L, now), GcProblemReporting.getConcGcRatio(now - 300000L, now), GcProblemReporting.getConcGcRatio(now - 900000L, now)};
        return result;
    }

    @Override
    public double[] getGcRatio() {
        long now = System.currentTimeMillis();
        double[] result = new double[]{GcProblemReporting.getGcRatio(now - 60000L, now), GcProblemReporting.getGcRatio(now - 300000L, now), GcProblemReporting.getGcRatio(now - 900000L, now)};
        return result;
    }

    @Override
    public int[] getGcSpinningDueToJavaHeap() {
        long now = System.currentTimeMillis();
        int[] result = new int[]{GcProblemReporting.getGcSpinningDueToJavaHeap(now - 60000L, now), GcProblemReporting.getGcSpinningDueToJavaHeap(now - 300000L, now), GcProblemReporting.getGcSpinningDueToJavaHeap(now - 900000L, now)};
        return result;
    }

    @Override
    public int[] getGcSpinningDueToPermGen() {
        long now = System.currentTimeMillis();
        int[] result = new int[]{GcProblemReporting.getGcSpinningDueToPermGen(now - 60000L, now), GcProblemReporting.getGcSpinningDueToPermGen(now - 300000L, now), GcProblemReporting.getGcSpinningDueToPermGen(now - 900000L, now)};
        return result;
    }

    @Override
    public int[] getJavaHeapMemoryShortages() {
        long now = System.currentTimeMillis();
        int[] result = new int[]{GcProblemReporting.getJavaHeapMemoryShortages(now - 60000L, now), GcProblemReporting.getJavaHeapMemoryShortages(now - 300000L, now), GcProblemReporting.getJavaHeapMemoryShortages(now - 900000L, now)};
        return result;
    }

    @Override
    public int[] getOutOfMemoryErrorCount() {
        long now = System.currentTimeMillis();
        int[] result = new int[]{GcProblemReporting.getOutOfMemoryErrorCount(now - 60000L, now), GcProblemReporting.getOutOfMemoryErrorCount(now - 300000L, now), GcProblemReporting.getOutOfMemoryErrorCount(now - 900000L, now)};
        return result;
    }

    @Override
    public int[] getPermGenMemoryShortages() {
        long now = System.currentTimeMillis();
        int[] result = new int[]{GcProblemReporting.getPermGenMemoryShortages(now - 60000L, now), GcProblemReporting.getPermGenMemoryShortages(now - 300000L, now), GcProblemReporting.getPermGenMemoryShortages(now - 900000L, now)};
        return result;
    }

    @Override
    public native long getOldGenMemoryConsumptionAfterLastGc();

    @Override
    public native long getPermGenMemoryConsumptionAfterLastGc();

    @Override
    public native long getMaxOldGenSize();

    @Override
    public native long getMaxPermGenSize();

    @Override
    public double getOldGenMemoryConsumptionAfterLastGcRatio() {
        long max = this.getMaxOldGenSize();
        return max == 0L ? 0.0 : (double)this.getOldGenMemoryConsumptionAfterLastGc() / (double)max;
    }

    @Override
    public double getPermGenMemoryConsumptionAfterLastGcRatio() {
        long max = this.getMaxPermGenSize();
        return max == 0L ? 0.0 : (double)this.getPermGenMemoryConsumptionAfterLastGc() / (double)max;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("sap.management:type=GcProblemReporting");
    }

    private static native double getConcGcRatio(long var0, long var2);

    private static native double getGcRatio(long var0, long var2);

    private static native int getGcSpinningDueToJavaHeap(long var0, long var2);

    private static native int getGcSpinningDueToPermGen(long var0, long var2);

    private static native int getJavaHeapMemoryShortages(long var0, long var2);

    private static native int getOutOfMemoryErrorCount(long var0, long var2);

    private static native int getPermGenMemoryShortages(long var0, long var2);
}

